# GUI For ufw (Uncomplicated FireWall) - Version 0.20.7
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import commands
import gtk
import string
import sys
import locale
import gettext

_ = gettext.gettext

from variables_paths_messages import *





# Search string in file
def file_search_string(p_file, p_string):
    try:
        l_file = open(p_file, "r") 
    except IOError:
        return c_error

    while True:
        l_line = (l_file.readline()).upper()
        if not l_line: break
        
        if l_line.find(p_string.upper()) != -1:
            l_file.close()
            return c_found
                    
    l_file.close()
    return c_not_found
    


# Copy the actual rules file
def save_rules_file():
    commands.getstatusoutput("cp -f " + path_ufw_rules_ipv4 + " " + path_rules_ipv4_compare)
    commands.getstatusoutput("cp -f " + path_ufw_rules_ipv6 + " " + path_rules_ipv6_compare)



# Load file to list
def file_to_list(p_file, p_list):
    try:
        l_file = open(p_file, "r") 
    except IOError:
        return c_error

    while True:
        l_line = l_file.readline()
        if not l_line: break
        
        p_list.append(l_line)
                            
    l_file.close()


# Compare a file
def file_compare(p_source,p_fate):
    l_return = commands.getstatusoutput("diff " + p_source + " " + p_fate)
    return l_return[0]


# Replace string in file
def file_replace_string(p_file, p_string_source, p_string_fate):

    l_lines = []
    if file_to_list(p_file,l_lines) == c_error:
        return c_error
    
    try:
        l_file = open(p_file, "w")
    except IOError:
        return c_error
            
    for l_line in l_lines:
        if l_line.find(p_string_source) != -1:
            l_line = l_line.replace(p_string_source,p_string_fate)
        l_file.write(l_line)
                            
    l_file.close()
    
    return c_ok
    

# Dialog OPEN/SAVE and return the file or None.
# P_dialog = 0 -> Open   //   P_dialog = 1 -> Save
def dialog_file(p_dialog):
    
    # Open file for import
    if p_dialog == 0:
        dialog = gtk.FileChooserDialog(_(text_070),
                                       None,
                                       gtk.FILE_CHOOSER_ACTION_OPEN,
                                      (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                       gtk.STOCK_OPEN, gtk.RESPONSE_OK))
                                       
    # Save file for export
    elif p_dialog == 1:
        dialog = gtk.FileChooserDialog(_(text_071),
                                       None,
                                       gtk.FILE_CHOOSER_ACTION_SAVE,
                                      (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                       gtk.STOCK_SAVE, gtk.RESPONSE_OK))
        
    # Open file for banning rules
    else:
        dialog = gtk.FileChooserDialog(_(text_072),
                                       None,
                                       gtk.FILE_CHOOSER_ACTION_OPEN,
                                      (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                       gtk.STOCK_OPEN, gtk.RESPONSE_OK))
                                      
                                       
    dialog.set_default_response(gtk.RESPONSE_CANCEL)
    response = dialog.run()

    l_file = c_none
    if response == gtk.RESPONSE_OK:
        if dialog.get_filename() != "":
            l_file = dialog.get_filename()

    dialog.destroy()
    return l_file


# Add a line to file
def file_add_line(p_file,p_line):
    
    l_lines = []
    if file_to_list(p_file,l_lines) == c_error:
        return
    
    try:
        l_file = open(p_file, "w")
    except IOerror:
        return
    
    for line in l_lines:
        l_file.write(line)
            
    l_file.write(p_line)
    l_file.close()


# Search a string in a list
def list_search_string(p_list,p_string):
    for l_line in p_list:
        if isinstance(l_line,str):
            if l_line.upper().find(p_string.upper()) != -1:
                return c_found # Found string
                    
    return c_not_found # Not found string




# Compare currently and before rules.
# True -> Rules changed / False -> Rules deleted
def changed_rules():
    l_return1 = file_compare(path_ufw_rules_ipv4,path_rules_ipv4_compare)
    l_return2 = file_compare(path_ufw_rules_ipv6,path_rules_ipv6_compare)
    
    if ( l_return1 == 0 ) and ( l_return2 == 0 ):
        return False
    else:
        return True

