# -*- coding: utf-8 -*-
# Gufw 13.10.2 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

DIR_PROFILES  = '/etc/gufw/app_profiles'
DIR_MEDIA     = '/usr/share/gufw/media/'
SHIELDS_DIR   = DIR_MEDIA + 'shields/'
TUTORIAL_FILE = DIR_MEDIA + 'tutorial/index.html'
REFRESH_TIME  = 1250 # Milliseconds refresh listening report

FONT   = 'ubuntu 10'
GRAY   = '#BAB5AB'
GREEN  = '#267726'
RED    = '#DF421E'
ORANGE = '#D1940C'
BLUE   = '#314E6C'
BLACK  = '#000000'

URL_DOC           = 'http://help.ubuntu.com/community/Gufw'
URL_ANSWERS       = 'http://answers.launchpad.net/gui-ufw'
URL_BUGS          = 'http://bugs.launchpad.net/gui-ufw'
URL_TRANSLATIONS  = 'https://translations.launchpad.net/gui-ufw'
URL_TWITTER       = 'http://twitter.com/gufw'
URL_IDENTICA      = 'http://identi.ca/gufw'
URL_GPLUS         = 'http://plus.google.com/b/104342291112771981280/'
URL_GPLUSCOMUNITY = 'http://plus.google.com/communities/104067858618275933076'
URL_DONATE        = 'http://gufw.org/donate'

POLICY2NUM =    {'allow'    : 0,
                 'deny'     : 1,
                 'reject'   : 2,
                 'limit'    : 3 }
POLICY2COLOR =  {'allow'    : RED,
                 'deny'     : GREEN,
                 'reject'   : BLUE,
                 'limit'    : ORANGE,
                 'disabled' : GRAY,
                 'others'   : BLACK}
UFW_LEVEL2NUM = {'off'      : 0,
                 'low'      : 1,
                 'medium'   : 2,
                 'high'     : 3,
                 'full'     : 4}
DIRECTION2NUM = {'in'       : 0,
                 'out'      : 1,
                 'both'     : 1}
PROTO2NUM =     {''         : 0,
                 'tcp'      : 1,
                 'udp'      : 2 }
LOGGING2NUM =   {''         : 0,
                 'log'      : 1,
                 'log-all'  : 2}
                 
NUM2UFW_LEVEL = {0 : 'off',
                 1 : 'low',
                 2 : 'medium',
                 3 : 'high',
                 4 : 'full'}
NUM2POLICY =    {0 : 'allow',
                 1 : 'deny',
                 2 : 'reject',
                 3 : 'limit' }
NUM2DIRECTION = {0 : 'in',
                 1 : 'out',
                 2 : 'both'}
NUM2PROTO =     {0 : '',
                 1 : 'tcp',
                 2 : 'udp' }
NUM2LOGGING =   {0 : '',
                 1 : 'log',
                 2 : 'log-all'}
