//$Id: pushbutton-canvas.cc,v 1.30 2004/01/20 22:52:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton-canvas.h"

#include "form-editor.h"
#include "form-editor-canvas.h"
#include "resizeable-ops.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

PushButtonCanvasItem::PushButtonCanvasItem (Widgets::PushButton *widget_,
					    Gnome::CanvasGroup  *parent_group):
    CanvasItem (widget_, parent_group),
    WidgetCanvasItem (widget_, parent_group),
    ResizeableCanvasItem (widget_, parent_group, new WidgetOps::ResizeOpFactory (widget_)),
    widget (widget_),
    group (0)
{
    widget->bitmap_id.resource_changed.connect (
	SigC::slot (this, &PushButtonCanvasItem::update));
    update ();
}

void PushButtonCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*draw_group, 0, 0);
    
    int width = widget->get_width ();
    int height = widget->get_height ();

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->x - 1;
    int x2 = x1 + width + 1;
    int y1 = widget->y - 1;
    int y2 = y1 + height + 1;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    using namespace Gnome::CanvasHelpers;

    *(FormEditor::draw_rectangle (*group, x1, y1, x2, y2))
	<< width_units (1)
	<< outline_color (get_foreground_color (widget->usable));

    int text_x = x1 + 1;
    int text_y = y1 + 1;

    if (widget->bitmap_id == "" && widget->selected_bitmap_id == "")
	draw_text (*group,
		   widget->text, get_font (widget->font),
		   get_foreground_color (widget->usable),
		   text_x, text_y, width, height);
    else
        draw_bitmapref (*group, widget->bitmap_id,
                        widget->get_manager ()->get_target ()->screen_color,
                        get_background_color (),
                        widget->x , widget->y,
                        widget->get_width (), widget->get_height (),
                        GTK_ANCHOR_CENTER);
    
    set_canvas_item (group);
}

void PushButtonCanvasItem::get_bounds (int &x1, int &y1,
				       int &x2, int &y2)
{
    x1 = widget->x + 1;
    x2 = x1 + widget->get_width () - 3;
    y1 = widget->y + 1;
    y2 = y1 + widget->get_height () - 1;
}
