//$Id: filechooserdialog.cc,v 1.3 2006/10/06 22:35:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2006 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widgets/filechooserdialog.h"

#include "config.h"
#include "io/guikachu-io.h"

#include <gtkmm/stock.h>

using namespace Guikachu::GUI;

FileChooserDialog::FileChooserDialog (Gtk::Window            &parent_window,
                                      const Glib::ustring    &title,
                                      Gtk::FileChooserAction  action) :
    Gtk::FileChooserDialog (parent_window, title, action)
{
    add_button (Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
    set_default_response (Gtk::RESPONSE_ACCEPT);

    switch (action)
    {
    case Gtk::FILE_CHOOSER_ACTION_OPEN:
        add_button (Gtk::Stock::OPEN, Gtk::RESPONSE_ACCEPT);
        break;
    case Gtk::FILE_CHOOSER_ACTION_SAVE:
        add_button (Gtk::Stock::SAVE, Gtk::RESPONSE_ACCEPT);
        break;
    default:
        g_assert_not_reached ();
    }

#ifdef GUIKACHU_HAVE_GNOMEVFS
    set_local_only (false);
#else
    set_local_only (true);
#endif
}

Glib::ustring FileChooserDialog::get_uri () const
{
    return IO::create_canonical_uri (Gtk::FileChooserDialog::get_uri ());
}
