//  /***************************************************************************
//                            LibraryDialog.cpp  -  description
//                               -------------------
//      begin                : Sat Aug 19 2000
//      copyright            : (C) 2000, 2001 by llornkcor
//      email                : ljp@llornkcor.com
//                            ***************************************************/
//  /***************************************************************************
//   *                                                                         *
//   *   This program is free software; you can redistribute it and/or modify  *
//   *   it under the terms of the GNU General Public License as published by  *
//   *   the Free Software Foundation; either version 2 of the License, or     *
//   *   (at your option) any later version.                                   *
//   *                                                                         *
//   ***************************************************************************/
#include "LibraryDialog.h"
#include "CConfigFile.h"
#include <qregexp.h>
//#include "ftplib.h"
#include "SearchResults.h"

#include <qstringlist.h>
#include <qheader.h>
#include <qdir.h>
#include <qtabwidget.h>
#include <qclipboard.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qwidget.h>
//#include <qlayout.h>
#include <qvariant.h>
#if defined(_WS_WIN_)
#include <windows.h>
#endif

/*
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog. */
LibraryDialog::LibraryDialog( QWidget* parent,  const char* name /*, bool modal, WFlags fl*/ )
        : QDialog( parent, name, true/* modal, fl*/ )
{
    if ( !name )
        setName( "LibraryDialog" );
    initDialog();

    index = "GUTINDEX.ALL";
    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    local_index = local_library + index;
    QString iniFile ;
    iniFile = local_library+"gutenbrowserrc";
    new_index = local_library + "PGWHOLE.TXT";
    if( !QFile(new_index).exists() )
        new_index="/usr/share/doc/gutenbrowser/PGWHOLE.TXT";
    old_index = local_library + "GUTINDEX.ALL";

    config = new CConfigFile( iniFile);
    config->read();

    config->setGroup( "HttpServer" );
    proxy_http = config->readEntry("Preferred", "http://sailor.gutenbook.org");

    config->setGroup( "FTPsite" );
    ftp_host=config->readEntry("SiteName", "sailor.gutenberg.org");

    ftp_host=ftp_host.right(ftp_host.length()-(ftp_host.find(") ",0,TRUE)+1) );
    ftp_host=ftp_host.stripWhiteSpace();
    //ftp_host=ftp_host.right(ftp_host.length()-(ftp_host.find(")        ",0,TRUE)+1) );
    qDebug("Selected site host is:%s", ftp_host.latin1());
    ftp_base_dir= config->readEntry("base",  "/pub/gutenberg");

    config->setGroup( "Proxy" );
    if( config->readEntry("IsChecked", "FALSE") == "TRUE")
        httpBox->setChecked( TRUE );
    i_binary = 0;

    config->setGroup("SortAuth");
    if( config->readEntry("authSort", "FALSE") == "TRUE")
        authBox->setChecked(TRUE);
    newindexLib.setName( new_index);
    indexLib.setName( old_index);

    Newlibrary();
}

LibraryDialog::~LibraryDialog()
{
    saveConfig();
}

/*This groks using PGWHOLE.TXT */
void  LibraryDialog::Newlibrary() {
    if ( newindexLib.open( IO_ReadOnly) ) {
        setCaption( tr( "Library Index - using master pg index."  ) );// file opened successfully
        QTextStream indexStream( &newindexLib );
        QString indexLine;
        while ( !indexStream.atEnd() )  { // until end of file..
            indexLine = indexStream.readLine();
            if ( ( indexLine.mid(4,4)).toInt() && !( indexLine.left(3)).toInt())  {
                year = indexLine.mid(4,4);
                year = year.stripWhiteSpace();
                file = indexLine.mid( indexLine.find( "[", 0, TRUE )+1, 12 );
                file = file.stripWhiteSpace();
                number = indexLine.mid(  indexLine.find( "]", 0, TRUE ) +1, indexLine.find( " ", 0, TRUE )+1 );
                if( year.toInt() < 1984)
                    number = number.left( number.length() -1 );
                number = number.stripWhiteSpace();
                title = indexLine.mid( indexLine.find(" ", 26, TRUE), indexLine.length() );
                title = title.stripWhiteSpace();

                getAuthor();  // groks author
                author = author.stripWhiteSpace();
                if (authBox->isChecked() == TRUE) { // this reverses the first name and last name of the author
                    QString lastName, firstName="";
                    int finder=author.findRev( ' ', -1, TRUE);
                    lastName=author.right( author.length()-finder);
                    firstName=author.left(finder);
                    lastName=lastName.stripWhiteSpace();
                    firstName=firstName.stripWhiteSpace();

                    if( lastName.find( firstName, 0, true)  == -1) // this avoids dup names
                        author=lastName+", "+firstName;
                }

                if( !number.isEmpty() && (title.find( "reserved",0, FALSE) == -1) && (file.find( "]",0, TRUE) == -1) ) {
                      // fill string list or something to be able to resort the whole library
                    if( author.isEmpty() )
                        QList_Item5 = new QListViewItem( ListView5,  number, title, author, year, file );
                    else {
                        ///////////   heh... not much of an regexpresser, eh?
                        ///////////  HELP WANTED sort by all headers, not just author here..

                        if(  (author.left(1) >= QString("A") && author.left(1) <= QString("F")) ||
                             (author.left(1) >= QString("a")  && author.left(1) <= QString("f")) )
                            QList_Item1 = new QListViewItem( ListView1,  number, title, author, year, file );

                        else if( (author.left(1) >= QString("G") && author.left(1) <= QString("M")) ||
                                 (author.left(1) >= QString("g") && author.left(1) <= QString("m")) )
                            QList_Item2 = new QListViewItem( ListView2,  number, title, author, year, file );

                        else if( (author.left(1) >= QString("N") && author.left(1) <= QString("R")) ||
                                 (author.left(1) >= QString("n") && author.left(1) <= QString("r")) )
                            QList_Item3 = new QListViewItem( ListView3,  number, title, author, year, file );

                        else if( (author.left(1) >= QString("S") && author.left(1) <= QString("Z")) ||
                                 (author.left(1) >= QString("s") && author.left(1) <= QString("z")) )
                            QList_Item4 = new QListViewItem( ListView4,  number, title, author, year, file );

                        else
                            QList_Item5 = new QListViewItem( ListView5,  number, title, author, year, file );
                    }
                }
            }// end if
        }// end while
        newindexLib.close();
    }
    else if ( indexLib.open( IO_ReadOnly) ) {
          // if GUTINDEX.ALL file opened successfully
        setCaption( tr( "Library Index - using ftp index."  ) );
        Library(); //parse it instead
    } else {
        QString sMsg;
        sMsg = ( tr("Error opening new library index: "))+new_index;
        QMessageBox::message( "Error",sMsg);
    }
} // end Newlibrary()

void LibraryDialog::Library()
{// old library groking method
    // open GUTINDEX.ALL file
    IDontKnowWhy = "";
    if ( indexLib.open( IO_ReadOnly) ) {  // file opened successfully
        QTextStream indexStream( &indexLib );
        QString indexLine;
        while ( !indexStream.eof() ) { // until end of file..
            indexLine = indexStream.readLine();
            if ( indexLine != "") {
                if( (indexLine.mid(4,4)).toInt() && !( indexLine.left(3)).toInt() ) {
                    month = indexLine.left( 3);
                    year = indexLine.mid(4,4);
                    title = indexLine.mid( 9, 50);
                    getAuthor();
                    file = indexLine.mid(60,12 );
                    number = indexLine.mid(73,5 );
                    number = number.stripWhiteSpace();
                    title = indexLine.mid( indexLine.find(" ", 26, TRUE), indexLine.length() );
                    title = title.stripWhiteSpace();

                    getAuthor();  // grok author
                    author = author.stripWhiteSpace();
                    if (authBox->isChecked() == TRUE) { // this reverses the first name and last name of the author
                    QString lastName, firstName="";
                    int finder=author.findRev( ' ', -1, TRUE);
                    lastName=author.right( author.length()-finder);
                    firstName=author.left(finder);
                    lastName=lastName.stripWhiteSpace();
                    firstName=firstName.stripWhiteSpace();

                    if( lastName.find( firstName, 0, true)  == -1) // this avoids dup names
                        author=lastName+", "+firstName;
                    }

                    if( !number.isEmpty() && (title.find( "reserved",0, FALSE) == -1) && (file.find( "]",0, TRUE)) ) {
                          // fill string list or something to be able to sort by Author
                        if( author.isEmpty() )
                            QList_Item5 = new QListViewItem( ListView5,  number, title, author, year, file );
                        else  {
                            if(  (author.left(1) >= QString("A") && author.left(1) <= QString("F")) ||
                                 (author.left(1) >= QString("a")  && author.left(1) <= QString("f")) )
                                QList_Item1 = new QListViewItem( ListView1,  number, title, author, year, file );

                            else if( (author.left(1) >= QString("G") && author.left(1) <= QString("M")) ||
                                     (author.left(1) >= QString("g") && author.left(1) <= QString("m")) )
                                QList_Item2 = new QListViewItem( ListView2,  number, title, author, year, file );

                            else if( (author.left(1) >= QString("N") && author.left(1) <= QString("R")) ||
                                     (author.left(1) >= QString("n") && author.left(1) <= QString("r")) )
                                QList_Item3 = new QListViewItem( ListView3,  number, title, author, year, file );

                            else if( (author.left(1) >= QString("S") && author.left(1) <= QString("Z")) ||
                                     (author.left(1) >= QString("s") && author.left(1) <= QString("z")) )
                                QList_Item4 = new QListViewItem( ListView4,  number, title, author, year, file );

                            else
                                QList_Item5 = new QListViewItem( ListView5,  number, title, author, year, file );
                        }

                    }
                }
            }
        }
        indexLib.close();
    }
    else {
        QString sMsg;
        sMsg = ( tr("Error opening local library index: "))+local_index;
        QMessageBox::message( "Error",sMsg);
    }
} //end Library()


/*
  Groks the author out of the title */
bool LibraryDialog::getAuthor()
{
    if( title.contains( ", by", TRUE)) {
        int auth;
        auth = title.find(", by", 0, TRUE);
        author = title.right(title.length() - (auth + 4) );
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left(finder);
        }
    }
    else if ( title.contains( "by, ", TRUE) ) {
        int auth;
        auth = title.find("by, ", 0, TRUE);
        author = title.right(title.length() - (auth + 4) );
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( " by", TRUE) ) {
        int auth;
        auth = title.find(" by", 0, TRUE);
        author = title.right(title.length() - (auth + 3) );
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "by ", TRUE) ) {
        int auth;
        auth = title.find("by ", 0, TRUE);
        author = title.right(title.length() - (auth + 3) );
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( ",", TRUE) ) {
        int auth;
        auth = title.find(",", 0, TRUE);
        author = title.right( title.length() - (auth + 1) );
        if ( author.contains( ",", TRUE) ) {
            int auth;
            auth = author.find(",", 0, TRUE);
            author = author.right( author.length() - (auth + 1) );
        }
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "/", TRUE) ) {
        int auth;
        auth = title.find("/", 0, TRUE);
        author = title.right(title.length() - (auth + 1) );
        if( int finder = author.find("[", 0, TRUE)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "of", TRUE) ) {
        int auth;
        auth = title.find("of", 0, TRUE);
        author = title.right(title.length() - (auth + 2) );
        if( int finder = author.find("[", 0, TRUE))
        {
            author = author.left( finder);
        }
    } else {
        author = "";
    }
    if ( author.contains("et. al")) {
        int auth;
        auth = author.find("et. al", 0, TRUE);
        author = author.left( auth );
    }
    if ( author.contains("#")) {
        int auth;
        auth = author.find("#", 0, TRUE);
        author = author.left( auth);
    }
    if ( author.contains("(")) {
        int auth;
        auth = author.find("(", 0, TRUE);
        author = author.left( auth);
    }
    if ( author.contains("et al")) {
        int auth;
        auth = author.find("et al", 0, TRUE);
        author = author.left( auth );
    }
    QRegExp r = QRegExp("[0-9]", TRUE, FALSE);
    if ( author.left(2).find( r) != -1 ) {
        author = "";
    }
// if( author.contains(" ", TRUE)) {
// int suth = author.findRev(" ", -1, TRUE);
// author = author.right( author.length() - suth);
// }

// title
// author
    return true;
}////// end getAuthor()

/*
 selected one etext*/
void LibraryDialog::select_title( QListViewItem* )
{
    i++;
    QListViewItem* item;
    item = ListView1->currentItem();
    if( item == 0)
        item = ListView2->currentItem();
    if( item == 0)
        item = ListView3->currentItem();
    if( item == 0)
        item = ListView4->currentItem();
    if( item == 0)
        item = ListView5->currentItem();

    DlglistItemNumber = item->text(0);
    DlglistItemTitle = item->text(1);
    DlglistItemYear = item->text(3);
    DlglistItemFile = item->text(4);
    item = 0;
    qDebug( "string from librarydialog is:%s %s %s", DlglistItemYear.latin1(),DlglistItemFile.latin1(),DlglistItemNumber.latin1());

// check for connection here
//    if( get_extext())

    if(download_Etext())  {
        if(i_binary == 1)  {
        }
        if(checkBox->isChecked () ) {
        accept();
        }
    }
}

bool  LibraryDialog::download_Etext() { // ftp method
// geezz think I got enough strings going on here... kkkkrriiiiimmmmminnnnnyyyyyyy!!!!

    QString NewlistItemNumber, NewlistItemYear, ls_result, result_line, s, dir, networkUrl, outputFile;
    NewlistItemFile = DlglistItemFile.left(DlglistItemFile.find(".xxx", 1, FALSE)).left(DlglistItemFile.left(DlglistItemFile.find(".xxx", 1, FALSE)).find("x", 1, FALSE));
    NewlistItemYear = DlglistItemYear.right(2);
    int NewlistItemYear_Int = NewlistItemYear.toInt(0, 10);

    if (NewlistItemYear_Int < 91 && NewlistItemYear_Int > 70) {
        NewlistItemYear = "90";
    }
    Edir ="etext" +NewlistItemYear;
    dir= ftp_base_dir + "/etext" +NewlistItemYear+"/";
    if( ftp_base_dir.find("=",0,true) )
        ftp_base_dir.remove(  ftp_base_dir.find("=",0,true),1);
    NetworkDialog *NetworkDlg;
    networkUrl= "ftp://"+ftp_host+dir;
//  QString networkUrl= "http://www.gutenberg.net/pgwhole.zip";
    outputFile=local_library+".guten_temp";
    qDebug("PLease find a file:%s",NewlistItemFile.latin1() );
    NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", TRUE, 0, networkUrl, outputFile, NewlistItemFile );
    if( NetworkDlg->exec() != 0 )  { // use new, improved, *INSTANT* network-dialog-file-getterer
    }

    File_Name= NetworkDlg->localFileName;
    if (File_Name.find( local_library, 0, TRUE) == -1 )
        File_Name=local_library+File_Name;
    setCursor(  arrowCursor);
    cursor();
    if(NetworkDlg)
        delete NetworkDlg;
    setCursor( arrowCursor);
    if( File_Name.find( ".guten_temp", 0, TRUE) == -1 )
        setTitle();

    return true;
}

bool LibraryDialog::httpDownload() {//  httpDownload
    config->setGroup( "Browser" );
    QString brow = config->readEntry("Preferred", "");
    QString file_name = "./.guten_temp";
//    config->setGroup( "HttpServer" );
//    QString s_http = config->readEntry("Preferred", "http://sailor.gutenbook.org");
    QString httpName = proxy_http + "/"+Edir;
//    progressBar->setProgress( i);
    i++;
    if ( brow != "Konq")    { /////////// use lynx
//        QString cmd = "lynx -source " + httpName +" | cat >> " + file_name;
//        system(cmd);
    }    else    { //////////// use KFM
//        KFM::download( httpName, file_name);
    }
    i++;
    QFile tmp( file_name);
    QString str;
    if (tmp.open(IO_ReadOnly))    {
        QTextStream t( &tmp );   // use a text stream
        while ( !t.eof())  {
            QString s = t.readLine();
            if (s.contains( NewlistItemFile, FALSE) && (s.contains(".txt")) ) {
                str = s.mid( s.find( ".txt\">"+NewlistItemFile, 0, TRUE)+6, (s.find( ".txt</A>", 0, TRUE) + 4) - ( s.find( ".txt\">"+NewlistItemFile, 0, TRUE)+6 ) );
                httpName += "/" + str;
            }
        }  //end of while loop
    }
    tmp.close();
    m_getFilePath = local_library + str;
    i++;
    if ( brow != "KFM"){ ///////// use lynx
        QString cmd = "lynx -source " + httpName +" | cat >> " + m_getFilePath;
//        QMessageBox::message("Error", cmd);
        system(cmd);
    } else { ////////// use KFM
//        KFM::download( httpName, m_getFilePath);
    }
    i++;
    return false;
}

void LibraryDialog::cancelIt() {
    saveConfig();

    DlglistItemNumber = "";
    this->reject();
}

bool LibraryDialog::setTitle() {
//    if( File_Name.contains( local_library)) {
//        QFileInfo f( File_Name);
//        QString s_file =  f.fileName();
//        File_Name = s_file;
//    }

    int test = 0;
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();
    for ( int i = 1; i <= i_numofFiles; i++){
        QString temp;
        temp.setNum( i);
        QString ramble = config->readEntry( temp, "" );
        if( strcmp( ramble, File_Name) == 0){
            test = 1;
        }
    }
    if (test == 0) {
        config->writeEntry( "NumberOfFiles", i_numofFiles +1 );
        QString interger;
        interger.setNum( i_numofFiles +1);
        config->writeEntry( interger, File_Name);
        config->setGroup( "Titles" );
        config->writeEntry( File_Name, DlglistItemTitle);
    }
    test = 0;
    config->write();
    return true;
}


void LibraryDialog::saveConfig()
{
    if( httpBox->isChecked() == TRUE) {
        checked = 1;
        config->setGroup( "Proxy" );
        config->writeEntry("IsChecked", "TRUE");
    } else {
        checked = 0;
        config->setGroup( "Proxy" );
        config->writeEntry("IsChecked", "FALSE");
    }
    if (authBox->isChecked() == TRUE) {
        config->setGroup("SortAuth");
        config->writeEntry("authSort", "TRUE");
    } else {
        config->setGroup("SortAuth");
        config->writeEntry("authSort", "FALSE");
    }

    config->write();
}

/*
searches library index for user word*/
void LibraryDialog::onButtonSearch() {

    int curTab=tabWidget->currentPageIndex();
    SearchDialog* searchDlg;

//  if( resultsList)
    searchDlg = new SearchDialog( this, "Library Search", TRUE);
    searchDlg->setCaption( tr( "Library Search"  ) );
    searchDlg->setLabel( "Could be author or Title.");
    QString resultString;
    int i_berger = 0;
    if( searchDlg->exec() != 0 )  {
        QString searcherStr = searchDlg->get_text();
        int fluff=0;

//        int tabPage = tabWidget->currentPageIndex();
// TODO ititerate here... struct<listViews>??

        QListViewItemIterator it1( ListView1 );
        QListViewItemIterator it2( ListView2 );
        QListViewItemIterator it3( ListView3 );
        QListViewItemIterator it4( ListView4 );
        QListViewItemIterator it5( ListView5 );

        //// this is really pitiful work,
        ///////
        if(fluff==0) {
            for ( ; it1.current(); ++it1 ) {
                resultString = ( it1.current() )->text(1);
                resultString += (" : ");
                resultString += ( it1.current() )->text(3);
                resultString += (" : ");
                resultString += ( it1.current() )->text(4);
                if( resultString.find( searcherStr, 0, false) != -1)
                {
                    Searchlist.append( resultString);
                }
            }
        }
        if(fluff==0) {// search routine here
            for ( ; it2.current(); ++it2 ) {
                resultString = ( it2.current() )->text(1);
                resultString += (" : ");
                resultString += ( it2.current() )->text(3);
                resultString += (" : ");
                resultString += ( it2.current() )->text(4);
                if( resultString.find( searcherStr, 0, false) != -1) {
                    Searchlist.append( resultString);
                }
            }
        }
        if(fluff==0) {// search routine here
            for ( ; it3.current(); ++it3 ) {
                resultString = ( it3.current() )->text(1);
                resultString += (" : ");
                resultString += ( it3.current() )->text(3);
                resultString += (" : ");
                resultString += ( it3.current() )->text(4);

                if( resultString.find( searcherStr, 0, false) != -1) {
                    Searchlist.append( resultString);
                }
            }
        }
        if(fluff==0) {
              // search routine here
            for ( ; it4.current(); ++it4 )  {
                resultString = ( it4.current() )->text(1);
                resultString += (" : ");
                resultString += ( it4.current() )->text(3);
                resultString += (" : ");
                resultString += ( it4.current() )->text(4);
                if( resultString.find( searcherStr, 0, false) != -1) {
                    Searchlist.append( resultString);
                }
            }
        }
        if(fluff==0) {              // search routine here
            for ( ; it5.current(); ++it5 )  {
                resultString = ( it5.current() )->text(1);
                resultString += (" : ");
                resultString += ( it5.current() )->text(3);
                resultString += (" : ");
                resultString += ( it5.current() )->text(4);
                if( resultString.find( searcherStr, 0, false) != -1) {
                    Searchlist.append( resultString);
                }
            }
        }

        tabWidget->setCurrentPage( curTab);

        Searchlist.sort();
        SearchResultsDlg* SearchResultsDialog;
        SearchResultsDialog = new SearchResultsDlg( searchDlg, "Results Dialog", true, 0 , Searchlist);

        if( SearchResultsDialog->exec() != 0) {
            texter = SearchResultsDialog->selText;
            resultLs= SearchResultsDialog->resultsList;
            i_berger = 1;
        }
    Searchlist.clear();
    if(SearchResultsDialog)
    delete SearchResultsDialog;

    QString tester;
    for ( QStringList::Iterator it = resultLs.begin(); it != resultLs.end(); ++it ) {
           texter.sprintf("%s \n",(*it).latin1());
           if( tester!=texter)
           parseSearchResults( texter);
           tester = texter;
        }
    }
    if(checkBox->isChecked() ) {
        accept();
    } else
        setActiveWindow();
}

/*
splits the result string and calls download for the current search result*/
void  LibraryDialog::parseSearchResults( QString resultStr) {

    int stringLeng=resultStr.length();
    QString my;
    my.setNum( stringLeng, 10);

    if( resultStr.length() > 2 && resultStr.length() < 130) {
        int titleInt = resultStr.find( " : ", 0, TRUE);
        DlglistItemTitle  =   resultStr.left( titleInt);
        int yearInt = resultStr.find( " : ", titleInt+3, TRUE);
        DlglistItemYear  = resultStr.mid( titleInt+3, (yearInt - titleInt)-3);
        DlglistItemFile = resultStr.right( resultStr.length() - (yearInt + 3));
        download_Etext();
    }
/*
  printf( DlglistItemTitle+"\n");  printf( DlglistItemYear+"\n");  printf( DlglistItemFile+"\n");*/
}

bool LibraryDialog::UnzipIt( QString zipFile) {
//////////TODO findsome other way of dealingwithzip files.
      ///usr/bin/unzip";
    if( QFile::exists( zipFile))        {
//            QString thatFile = local_library +"PGWHOLE.TXT";
#if defined(_WS_X11_)
      QString cmd = "unzip -o " + zipFile /*newestLibraryFile  */+" -d " + local_library;
#endif
#if defined(_WS_WIN_)
      QString temp= QDir::convertSeparators(local_library);
      zipFile=QDir::convertSeparators( zipFile);
      QString cmd = temp+"unzip.exe -o " +zipFile/*newestLibraryFile  */+" -d " + temp;
#endif

        int exit=QMessageBox::information(this, "Unzip?", "Ok to unzip "+ zipFile+" ?", QMessageBox::Yes, QMessageBox::No);
        if (exit==QMessageBox::Yes) {
#if defined(_WS_WIN_)
    WinExec( cmd, SW_HIDE );
#endif
#if defined(_WS_X11_)
    system( cmd);
#endif
// printf("unzip\n");
//      remove( zipFile /*newestLibraryFile*/);
            return true;
        }
        else if(exit==QMessageBox::No)  {
        //    printf("unzip\n");
            return false;
        }
    } else  {
//          QMessageBox::message( "Note",( tr("Please install unzip in your PATH")) );
        return false;
    }
    return true;
}

void LibraryDialog::sort()  {

}

/*
 Downloads the current selected listitem*/
bool LibraryDialog::getItem(QListViewItem *it) {

    DlglistItemNumber = it->text(0);
    DlglistItemTitle = it->text(1);
    DlglistItemYear = it->text(3);
    DlglistItemFile = it->text(4);

    if(download_Etext())  {
        if(i_binary == 1)  {
        }
    }
    return true;
}

/*
download button is pushed so we get the current item to download*/
bool LibraryDialog::onButtonDownload() {

    QListViewItemIterator it1( ListView1 );
    QListViewItemIterator it2( ListView2 );
    QListViewItemIterator it3( ListView3 );
    QListViewItemIterator it4( ListView4 );
    QListViewItemIterator it5( ListView5 );

      // iterate through all items of the listview
    for ( ; it1.current(); ++it1 ) {
        if ( it1.current()->isSelected() )
            getItem(it1.current());
        it1.current()->setSelected(FALSE);
    }
    for ( ; it2.current(); ++it2 ) {
        if ( it2.current()->isSelected() )
            getItem(it2.current());
        it2.current()->setSelected(FALSE);
    }
    for ( ; it3.current(); ++it3 ) {
        if ( it3.current()->isSelected() )
            getItem(it3.current());
        it3.current()->setSelected(FALSE);
    }
    for ( ; it4.current(); ++it4 ) {
        if ( it4.current()->isSelected() )
            getItem(it4.current());
        it4.current()->setSelected(FALSE);
    }
    for ( ; it5.current(); ++it5 ) {
        if ( it5.current()->isSelected() )
            getItem(it5.current());
        it5.current()->setSelected(FALSE);
    }
    return true;
}


/*
handles the sorting combo box */
void LibraryDialog::comboSelect(int index) {

    ListView1->setSorting( index, TRUE);
    ListView2->setSorting( index, TRUE);
    ListView3->setSorting( index, TRUE);
    ListView4->setSorting( index, TRUE);
    ListView5->setSorting( index, TRUE);

    ListView1->sort();
    ListView2->sort();
    ListView3->sort();
    ListView4->sort();
    ListView5->sort();

//      ListView1->triggerUpdate();
//      ListView2->triggerUpdate();
//      ListView3->triggerUpdate();
//      ListView4->triggerUpdate();
//      ListView5->triggerUpdate();
}

