/***************************************************************************
                          optionsDialog.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "optionsDialog.h"
//#include "ftpsitedlg.h"
//#include "browserDialog.h"
//#define Inherited  QDialog

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>


optionsDialog::optionsDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
        : QDialog( parent, name, modal, fl ) {
    if ( !name )
        setName( "optionsDialog" );
#if defined(Q_WS_WIN)
    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#endif
#if defined(Q_WS_X11_)
    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif

    resize(600,400);
    b_qExit=true;
    setProperty( "caption", tr( "Gutenbrowser Options" ) );
    setProperty( "sizeGripEnabled", QVariant( true, 0 ) );
    initDialog();

    ftpSiteDlg();
    BrowserDlg();
}

optionsDialog::~optionsDialog() {
}


void optionsDialog::OnExit() {
    writeConfig();
    exit(0);
}


/// optionsDialog
void optionsDialog::doOptions() {

    config->read();
    getConfig();
}

void optionsDialog::getConfig() {
    config->setGroup( "FTPsite" );  // ftp server config
    ftp_host = config->readEntry("SiteName", "sailor.gutenberg.org");
    ftp_base_dir = config->readEntry("base",  "/pub/gutenberg");

    TextLabel3->setText( "Current ftp server:\n"+ftp_host + ftp_base_dir );

    config->setGroup( "Proxy" ); // use ftp/http config
    if( config->readEntry("IsChecked", "false") == "true") {
        Ftp_CheckBox->setChecked( false);
    } else {
        Ftp_CheckBox->setChecked( true);
    }

    config->setGroup( "HttpServer" );
    QString s_http = config->readEntry("Preferred", "http://sailor.gutenbook.org");
    if( s_http == "http://sailor.gutenbook.org")
        ComboBox1->setCurrentItem(0);
    else
        ComboBox1->setCurrentItem(1);

    config->setGroup( "Browser" );
    brow = config->readEntry("Preferred", "Opera");
    browserName=brow;

    TextLabel3_3->setText( "Current http browser: "+brow );

    config->setGroup( "Geometry" );

    QString str;
    str = config->readEntry("Icons", "true");
    if(str == "true") {
        IconsCheckBox->setChecked(true);
        useIcon=true;
    } else {
        IconsCheckBox->setChecked(false);
        useIcon=false;
    }
    config->setGroup("General");
    QString qExit=config->readEntry("queryExit","true");
    if(qExit=="true") {
        cb_queryExit->setChecked(true);
        qDebug("Config Setting    b_qExit=true;");
        b_qExit=true;
    } else {
        cb_queryExit->setChecked(false);
        qDebug("ConfigSetting    b_qExit=false;");
        b_qExit=false;
    }

#ifndef Q_WS_QWS
    config->setGroup( "General" );
    QString s_Split=config->readEntry("Splitter", "true" );
    if(s_Split=="true")
        useSplit_CheckBox->setChecked(true);
    else
        useSplit_CheckBox->setChecked(false);
#else

    s_Wrap=config->readEntry("WordWrap", "true" );
    if(s_Wrap=="true")
        useWordWrap_CheckBox->setChecked(true);
    else
        useWordWrap_CheckBox->setChecked(false);
#endif
} // end getConfig

/*
writes to config*/
void optionsDialog::writeConfig() {
    config->read();
    config->setGroup( "Geometry" );
    if( IconsCheckBox->isChecked() ) {
        config->writeEntry("Icons", "true");
    } else {
        config->writeEntry("Icons", "false");
    }
    config->setGroup( "Proxy" );
    if( Http_CheckBox->isChecked()) {
        config->writeEntry("IsChecked", "true");
    } else {
        config->writeEntry("IsChecked", "false");
    }

    config->setGroup( "HttpServer" );
    if( ComboBox1->currentItem()== 0) {
        config->writeEntry("Preferred", "http://sailor.gutenberg.org");
    } else {
        config->writeEntry("Preferred", "http://www.prairienet.org/pg");
    }

    config->setGroup( "FTPsite" );  // ftp server config
    config->writeEntry("SiteName", ftp_host);
    config->writeEntry("base", ftp_base_dir);

    config->setGroup( "Browser" );
    qDebug("Brow is: %s",browserName.latin1());
    if(browserName.find("Preferred",0,false) != -1)
        browserName="Opera";
    config->writeEntry("Preferred", browserName);

    config->setGroup("General");
    if(cb_queryExit->isChecked()) {
        b_qExit=true;
        config->writeEntry("queryExit","true");
        qDebug("WritingConfig queryExit=true");
    } else {
        b_qExit=false;
        config->writeEntry("queryExit","false");
        qDebug("WritingConfig queryExit=false");
    }

#ifndef Q_WS_QWS
    config->setGroup( "General" );
    if(useSplit_CheckBox->isChecked()) {
        config->writeEntry("Splitter", "true" );
    } else
        config->writeEntry("Splitter", "false" );
#else

    config->setGroup( "General" );
    if(useWordWrap_CheckBox->isChecked()) {
        config->writeEntry("WordWrap", "true" );
        s_Wrap="true";
    } else
        config->writeEntry("WordWrap", "false" );
    s_Wrap="false";
#endif

    config->write();
}

void optionsDialog::OptionsFtpClicked() {}

/*
Use icons on buttons */
void optionsDialog:: iconCheckB() {

    config->setGroup( "Geometry" );
    if( IconsCheckBox->isChecked() ) {
        useIcon = true;
        config->writeEntry("Icons", "true");
    } else {
        useIcon=false;
        config->writeEntry("Icons", "false");
    }
    //    writeConfig();
    config->write();
}


void optionsDialog::onTab( int index) {
    qDebug("%d",index);
    //QMessageBox::message("Note","");
    int curPage=tabWidget->currentPageIndex();
    if(curPage==0 ) {
        // main page
        //        listBox ->setSelected(0,true);
        // doOptions();
    } else if (curPage==1) {
        // ftpsite
        //      listBox ->setSelected(1,true);
        ftpSiteDlg();
    } else if(curPage==2) {
        // http server
        //        listBox ->setSelected(2,true);
        BrowserDlg( );
    }
}


void optionsDialog::slotQueryExit() {
    config->setGroup("General");
    if(cb_queryExit->isChecked()) {
        b_qExit=true;
        config->writeEntry("queryExit","true");
        qDebug("WritingConfig queryExit=true");
    } else {
        b_qExit=false;
        config->writeEntry("queryExit","false");
        qDebug("WritingConfig queryExit=false");
    }
    config->write();
}

void optionsDialog::slotUseSplit() {
#ifndef Q_WS_QWS
    QMessageBox::message("Note","Restarting gutenbrowser is required to see these changes.");
    config->setGroup("General");
    if(useSplit_CheckBox->isChecked()) {
        config->writeEntry("Splitter", "true" );
    } else
        config->writeEntry("Splitter", "false" );
#else

    config->setGroup("General");
    if(useWordWrap_CheckBox->isChecked()) {
        config->writeEntry("WordWrap", "true" );
        s_Wrap="true";
    } else
        config->writeEntry("WordWrap", "false" );
    s_Wrap="false";

#endif

    config->write();
}
