#!/usr/bin/env python
# -*- coding: latin-1 -*-

# Copyright (c) 2006 Stas Zykiewicz <stas.zytkiewicz@gmail.com>
#
#           gvrng.py
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import sys,os,__builtin__,ConfigParser
import utils

utils.setUpUnixRC()

# This stuff must be called before importing worldMap,world and guiWorld
def SetLocale(lang=None):
    global LocaleLang,LocaleMesg
    # This also sets up the global rc dict in utils.py
    rc_d = utils.parseRcFile()
    try:
        LocaleLang = rc_d['lang']
    except:
        LocaleLang = 'system'
    #This will set the locale used by gvr and returns the tuple (txt,loc)
    # txt is a error message, if any else it will be an empty string.
    # loc is a string with the locale country code set for gvr, this can be
    # different from the systems locale.
    LocaleMesg = utils.set_locale(LocaleLang)

try:
    SetLocale()
except Exception,info:
    txt = "Problems setting the locale.\n switching to English\nPlease inform the GvR developers about this."
    print >> sys.stderr,info,txt
    __builtin__.__dict__['_'] = lambda x:x

import Text
Text.set_summary(LocaleMesg[1])# needed to set summary file used to the current locale
Text.set_WBsummary(LocaleMesg[1])# idem for the worldbuilder

# when the frontend is not in sitepackages, as is the case for the org install
sys.path.append(utils.FRONTENDDIR)

import gvr_gtk # the frontend to use

import GvrModel
import GvrController

# Assuming, gvrng.py worldfile progfile
if len(sys.argv) == 3 and os.path.exists(sys.argv[1]) and os.path.exists(sys.argv[2]):
    wfile = sys.argv[1]
    pfile = sys.argv[2]
else:
    wfile = ''
    pfile = ''

if __name__ == "__main__":
    try:
        # The abstraction layer on top of the gvr stuff
        model = GvrModel.GvrModel()
        # view must be the main GUI window
        view = gvr_gtk.MainWin()
        # the controller must have access to the model and view
        contr = GvrController.Controller(model,view)
        # we also must give the model access to the controller
        model.set_controller(contr)
        view.set_controller(contr)
        # Now start the GUI
        contr.start_view(wfile,pfile)# args are optional
    except Exception:
        utils.trace_error()
