#!/bin/sh
### BEGIN INIT INFO
# Provides:          gw6c
# Required-Start:    $network $local_fs
# Required-Stop:
# Should-Start:      $named
# Should-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Gateway6 client
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin

DAEMON=/usr/sbin/gw6c 
GW6C_CONFIG=/etc/gw6c/gw6c.conf
GW6C_KEYS=/var/lib/gw6c/gw6ckeys.pub
PIDDIR=/var/run/gw6c
RADVDDIR=/var/run/radvd

NAME=gw6c              
DESC="Gateway6 Client" 

test -x $DAEMON || exit 0

. /lib/lsb/init-functions

# Default options, these can be overriden by the information
# at /etc/default/$NAME
DAEMON_OPTS=""          # Additional options given to the server

DIETIME=5   
CHECK_KEYFILE="yes"	

# Include defaults if available
if [ -f /etc/default/$NAME ] ; then
    . /etc/default/$NAME
fi


set -e

check_server_key() {
		# Check for config file, if there isn't one then exit
		test -f $GW6C_CONFIG || return 1

		# Extract the server from config file, mandatory config line
		GW6C_SERVER=$(sed '/^server/!d; s/.*[=#]\(.*\)/\1/; q' $GW6C_CONFIG)
		if [ -z $GW6C_SERVER ]; then
			log_warning_msg "Not starting gw6c - no server line in $GW6C_CONFIG"
			return 1
		fi
		# Extract authentication type from config file
		GW6C_AUTHTYPE=$(sed '/^auth_method/!d; s/.*[=#]\(.*\)/\1/; q' $GW6C_CONFIG)
		# We only care if the method is any or passdss-3des-1
		if [ -z $GW6C_AUTHTYPE ]; then
		  return 0
		fi
		if [ "$GW6C_AUTHTYPE" != "any" ] && [ "$GW6C_AUTHTYPE" != "passdss-3des-1-md5"  ]; then
		  return 0
		fi
		

		# Check for cached server key
		if [ ! -r $GW6C_KEYS ] || ! grep -q "^$GW6C_SERVER[[:space:]]" $GW6C_KEYS ; then
			log_warning_msg "Not starting gw6c - no server key"
			return 1
		fi
		return 0
}

start_server() {
  		if [ "$CHECK_KEYFILE" = "yes" ] ; then
  		  check_server_key || return $?
		fi
        [ -d $PIDDIR ] || mkdir -p $PIDDIR
		# RADVD if installed may not have its rundir
		if [ ! -e $RADVDDIR ] && [ -e /usr/sbin/radvd ] ; then
		  install -d -o radvd -g root -m 4755 $RADVDDIR
		fi
        start-stop-daemon --start --exec $DAEMON -- $DAEMON_OPTS || true
        errcode=$?
        return $errcode
}

stop_server() {
        start-stop-daemon --stop --signal HUP --exec $DAEMON || true
        errcode=$?
        return $errcode
}

case "$1" in
  start)
        log_daemon_msg "Starting $DESC " "$NAME"
		errcode=0
        start_server || errcode=$?
		log_end_msg $errcode
        ;;
  stop|force-stop)
      log_daemon_msg "Stopping $DESC" "$NAME"
	  errcode=0
      stop_server || errcode=$?
      log_end_msg $errcode
	  ;;
  restart|force-reload)
        log_daemon_msg "Restarting $DESC" "$NAME"
        errcode=0
        stop_server || errcode=$?
		sleep $DIETIME
        start_server || errcode=$?
        log_end_msg $errcode
        ;;
  reload)
        log_warning_msg "Reloading $NAME daemon: not implemented, as the daemon"
        log_warning_msg "cannot re-read the config file (use restart)."
        ;;
  *)
        N=/etc/init.d/$NAME
        echo "Usage: $N {start|stop|force-stop|restart|force-reload|status}" >&2
        exit 1
        ;;
esac

exit 0
