/*****************************************************************************
*   Gnome Wave Cleaner Version 0.19
*   Copyright (C) 2001 Jeffrey J. Welty
*   
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either version 2
*   of the License, or (at your option) any later version.
*   
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*******************************************************************************/

/* amplify.c */
#include <stdlib.h>
#include <gnome.h>
#include "gtkledbar.h"
#include "gwc.h"

#define BUFSIZE 10000

static gfloat amount_first[2] ;
static gfloat amount_last[2] ;
static int feather_width ;

void amplify_audio(struct sound_prefs *p, long first, long last, int channel_mask)
{
    long left[BUFSIZE], right[BUFSIZE] ;
    long current, i ;
    int loops = 0 ;

    current = first ;

    push_status_text("Amplifying audio") ;
    update_status_bar(0.0,STATUS_UPDATE_INTERVAL,TRUE) ;

    {

	while(current <= last) {
	    long n = MIN(last - current + 1, BUFSIZE) ;
	    long tmplast = current + n - 1 ;
	    gfloat p = (gfloat)(current-first)/(last-first+1) ;

	    n = read_wavefile_data(left, right, current, tmplast) ;

	    update_status_bar(p,STATUS_UPDATE_INTERVAL,FALSE) ;

	    for(i = 0 ; i < n ; i++) {
		long icurrent = current + i ;
		double p_last = (gfloat)(icurrent-first)/(last-first+1) ;
		double p_first = 1.0 - p_last ;
		double feather_p = 1.0 ;
		double wet_left, wet_right ;

		if(icurrent - first < feather_width)
			feather_p = (double)(icurrent-first)/(feather_width) ;

		if(last - icurrent < feather_width)
			feather_p = (double)(last - icurrent)/(feather_width) ;

		if(channel_mask & 0x01) {
		    wet_left = (left[i]*(amount_first[0]*p_first+amount_last[0]*p_last)) ;
		    left[i] = lrint(left[i]*(1.0-feather_p) + wet_left*feather_p) ;
		}

		if(channel_mask & 0x02) {
		    wet_right = (right[i]*(amount_first[1]*p_first+amount_last[1]*p_last)) ;
		    right[i] = lrint(right[i]*(1.0-feather_p) + wet_right*feather_p) ;
		}
	    }

	    write_wavefile_data(left, right, current, tmplast) ;

	    current += n ;

	    if(last - current < 10) loops++ ;

	    if(loops > 5) {
		warning("inifinite loop in amplify_audio, programming error\n") ;
	    }
	}

	resample_audio_data(p, first, last) ;
	save_sample_block_data(p) ;
    }
    update_status_bar(0.0,STATUS_UPDATE_INTERVAL,TRUE) ;
    pop_status_text() ;

    main_redraw(FALSE, TRUE) ;
}

int amplify_dialog(struct sound_prefs current, struct view *v)
{
    GtkWidget *dlg, *maxtext, *dialog_table  ;
    GtkWidget *amount_first_entry[2] ;
    GtkWidget *amount_last_entry[2] ;
    GtkWidget *feather_width_entry ;
    int dclose = 0 ;
    int dres ;
    char buf[200] ;

    dialog_table = gtk_table_new(5,2,0) ;

    gtk_table_set_row_spacings(GTK_TABLE(dialog_table), 4) ;
    gtk_table_set_col_spacings(GTK_TABLE(dialog_table), 6) ;

    gtk_widget_show (dialog_table);

    dlg =
	gtk_dialog_new_with_buttons("Amplify",
			NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_STOCK_OK, GTK_RESPONSE_OK,
			 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL, NULL);

    sprintf(buf, "Maximum amplification without clipping is %6.2f.\n", (double)1.0/(double)current.max_value) ;

    maxtext = gtk_label_new (buf);
    gtk_widget_show (maxtext);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dlg)->vbox), maxtext, TRUE, TRUE, 0);

    amount_first_entry[0] = add_number_entry_with_label("1.0", "Left Channel beginning:", dialog_table, 0) ;
    amount_last_entry[0] = add_number_entry_with_label("1.0", "Left Channel end:", dialog_table, 1) ;

    amount_first_entry[1] = add_number_entry_with_label("1.0", "Right Channel beginning:", dialog_table, 2) ;
    amount_last_entry[1] = add_number_entry_with_label("1.0", "Right Channel end:", dialog_table, 3) ;
    feather_width_entry = add_number_entry_with_label("2000", "Feather width", dialog_table, 4) ;

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dlg)->vbox), dialog_table, TRUE, TRUE, 0);

    dres = gwc_dialog_run(GTK_DIALOG(dlg)) ;

    if(dres == 0) {
	int i ;
	for(i = 0 ; i < 2 ; i++) {
	    amount_first[i] = atof(gtk_entry_get_text((GtkEntry *)amount_first_entry[i])) ;
	    amount_last[i] = atof(gtk_entry_get_text((GtkEntry *)amount_last_entry[i])) ;
	}
	feather_width = atoi(gtk_entry_get_text((GtkEntry *)feather_width_entry)) ;
	dclose = 1 ;
    }

    gtk_widget_destroy(dlg) ;

    if(dres == 0)
	return 1 ;

    return 0 ;
}

/* bj 9/6/03 stub for batch processing; must put amplification amounts into static vars */
void batch_normalize(struct sound_prefs *p, long first, long last, int channel_mask)
{
    amount_first[0] = (double)1.0/(double)p->max_value;
    amount_first[1] = amount_first[0];
    amount_last[0] = amount_first[0];
    amount_last[1] = amount_first[0];
    feather_width = 2000;
    amplify_audio(p,first,last,channel_mask);
}
