/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include "iconload.h"
#include <kurllabel.h>
#include <krun.h>
#include <qsize.h>
#include <kaboutdata.h>
#include <kdeversion.h>
#include <klocale.h>
#include <ktextbrowser.h> 
#include <fabout.h>
//#define DO_NOT_TRANSLATE
extern KAboutData * ab;
extern iconload ic;
void fAbout::init(){
    setIcon(ic.Icon(0));
    pixmapLabel1->setPixmap(ic.Icon(9));
    setCaption(QString(i18n("About %1")).arg("GwenRename"));
    shortDescription->setText(ab->shortDescription());
    QString cop="\n"+ab->copyrightStatement();
    lblC->setText(cop);
    QString t=QString(i18n("%1 %2 (Using KDE %3)")).arg("GwenRename").arg(ab->version()).arg(KDE_VERSION_STRING);
    t.prepend("<b><nobr>");t+="</nobr></b>";
    lblVersion->setText(t);
    lblVersion->setScaledContents(TRUE);
    urlGwenview->setText("Gwenview");
    urlGwenview->setURL("http://gwenview.sf.net");
    t="<p><b>Aurelien Gateau</b><br>";
    t+=i18n("For all the help he's offered");
    t+="</p><p><b>Jan Schubert</b><br>";
    t+=i18n("For giving me the idea to use timestamping information to GwenRename, and providing Exif images for testing.");
    t+="</p><p><b>Charles Barcza</b><br>";
	  t+=i18n("For the help he offered debuging v 0.9.9.");	 
    t+="</p><p><b>Sidlovsky Yaroslav</b><br>";
    t+=i18n("For the help he offered debuging v 1.0.0 and creating the new pot file.");
    thanks->setText(t);
    gURL->setURL(ab->homepage());
    gURL->setText(ab->homepage());
    buttonClose->setText( i18n( "&Close" ) );
    buttonClose->setAccel( QKeySequence( "Alt+C"));
    license->setText(ab->license());
    license->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
    thanks->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
	KConfigBase *config = KGlobal::config();
	config->setGroup("Locale");
	QString lang=config->readEntry("Language"); 
	if(lang!=QString::null && lang.find("en",0)!=0){
	TabPage = new QWidget( tabWidget2, "TabPage" );
	TabPageLayout = new QHBoxLayout( TabPage, 5, 6, "TabPageLayout"); 
	KTextBrowser* trans;
	trans = new KTextBrowser( TabPage, "trans" );
	trans->setWordWrap( KTextBrowser::FixedColumnWidth );
	trans->setWrapColumnOrWidth( 40 );
	TabPageLayout->addWidget( trans );
	tabWidget2->insertTab( TabPage, QString(""),2 );
	QValueList< KAboutTranslator > v=ab->translators();
	if(KDE_VERSION_MINOR==1) trans->setPaletteBackgroundColor(tabWidget2->paletteBackgroundColor());
	else trans->setWordWrap(KTextBrowser::WidgetWidth);
	tabWidget2->changeTab( TabPage, i18n( "T&ranslation" ) );
	if(v.empty()){
	    if(KDE_VERSION_MINOR==1) trans->setWrapColumnOrWidth( 120 );
	    #ifdef DO_NOT_TRANSLATE
	    t="<p>There is no translation available for your language.</p><p>If you would like to translate the program please wait at least until version 1.0.0 is released</p>";
	    #else
	    t="<p>There is no translation available for your language.<p><p>If you would like to translate the program please feel free to do so.<p></p>When you are done, <a href=\"mailto:sngeorgaras@otenet.gr?subject=New translation for GwenRename\">send me</a> the resulting po file and I will add a link to it in the <a href=\"http:\/\/users.otenet.gr//~geosp//gwenrename//download.html\">download page</a> of GwenRename site. </p><p>Your translation will be included in the next GwenRename release.<p><p>For more information on traslating KDE programs, please visit the <a href=\"http:\/\/i18n.kde.org//\">KDE Internationalization</a> site.</p>";
	    #endif
	}else{
	    KAboutTranslator kAbTr;
	    t="";
	    for(uint i=0;i<v.count();i++){
		kAbTr=v[i];
		//t+=QString("<p>&nbsp;&nbsp;%1<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:%2\">%3</a></p>").arg(kAbTr.name(),kAbTr.emailAddress(),kAbTr.emailAddress());
		t+=QString("<p>&nbsp;&nbsp;%1<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:%2\">%3</a></p>").arg(kAbTr.name()).arg(kAbTr.emailAddress()).arg(kAbTr.emailAddress());
	    }
	    t+=ab->aboutTranslationTeam();
	}
	trans->setText(t);
    }
    buttonClose->setFocus();
}

void fAbout::destroy(){}


void fAbout::gURLClicked( const QString &op )
{
     KRun opBr(op);
     opBr.runURL(op,"text/html",FALSE);
}

