/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <qdatetime.h>
#include <krestrictedline.h>
#include <kconfigbase.h>
#include <kconfig.h>
#include "rename.h"
#include "iconload.h"
#include "main.h"

extern QString tFormatBefore;
extern QString tFormatDate;
extern QString tFormatAfter;
extern Rename *gwen;
extern QString history[HISTORY_ITEMS * HISTORY_CONTROLS];
extern int historyIndex;
extern iconload ic;
//================================
void tStamp::init(){
    setIcon(ic.Icon(0));
    setCaption(i18n("Timestamping")+" - GwenRename");
    QString msg="<p><font size=\"+3\"><b>";
    msg+=i18n("Time stamping format");
    msg+="</font></b></p><p>";
    msg+=i18n("The time stamping field supports a variety of expressions, both for date and time. The following section describes these expressions.");
    msg+="</p><p><font size=\"+2\"><b>";
    msg+=i18n("Date Format");
    msg+="</font></b></p><p>";
    msg+=i18n("These expressions may be used for the date:");
    msg+="</p><table width=\"100%\"><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
    msg+=i18n("Expression");
    msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
    msg+=i18n("Output");
    msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>d</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the day as number without a leading zero (1-31)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dd</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the day as number with a leading zero (01-31)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>ddd</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the abbreviated localized day name (e.g. 'Mon'..'Sun')");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dddd</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the long localized day name (e.g. 'Monday'..'Sunday')");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>M</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the month as number without a leading zero (1-12)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MM</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the month as number with a leading zero (01-12)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>MMM</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the abbreviated localized month name (e.g. 'Jan'..'Dec')");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MMMM</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the long localized month name (e.g. 'January'..'December')");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>yy</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the year as two digit number (00-99)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>yyyy</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the year as four digit number (1752-8000)");
    msg+="</td></tr></table><p><font size=\"+2\"><b>";
    msg+=i18n("Time Format");
    msg+="</font></b></p><p>";
    msg+=i18n("These expressions may be used for the time:");
    msg+="</p><table width=\"100%\"><table><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
    msg+=i18n("Expression");
    msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
    msg+=i18n("Output");
    msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>h</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the hour without a leading zero (0..23 or 1..12 if AM/PM display)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>hh</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the hour with a leading zero (00..23 or 01..12 if AM/PM display)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>m</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the minute without a leading zero (0..59)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>mm</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the minute with a leading zero (00..59)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>s</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the second whithout a leading zero (0..59)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ss</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the second whith a leading zero (00..59)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>z</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("the milliseconds without leading zeroes (0..999)");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>zzz</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("the milliseconds with leading zeroes (000..999)");
    msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>AP</b></td><td bgcolor=\"#F0F0F0\">";
    msg+=i18n("use AM/PM display. AP will be replaced by either \"AM\" or \"PM\"");
    msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ap</b></td><td bgcolor=\"#D0D0D0\">";
    msg+=i18n("use am/pm display. ap will be replaced by either \"am\" or \"pm\"");
    msg+="</td></tr></table><p>";
    msg+=i18n("Source:");
    msg+="<b> Trolltech's QT 3.1.1 Manual</b></p>";
    txt->setText(msg);
    kFormat->clear();
    kFormat->insertItem( "dd-MM-yy" );
    kFormat->insertItem( "dd-MM-yyyy" );
    kFormat->insertItem( "dd_MM_yy" );
    kFormat->insertItem( "dd_MM_yyyy" );    
    kFormat->insertItem( "MM-dd-yy" );
    kFormat->insertItem( "MM-dd-yyyy" );
    kFormat->insertItem( "MM_dd_yy" );
    kFormat->insertItem( "MM_dd_yyyy" );
    kFormat->insertItem( "yy-dd-MM" );
    kFormat->insertItem( "yy_dd_MM" );
    kFormat->insertItem( "yyyy-dd-MM" );
    kFormat->insertItem( "yyyy_dd_MM" );
    kFormat->insertItem( "yy-MM-dd" );
    kFormat->insertItem( "yy_MM_dd" );
    kFormat->insertItem( "yyyy-MM-dd" );
    kFormat->insertItem( "yyyy_MM_dd" );
    kFormat->insertItem( i18n("Other...") );
    kFormat->setSizeLimit(kFormat->count());
    if(!checkFormat(tFormatDate)) GFormat->setEnabled(FALSE);
    else getExampleDate();
    readConfig( historyIndex );
    QRect rect=geometry(); rect.setRight(10); rect.setHeight(10); setGeometry(rect);
}
//================================
void tStamp::destroy(){
}
//================================
bool tStamp::checkFormat( QString t )
{
    QString tmp=t;
    if(tmp.isEmpty()) return FALSE;
    else{
	int i,ii;
	if((i=tmp.find(":",0))!=-1){
	    if(i==0) tFormatBefore="";
	    else tFormatBefore=tmp.mid(0,i);
	    if((ii=tmp.find(":",i+1))!=-1){
		tFormatAfter=tmp.mid(ii+1,tFormatDate.length());
		tFormatDate=tmp.mid(i+1,ii-i-1);
	    }else return FALSE;
	}else return FALSE;
    }
    tmp=tFormatDate;
    if(!tmp.isEmpty()){
	if(tmp.left(1)=="C"){
	    rCreation->setChecked(TRUE);
	    rCreation->setFocus();
	}else if(tmp.left(1)=="E"){
	    rCreation->setChecked(TRUE);
	    rCreation->setFocus();
	    chkExif->setChecked(TRUE);
	}else if(tmp.left(1)=="M"){
	    rModified->setChecked(TRUE);
	    rModified->setFocus();
	}else if(tmp.left(1)=="L"){
	    rModified->setChecked(TRUE);
	    rModified->setFocus();
	    chkExif->setChecked(TRUE);
	}else if(tmp.left(1)=="R"){
	    rRead->setChecked(TRUE);
	    rRead->setFocus();
	}else{
	    return FALSE;
	}
	int i;
	tmp=tmp.right(tmp.length()-1);
	if((i=isFormat(tmp))==-1){
	    GFormat->setEnabled(TRUE);
	    lblPredefined->setEnabled(TRUE);
	    kFormat->setEnabled(TRUE);
	    kFormat->setCurrentItem(kFormat->count()-1);
	    txtFormat->setEnabled(TRUE);
	    lblUser->setEnabled(TRUE);
	    txtFormat->setCurrentText(tmp);
	    txtFormat->setFocus();
	    getExampleDate();
	}else kFormat->setCurrentItem(i);
    }else return FALSE;
    return TRUE;
}
//================================
void tStamp::OkClicked()
{
    if(chkExif->isChecked()){
	if(rCreation->isChecked()) tFormatDate="E";
	else if(rModified->isChecked()) tFormatDate="L";
	else if(rRead->isChecked()) tFormatDate="R";
	else tFormatDate="";
    }else{
	if(rCreation->isChecked()) tFormatDate="C";
	else if(rModified->isChecked()) tFormatDate="M";
	else if(rRead->isChecked()) tFormatDate="R";
	else tFormatDate="";
    }
    if(!tFormatDate.isEmpty()){
    	writeConfig(historyIndex);
	if(kFormat->currentItem()<kFormat->count()-1) tFormatDate+=kFormat->currentText();
	else tFormatDate+=txtFormat->currentText();
	tFormatDate=":"+tFormatDate+":";
    }
    QDialog::accept();
}
//================================
void tStamp::CancelClicked()
{
    if(!rCreation->isChecked() && !rModified->isChecked() && !rRead->isChecked()) tFormatDate="";
    QDialog::reject();
}
//================================
int tStamp::isFormat( QString s )
{
    for(int i=0;i<kFormat->count();i++){
	if(s==kFormat->text(i)) return i;
    }
    return -1;
}
//================================
void tStamp::kFormatActivated( int item )
{
    if(item==kFormat->count()-1){
    	lblUser->setEnabled(TRUE);
	txtFormat->setEnabled(TRUE);
	txtFormat->setFocus();
    }else{
    	txtFormat->setEnabled(FALSE);
	lblUser->setEnabled(FALSE);
	}
	getExampleDate();
}
//================================
void tStamp::rCreationChanged( int state )
{
    if(state!=0){
	rModified->setChecked(FALSE);
	rRead->setChecked(FALSE);
    }
    updateFormat();
}
//================================
void tStamp::rModifiedChanged( int state )
{
    if(state!=0){
	rCreation->setChecked(FALSE);
	rRead->setChecked(FALSE);
    }
    updateFormat();
}
//================================
void tStamp::rReadChanged( int state )
{
    if(state!=0){
	rModified->setChecked(FALSE);
	rCreation->setChecked(FALSE);
    }
    updateFormat();
}
//================================
void tStamp::updateFormat()
{
    if(rCreation->isChecked() || rModified->isChecked() || rRead->isChecked()){
	GFormat->setEnabled(TRUE);
	if(kFormat->currentItem()==kFormat->count()-1){
		lblUser->setEnabled(TRUE);
		txtFormat->setEnabled(TRUE);
	}else{
		lblUser->setEnabled(FALSE);
		txtFormat->setEnabled(FALSE);
	}
    }else GFormat->setEnabled(FALSE);
    getExampleDate();
}
//================================
void tStamp::txtFormatTextChanged( const QString &txt )
{
	QString dummy=txt;
    getExampleDate();
}
//================================
void tStamp::getExampleDate()
{
    if(GFormat->isEnabled()){
	QString dateFormat;
	if(txtFormat->isEnabled()) dateFormat=txtFormat->currentText();
	else dateFormat=kFormat->currentText();
/*	QDate d=QDate::currentDate();
	d.setYMD(d.year(),7,4);
	QTime t=QTime::currentTime();
	t.setHMS(3,8,5,1);
	QDateTime tmp(d,t);*/
	QDateTime tmp = QDateTime::currentDateTime();
	lblExample->setText(tmp.toString(dateFormat));
    }else lblExample->setText("");
}
//================================
void tStamp::readConfig( int index )
{
    static bool read=FALSE;
    if(!read){
	KConfig config("gwenrenamerc");
	config.setGroup("UserExpression1");
	for(int i=0;i<HISTORY_ITEMS;i++){
	    QString n;
	    n=QString("Exp%1").arg(i);
	    history[TS1_H_INDEX+i]=config.readEntry(n,QString::null);
	}
	config.setGroup("UserExpression2");
	for(int i=0;i<HISTORY_ITEMS;i++){
	    QString n;
	    n=QString("Exp%1").arg(i);
	    history[TS2_H_INDEX+i]=config.readEntry(n,QString::null);
	    read=TRUE;
	}
    }
    loadUserFormats(index);
}
//================================
void tStamp::writeConfig( int index )
{
    int found=-1;
    QString cur=txtFormat->currentText();
    for(int i=0;i<HISTORY_ITEMS;i++){
    	if(cur==history[index+i]){
		found=i;
		break;
	}
    }
    if(found!=0){
    	if(found==-1) for(int i=HISTORY_ITEMS-2;i>=0;i--) history[index+i+1]=history[index+i];
    	else for(int i=found-1;i>=0;i--) history[index+i+1]=history[index+i];
    }
    history[index]=cur;
    KConfig config("gwenrenamerc");
    if(index==TS1_H_INDEX) config.setGroup("UserExpression1");
    else config.setGroup("UserExpression2");
    for(int i=0;i<HISTORY_ITEMS;i++){
	QString n;
	n=QString("Exp%1").arg(i);
	if(!history[index+i].isEmpty()) config.writeEntry(n,history[index+i]);
	else break;
    }    
}
//================================
void tStamp::loadUserFormats( int index )
{
    QString prev=txtFormat->currentText();
    txtFormat->clear();
    for(int i=0;i<HISTORY_ITEMS;i++) if(!history[index+i].isEmpty()) txtFormat->insertItem( history[index+i] );
    txtFormat->setCurrentText(prev);
}
