/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <stdlib.h>
#include <qcolor.h>
#include <qdir.h>
#include <qdatetime.h>
#include <qregexp.h>
#include <qfileinfo.h>
#include <qtextcodec.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qlineedit.h>
#include <qevent.h>
#include <qnamespace.h>
#include <qheader.h>

#include <klistview.h>
#include <kaboutdialog.h>
#include <kglobalsettings.h>
#include <kglobal.h>
#include <kconfigbase.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include "iconload.h"
#include "filesdata.h"
#include "dirsdata.h"
#include "timestamp.h"
#include "exif.h"
#include "fabout.h"
#include "main.h"

int historyIndex;
QString history[HISTORY_ITEMS * HISTORY_CONTROLS];

  struct config_data{
    QString group;
    QString Name;
    int prof;
    bool changed;
    bool deleted;
    bool renaming;
    //Name
    QString specName;
    int origModif;
    bool useOrigName;
    bool useNumeric;
    //Counter
    int digits;
    int start;
    int step;
    bool sameNum;
    bool allow;
    bool shuffle;
    //Extension
    QString newExt;
    int extModif;
    bool useOrigExt;
    //Misc
    bool showAll;
    QString prefix;
    QString suffix;
  };
  struct all_data{
    //General
    bool useProf;
    int defProf;
    bool autoSave;
    bool prName;
    int numOfProfiles;
    int items;
    config_data *data;
    QString oldName;
    QString enteredName;
    int active;
    bool inRename;
  };

struct all_data pr;
extern filesData f;
extern dirsData g;
extern bool InitiatedRename;
extern QString tFormatBefore;
extern QString tFormatDate;
extern QString tFormatAfter;
extern bool noProfiles;
QString profName;
iconload ic;
int col0;
//================================
void Rename::init(){
    QString forTheDestopFiles(i18n("Rename with GwenRename"));
    loadIcons();
    setIcon(ic.Icon(0));
    rName->setSizeLimit(HISTORY_ITEMS+1);
    nPref->setSizeLimit(HISTORY_ITEMS+1);
    nSuf->setSizeLimit(HISTORY_ITEMS+1);
    rExt->setSizeLimit(HISTORY_ITEMS+1);
    prDefault->setPixmap(ic.Icon(0));
    sTime->setPixmap(ic.Icon(2));
    pTime->setPixmap(ic.Icon(2));
    prLoad->setPixmap(ic.Icon(3));
    prNew->setPixmap(ic.Icon(4));
    prEdit->setPixmap(ic.Icon(5));
    prSave->setPixmap(ic.Icon(6));
    prDelete->setPixmap(ic.Icon(7));
    reRandomize->setPixmap(ic.Icon(8));
    View->addColumn( "",35);
    View->header()->setResizeEnabled( FALSE, View->header()->count() - 1 );
    View->addColumn( i18n( "Original filename" ),300 );
    View->addColumn( i18n( "New filename" ) );
    View->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, 0, 255, View->sizePolicy().hasHeightForWidth() ) );
    View->setMinimumSize( QSize( 0, 200 ) );
    View->setFocusPolicy( KListView::NoFocus );
    View->setResizeMode( KListView::LastColumn );
    col0=View->columnWidth(0);
    fixViewGeometry(0 );
    connect( View->header(), SIGNAL( clicked(int) ), this, SLOT( headerClicked(int) ) );
    QColor back=KGlobalSettings::alternateBackgroundColor();
    if(!back.isValid()) back=KGlobalSettings::calculateAlternateBackgroundColor(View->paletteBackgroundColor());
    View->setAlternateBackground(back);
    profName=i18n("New profile");
    setCaption("GwenRename");
    cmbProfile->setDuplicatesEnabled(FALSE);
    cmbProfile->insertItem( "GwenRename" );
    pr.oldName=QString::null;
    QRect rect=geometry();
    rect.setRight(10);
    rect.setHeight(10);
    setGeometry(rect);
    readConfig();
    lSelected->setText(QString(i18n("%1/%2 items selected")).arg(f.items(),0,10).arg(g.numOfFiles,0,10));
    if(f.Type==2 && f.items()==g.numOfFiles){
	rShuffle->setEnabled(TRUE);
    }else{
	rShuffle->setEnabled(FALSE);
	reRandomize->setEnabled(FALSE);
    }
    KListViewItem * item = new KListViewItem( View, 0 );
    for(int i=0;i<f.items();i++){
	if(i!=0)  item = new KListViewItem( View, item );
	item->setText( 0, f.files[i].fileName());
    }
    if(f.Type==2){
	if(rShuffle->isChecked()) reRandomize->setEnabled(TRUE);
	rSelExt->setEnabled(FALSE);
	rLExt->setEnabled(FALSE);
	rUExt->setEnabled(FALSE);
    }
    rName->setFocus();
    updateNameView();
    updateExtView();
    InitiatedRename=TRUE;
    if(g.numOfFiles==f.items()){
	rShow->setChecked(TRUE);
	rShow->setEnabled(FALSE);
    }
    if(f.items()==1){
	rStep->setMaxValue( 1 );
	rStep->setMinValue( 0 );
	rWidth->setEnabled(FALSE);
	rAllow->setEnabled(FALSE);
	rShuffle->setEnabled(FALSE);
	reRandomize->setEnabled(FALSE);
	sort->setEnabled(FALSE);
    }
    updateView();
}
//================================
void Rename::destroy(){
    delete [] pr.data;
}
/////////////////////////////////////////////////////////////
//
//
//	Slots
//
//
/////////////////////////////////////////////////////////////
//================================
void Rename::updateView()
{
    QString num;
    int k,start=rStart->value();
    bool calculationDone=FALSE;
    if(!InitiatedRename) return;
    buttonOk->setEnabled(FALSE);
    for(int i=0;i<g.numOfFiles;i++) g.ren[g.getSorted(i)].inc=0;
    if(f.Type==2 && rShuffle->isChecked() && rShuffle->isEnabled()){
	for(int i=0;i<g.numOfFiles;i++){
	    g.ren[g.getSorted(i)].Counter="";
	    g.ren[g.getSorted(i)].randomNum=-1;
	}
	// randomize directories
	for(int i=0;i<g.numOfFiles;i++){
	    if(g.ren[g.getSorted(i)].selected){
		// randomize
		int r=getRandom();
		while(randExist(r)) r=getRandom();
		g.ren[g.getSorted(i)].randomNum=r;
		g.ren[g.getSorted(i)].Counter=getNumberByID(r);
	    }
	}
	buttonOk->setEnabled(TRUE);
    }else{
	if(rAllow->isChecked() && rAllow->isEnabled() && canDoRelaxed()){
	    int j=0;
	    while(!g.ren[g.getSorted(j)].selected) j++;
	    if(rStep->value()!=0){
		g.fPart.pref=g.ren[g.getSorted(j)].Prefix;
		g.fPart.suf=g.ren[g.getSorted(j)].Suffix;
		g.fPart.ext=g.ren[g.getSorted(j)].newExtension;
		if(nSpecify->isChecked()){
		    // using user defined name
		    g.fPart.pref+=rName->currentText();
		    g.fPart.digitNum=rDigits->value();
		    if(!g.fPart.pref.isEmpty() && !g.fPart.suf.isEmpty()) g.fPart.partType=3;
		    else if(!g.fPart.pref.isEmpty()) g.fPart.partType=1;
		    else if(!g.fPart.suf.isEmpty()) g.fPart.partType=2;
		    else g.fPart.partType=0;
		}else{
		    // using original name
		}
		for(int i=0;i<g.numOfFiles;i++){
		    if(!g.ren[g.getSorted(i)].selected){
			if(isRelaxed(i)){
			    QString cNum;
			    QString c1Num;
			    bool cont=TRUE;
			    for(int c=g.fPart.pref.length();cont && c<(int)g.ren[g.getSorted(i)].oldName.length();c++){
				c1Num=g.ren[g.getSorted(i)].oldName.mid(c,1);
				if(c1Num >="0" && c1Num<="9") cNum+=c1Num;
				else cont=FALSE;
			    }
			    start = cNum.toInt(&cont)+rStep->value();
			    if(start<rStart->value()) start=rStart->value();
			}
		    }
		}
	    }
	}
	if(rStep->value()>0){
	    //set init values
	    for(int i=0,l=-1;i<g.numOfFiles;i++){
		if(g.ren[g.getSorted(i)].selected){
		    l++;
		    if(rWidth->isChecked()){
			calcDigits();
		    }else{
			g.numOfDigits= rDigits->value();
		    }
		    k=start+l*rStep->value();
		    num=getNumber(k);
		    g.ren[g.getSorted(i)].Counter=num;
		}
	    }//end set init values
	    int cur=start-rStep->value();
	    QString nName;
	    QString tName;
	    for(int i=0;i<g.numOfFiles;i++){
		if(g.ren[g.getSorted(i)].selected){
		    calculationDone=FALSE;
		    while(!calculationDone){
			cur+=rStep->value();
			g.ren[g.getSorted(i)].Counter=getNumber(cur);
			if(g.ren[g.getSorted(i)].newExtension.isEmpty()) nName=f.files[0].dirPath() + "/" + g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter + g.ren[g.getSorted(i)].Suffix;
			else nName=f.files[0].dirPath() + "/" + g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter + g.ren[g.getSorted(i)].Suffix + "." + g.ren[g.getSorted(i)].newExtension;
			calculationDone=checkIt(nName);
		    }
		}
	    }
	}else if(rStep->value()<0){
	    bool conflict=TRUE;
	    start=((-1)*rStep->value()*(f.numOfFiles-2))+rStart->value();
	    //set init values
	    while(conflict){
		    start-=rStep->value();
		    for(int i=0,l=start-rStep->value();i<g.numOfFiles;i++){
			if(g.ren[g.getSorted(i)].selected){
			    l+=rStep->value();
			    if(rWidth->isChecked()){
				calcDigits();
			    }else{
				g.numOfDigits= rDigits->value();
			    }
			    num=getNumber(l);
			    g.ren[g.getSorted(i)].Counter=num;
			}
		    }//end set init values
		    conflict=FALSE;
		    QString tName,nName;
		    for(int i=g.numOfFiles-1;i>=0;i--){
		    	if(g.ren[g.getSorted(i)].selected){
				if(f.Type==2 || g.ren[g.getSorted(i)].newExtension.isEmpty()) tName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
				else tName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter +  g.ren[g.getSorted(i)].Suffix+"." + g.ren[g.getSorted(i)].newExtension;
					nName=tName;
			}
		    	for(int i=0;i<g.numOfFiles;i++){
	    			if(!g.ren[g.getSorted(i)].selected){
					QString mName;
					if(f.Type==2 || g.ren[g.getSorted(i)].newExtension.isEmpty()) mName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
					else mName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter +  g.ren[g.getSorted(i)].Suffix+"." + g.ren[g.getSorted(i)].newExtension;
					if(mName==tName){
						conflict=TRUE;
						break;
					}
				}
		    	}
			if(conflict) break;
		    }
		    // Check for files not in series
		    if(!conflict){
		    		int i;
				QString tmp,tFile,cFile;
				for(i=g.numOfFiles-1;i>=0;i--){
		    			if(g.ren[g.getSorted(i)].selected){
						tmp=increaseQString(g.ren[g.getSorted(i)].Counter);
						if(f.Type==2 || g.ren[g.getSorted(i)].newExtension.isEmpty()) tFile=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].Prefix  + tmp+g.ren[g.getSorted(i)].Suffix;
						else tFile=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].Prefix  + tmp +  g.ren[g.getSorted(i)].Suffix+"." + g.ren[g.getSorted(i)].newExtension;
						for(int m=0;m<g.numOfFiles;m++){
							if(g.ren[g.getSorted(m)].selected){
								if(f.Type==2 || g.ren[g.getSorted(i)].newExtension.isEmpty()) cFile=f.files[0].dirPath() + "/" +g.ren[g.getSorted(m)].Prefix + g.ren[g.getSorted(m)].Counter+g.ren[g.getSorted(m)].Suffix;
								else cFile=f.files[0].dirPath() + "/" +g.ren[g.getSorted(m)].Prefix + g.ren[g.getSorted(m)].Counter +  g.ren[g.getSorted(m)].Suffix+"." + g.ren[g.getSorted(m)].newExtension;
							}else{
								cFile=g.ren[g.getSorted(m)].oldFileName;
							}
							if(tFile==cFile && !g.ren[g.getSorted(m)].selected){
								conflict=TRUE;
								break;
							}
						}
					if(conflict) break;
				}

			}
		}
	}
	}else{
	    for(int i=0;i<g.numOfFiles;i++) g.ren[g.getSorted(i)].Counter="";
	}
    }
// Common part
     for(int i=0;i<g.numOfFiles;i++){
	 if(g.ren[g.getSorted(i)].selected){
	     if(f.Type==2 || g.ren[g.getSorted(i)].newExtension.isEmpty()){
		 g.ren[g.getSorted(i)].newFileName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
		 g.ren[g.getSorted(i)].newTmpFileName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newTmpName + g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
	     }else{
		 g.ren[g.getSorted(i)].newFileName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter +  g.ren[g.getSorted(i)].Suffix+"." + g.ren[g.getSorted(i)].newExtension;
		 g.ren[g.getSorted(i)].newTmpFileName=f.files[0].dirPath() + "/" +g.ren[g.getSorted(i)].newTmpName + g.ren[g.getSorted(i)].Counter + g.ren[g.getSorted(i)].Suffix+ "." + g.ren[g.getSorted(i)].newExtension;
	     }
	 }
     }
     if(rShow->isChecked() && rShow->isEnabled())  rShowClicked(1);
     else rShowClicked(0);
     fixbuttonOk();
}
//================================
void Rename::RenameIt()
{
    static bool renamingIt=FALSE;
	 if(!buttonOk->isEnabled()) return;
    if(cmbProfile->editable() || renamingIt) return;
    renamingIt=TRUE;
    buttonOk->setEnabled(FALSE);
	 writeHistory();
    hide();
    int it=-2;
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    it++;
	    QDir fr=QDir(g.ren[g.getSorted(i)].oldFileName);
	    if(!fr.rename(g.ren[g.getSorted(i)].oldFileName,g.ren[g.getSorted(i)].newTmpFileName)){
	    	if(it==-1) renameError(-1,0);
		else renameError(i,0);
	    }
	}
    }
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    QDir fr=QDir(g.ren[g.getSorted(i)].newTmpFileName);
	    if(!fr.rename(g.ren[g.getSorted(i)].newTmpFileName,g.ren[g.getSorted(i)].newFileName)) renameError(i,1);
	}
    }
	 //writeHistory();
    close(TRUE);
}
//================================
void Rename::nOriginalClicked(int state)
{
    if(state==0){
	nLCase->setEnabled(FALSE);
	nUCase->setEnabled(FALSE);
	nFCap->setEnabled(FALSE);
	nSCap->setEnabled(FALSE);
	nSpecify->setChecked(TRUE);
	if(rStep->value()!=0 && rStep->isEnabled() && nSpecify->isChecked()) rAllow->setEnabled(TRUE);
    }
    else{
 	nLCase->setEnabled(TRUE);
	nUCase->setEnabled(TRUE);
	nFCap->setEnabled(TRUE);
	nSCap->setEnabled(TRUE);
	nSpecify->setChecked(FALSE);
	rAllow->setEnabled(FALSE);
	nOriginal->setFocus();
    }
}
//================================
void Rename::nSpecifyClicked(int state)
{
    if(state==0){
	rName->setEnabled(FALSE);
	nOriginal->setChecked(TRUE);
	rAllow->setEnabled(FALSE);
    }else{
	rName->setEnabled(TRUE);
	nOriginal->setChecked(FALSE);
	if(rStep->value()!=0 && rStep->isEnabled()) rAllow->setEnabled(TRUE);
	rName->setFocus();
    }
    updateNameView();
}
//================================
void Rename::nLCaseClicked( int state )
{
    if(state!=0){
	nUCase->setChecked(FALSE);
	nSCap->setChecked(FALSE);
	nFCap->setChecked(FALSE);
    }
}
//================================
void Rename::nUCaseClicked( int state )
{
    if(state!=0){
	nLCase->setChecked(FALSE);
	nFCap->setChecked(FALSE);
	nSCap->setChecked(FALSE);
    }
}
//================================
void Rename::nFCapClicked( int state )
{
    if(state!=0){
	nSCap->setChecked(FALSE);
	nLCase->setChecked(FALSE);
	nUCase->setChecked(FALSE);
    }
}
//================================
void Rename::nSCapClicked( int state )
{
    if(state!=0){
	nFCap->setChecked(FALSE);
	nLCase->setChecked(FALSE);
	nUCase->setChecked(FALSE);
    }
}
//================================
void Rename::rStepClicked( int val )
{
    if(val==0){
    	lStart->setText(i18n("Start:"));
	lStart->setEnabled(FALSE);
	rStart->setEnabled(FALSE);
	lDigits->setEnabled(FALSE);
	rDigits->setEnabled(FALSE);
	rAllow->setEnabled(FALSE);
	rShuffle->setEnabled(FALSE);
	reRandomize->setEnabled(FALSE);
	rWidth->setEnabled(FALSE);
    }else{
    	if(val>0) lStart->setText(i18n("Start:"));
	else lStart->setText(i18n("End:"));
	lStart->setEnabled(TRUE);
	rStart->setEnabled(TRUE);
	lDigits->setEnabled(TRUE);
	rDigits->setEnabled(TRUE);
	if(f.items()>1){
		if(nSpecify->isChecked()) rAllow->setEnabled(TRUE);
		rWidth->setEnabled(TRUE);
		if(f.Type==2 && f.items()==g.numOfFiles){
			rShuffle->setEnabled(TRUE);
			rAllow->setEnabled(FALSE);
			if(rShuffle->isChecked()) reRandomize->setEnabled(TRUE);
		}
	}
    }
    updateCounterView();
}
//================================
void Rename::rLExtClicked( int state )
{
    if(state!=0) rUExt->setChecked(FALSE);
    updateExtView();
    rLExt->setFocus();
}
//================================
void Rename::rUExtClicked( int state )
{
    if(state!=0) rLExt->setChecked(FALSE);
    updateExtView();
    rUExt->setFocus();
}
//================================
void Rename::nSufChanged()
{
    if(!nSuf->currentText().isEmpty()){
	tFormatDate=nSuf->currentText();
	// Check fot date code
	tStamp *bStamp=new tStamp;
	if(bStamp->checkFormat(nSuf->currentText())){
		useTimeStamp(1);
	}else{
	    for(int i=0;i<g.numOfFiles;i++){
		g.ren[g.getSorted(i)].Suffix=nSuf->currentText();
	    }
	}
	delete bStamp;

    }else{
	for(int i=0;i<g.numOfFiles;i++) g.ren[g.getSorted(i)].Suffix="";
    }
    updateView();
}
//================================
void Rename::rSElExtClicked( int state )
{
    if(state==0){
	rLExt->setEnabled(FALSE);
	rUExt->setEnabled(FALSE);
	lExt->setEnabled(TRUE);
	rExt->setEnabled(TRUE);
	rExt->setFocus();
	for(int i=0;i<g.numOfFiles;i++)
	    if(g.ren[g.getSorted(i)].selected) g.ren[g.getSorted(i)].newExtension=rExt->currentText();
    }else{
	rLExt->setEnabled(TRUE);
	rUExt->setEnabled(TRUE);
	lExt->setEnabled(FALSE);
	rExt->setEnabled(FALSE);
	if(rUExt->isChecked()) rUExt->setFocus();
	else rLExt->setFocus();
	for(int i=0;i<g.numOfFiles;i++){
	    if(g.ren[g.getSorted(i)].selected){
		if(rLExt->isChecked()) g.ren[g.getSorted(i)].newExtension=g.ren[g.getSorted(i)].oldExtension.lower();
		else if(rUExt->isChecked()) g.ren[g.getSorted(i)].newExtension=g.ren[g.getSorted(i)].oldExtension.upper();
		else g.ren[g.getSorted(i)].newExtension=g.ren[g.getSorted(i)].oldExtension;
	    }
	}
    }
    updateExtView();
}
//================================
void Rename::rShowClicked( int val )
{
    int pix_valid=0,pix_invalid=1;
    if(getSameNewName()!=-1){
    	pix_valid=7;
	pix_invalid=7;
    }
    bool VisibleItemSet=FALSE;
    View->clear();
    KListViewItem * itemVisible=0;
    KListViewItem * item = new KListViewItem( View, 0 );
    if(rStep->value()<0 || (sort->isChecked() && sort->isEnabled())) View->setSorting(2);
    else View->setSorting(1);
	for(int i=0,k=0;i<g.numOfFiles;i++){
	    if(g.ren[g.getSorted(i)].selected){
	    	QString firstColumn, secondColumn;
		int icon=-1;
		if(k!=0) item = new KListViewItem( View, item );
		k++;
		if(g.ren[g.getSorted(i)].isDir){
		    if(rShow->isEnabled() && rShow->isChecked()){
		    	firstColumn="/"+g.ren[g.getSorted(i)].oldName;
		    	secondColumn="/"+g.ren[g.getSorted(i)].newName+g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
		    }else{
		    	firstColumn=g.ren[g.getSorted(i)].oldName;
		    	secondColumn=g.ren[g.getSorted(i)].newName+g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
		    }
		}else{
		    if(g.ren[g.getSorted(i)].oldExtension.isEmpty()) firstColumn=g.ren[g.getSorted(i)].oldName;
		    else firstColumn=g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension;
		    if(!g.ren[g.getSorted(i)].newExtension.isEmpty()) secondColumn=g.ren[g.getSorted(i)].newName+g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix+"."+g.ren[g.getSorted(i)].newExtension;
		    else secondColumn=g.ren[g.getSorted(i)].newName+g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix;
		}
		// fix icon
		if(g.ren[g.getSorted(i)].newName+g.ren[g.getSorted(i)].Counter+g.ren[g.getSorted(i)].Suffix+"."+g.ren[g.getSorted(i)].newExtension==g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension) icon=pix_invalid;
		else if(g.ren[g.getSorted(i)].newFileName==f.files[0].dirPath() + "/" || g.ren[g.getSorted(i)].newFileName==f.files[0].dirPath() + "/." + g.ren[g.getSorted(i)].newExtension) icon=7;
		else icon=pix_valid;
		// load them to the list
		item->setText( 1, firstColumn);
		item->setText( 2, secondColumn);
		if(icon!=-1){
			item->setPixmap(0,ic.Icon(icon));
			item->setText( 0," ");
		}
		if(!VisibleItemSet){
			itemVisible=item;
			VisibleItemSet=TRUE;
		}
	    }else{
	    	if(val!=0){
			if(k!=0) item = new KListViewItem( View, item );
			k++;
			if(g.ren[g.getSorted(i)].isDir){
				if(g.ren[g.getSorted(i)].oldExtension.isEmpty()){
					item->setText( 1,"/"+g.ren[g.getSorted(i)].oldName);
					item->setText( 2,"/"+g.ren[g.getSorted(i)].oldName);
				}else{
					item->setText( 1,"/"+g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension);
					item->setText( 2,"/"+g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension);
				}
			}else{
				if(g.ren[g.getSorted(i)].oldExtension.isEmpty()){
					item->setText( 1,g.ren[g.getSorted(i)].oldName);
					item->setText( 2,g.ren[g.getSorted(i)].oldName);
				}else{
					item->setText( 1,g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension);
					item->setText( 2,g.ren[g.getSorted(i)].oldName+"."+g.ren[g.getSorted(i)].oldExtension);
				}
			}
		}
	    }
	}
    fixViewGeometry(1);
    View->ensureItemVisible(itemVisible);
}
//================================
void Rename::pTimeClicked()
{
    historyIndex=TS1_H_INDEX;
    tFormatDate=nPref->currentText();
    getFormatParts(0);
    tStamp *tS=new tStamp;
    if(tS->exec()) nPref->setCurrentText(tFormatBefore+tFormatDate+tFormatAfter);
    nPref->setFocus();
}
//================================
void Rename::sTimeClicked()
{
    historyIndex=TS2_H_INDEX;
    tFormatDate=nSuf->currentText();
    getFormatParts(1);
    tStamp *tS=new tStamp;
    if(tS->exec()) nSuf->setCurrentText(tFormatBefore+tFormatDate+tFormatAfter);
    nSuf->setFocus();
}
//================================
void Rename::showAbout()
{
    fAbout k(this,0,Qt::WType_Dialog | Qt::WShowModal);
    k.exec();
}
//================================
void Rename::CancelIt()
{
    static bool cancelingIt=FALSE;
    if(cmbProfile->editable() || cancelingIt) return;
    close(TRUE);
}
//================================
void Rename::chkProfileCahnged( int state )
{
    if(state==0){
	prNew->setEnabled(FALSE);
	prSave->setEnabled(FALSE);
	prDelete->setEnabled(FALSE);
	cmbProfile->setEnabled(FALSE);
	prDefault->setEnabled(FALSE);
	prLoad->setEnabled(FALSE);
	prEdit->setEnabled(FALSE);
	applyProfile(0);
    }else{
	prNew->setEnabled(TRUE);
	cmbProfile->setEnabled(TRUE);
	cmbProfile->setFocus();
	prDefault->setEnabled(TRUE);
	prLoad->setEnabled(TRUE);
	if(cmbProfile->currentItem()==0){
	    prSave->setEnabled(FALSE);
	    prDelete->setEnabled(FALSE);
	    prEdit->setEnabled(FALSE);
	}else{
	    prSave->setEnabled(TRUE);
	    prDelete->setEnabled(TRUE);
	    prEdit->setEnabled(TRUE);
	}
	applyProfile(getProfileByIndex(cmbProfile->currentItem()));
    }
    pr.useProf=chkProfile->isChecked();
}
//================================
void Rename::cmbProfileChanged( int ind )
{
    if(cmbProfile->editable()){
	if(pr.oldName.isEmpty()){
	    cmbProfile->setCurrentItem(cmbProfile->count()-1);
	    return;
	}else{
	    int i=getProfileByText(pr.oldName);
	    cmbProfile->setCurrentItem(i);
	    return;
	}
    }

    if(pr.defProf==pr.data[cmbProfile->currentItem()].prof){
	prDefault->setEnabled(FALSE);
	prLoad->setEnabled(FALSE);
    }else{
	prDefault->setEnabled(TRUE);
	prLoad->setEnabled(TRUE);
    }
    prNew->setEnabled(TRUE);
    if(ind==0){
	prSave->setEnabled(FALSE);
	prDelete->setEnabled(FALSE);
	prEdit->setEnabled(FALSE);
    }else{
	prSave->setEnabled(TRUE);
	prDelete->setEnabled(TRUE);
	prEdit->setEnabled(TRUE);
    }
    applyProfile(ind);
}
//================================
void Rename::prNewClicked()
{
//    pr.oldIndex=cmbProfile->currentItem();
    cmbProfile->setInsertionPolicy(QComboBox::AtBottom);
    prNew->setEnabled(FALSE);
    prDefault->setEnabled(FALSE);
    prEdit->setEnabled(FALSE);
    prDelete->setEnabled(TRUE);
    prSave->setEnabled(TRUE);
    cmbProfile->setEditable(TRUE);
    cmbProfile->insertItem(profName+getNewProfileNumber());
    cmbProfile->setCurrentItem(cmbProfile->count()-1);
    cmbProfile->setFocus();
    QLineEdit * lin=cmbProfile->lineEdit();
    lin->home(FALSE); lin->end(TRUE);
}
//================================
void Rename::prEditClicked()
{
    pr.inRename=TRUE;
    //cmbProfile->setInsertionPolicy(QComboBox::AfterCurrent);
    cmbProfile->setInsertionPolicy(QComboBox::AtBottom);
    prNew->setEnabled(FALSE);
    prEdit->setEnabled(FALSE);
    prDelete->setEnabled(FALSE);
    prDefault->setEnabled(FALSE);
    prLoad->setEnabled(FALSE);
    cmbProfile->setEditable(TRUE);
    QLineEdit * lin=cmbProfile->lineEdit();
    lin->home(FALSE); lin->end(TRUE);
    pr.data[getProfileByIndex(cmbProfile->currentItem())].renaming=TRUE;
    pr.oldName=cmbProfile->currentText();
    cmbProfile->setFocus();
}
//================================
void Rename::prDeleteClicked()
{
    if(cmbProfile->editable()){ //renaming item
	for(int i=0;i<pr.numOfProfiles;i++) pr.data[i].renaming=FALSE;
	cmbProfile->setEditable(FALSE);
	fill_cmbProfile();
	if(pr.oldName.isEmpty()) cmbProfile->setCurrentItem(getActiveProfileIndex());
    }else{ //new item
    	int prevID=cmbProfile->currentItem();
	int i=getProfileByIndex(prevID);
	int def=getDefProfileIndex();
	if(i==def) pr.defProf=0;
	pr.data[i].deleted=TRUE;
	fill_cmbProfile();

	cmbProfile->setCurrentItem(prevID-1);
    }
    cmbProfileChanged(cmbProfile->currentItem());
    cmbProfile->setFocus();
}
//================================
void Rename::prLoadClicked()
{
    if(pr.defProf==pr.data[getProfileByIndex(cmbProfile->currentItem())].prof) return;
    int i=getDefProfileIndex();
    applyProfile(i);
    cmbProfile->setCurrentItem(i);
    cmbProfileChanged(cmbProfile->currentItem());
    cmbProfile->setFocus();
}

//================================
void Rename::keyPressEvent( QKeyEvent *e )
{
    if(cmbProfile->editable()){
      if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton){
	e->accept();
	prDeleteClicked();
	 }else if((e->key()==Qt::Key_Return && e->state()==Qt::NoButton) || (e->key()==Qt::Key_Enter && e->state()==Qt::Keypad)){
	     e->accept();
	     prSaveClicked();
	 }
    }else{
	if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton){
	    e->accept();
	    CancelIt();
	}else if((e->key()==Qt::Key_Return && e->state()==Qt::NoButton) || (e->key()==Qt::Key_Enter && e->state()==Qt::Keypad)){
	    e->accept();
	    RenameIt();
	}
    }
}

//================================
void Rename::closeEvent( QCloseEvent *e )
{
    if(cmbProfile->editable()){
      e->ignore();
      return;
    }
    writeConfig();
    e->accept();
    delete [] pr.data;
    exit(0);
}
//================================
void Rename::prSaveClicked()
{
    if(cmbProfile->editable()){
    	QString tmp;
	if(pr.enteredName.isEmpty()) tmp=cmbProfile->currentText();
	else tmp=pr.enteredName;
	pr.enteredName="";
	if(tmp.isEmpty()) return;
	int ind;
	if(dublicateElement(tmp)){
	    QString m;
	    m=QString(i18n("A profile named \"%1\" already exists.\nPlease select a different name for this profile")).arg(tmp);
	    QLineEdit *ed=cmbProfile->lineEdit();
	    ed->setText(tmp);
	    KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
	    return;
	}else{
	    if(pr.oldName.isEmpty()){ // new item
		int idProf;
		if((idProf=getDeletedProfile())==-1){
		    idProf=pr.numOfProfiles;
		    pr.numOfProfiles++;
		    reAllocateConfigData(pr.numOfProfiles);
		}
		//check if reallocation was succes
		fillProfile(idProf);
		pr.data[idProf].prof=getFreeProfileNum();
		pr.active=pr.data[idProf].prof;
		pr.data[idProf].deleted=FALSE;
		pr.data[idProf].renaming=FALSE;
		pr.data[idProf].changed=TRUE;
	    }else{ // renaming
		ind=getProfileByText(pr.oldName);
		pr.data[ind].deleted=FALSE;
		pr.data[ind].renaming=FALSE;
		if(pr.oldName==tmp) pr.data[ind].changed=FALSE;
		else{
			pr.data[ind].changed=TRUE;
			pr.data[ind].Name=tmp;
		}
		pr.oldName=QString::null;
	    }
	    fill_cmbProfile();
	}
	cmbProfile->setEditable(FALSE);
    }else{
	if(cmbProfile->currentItem()==0) return;
	int prof=getProfileByIndex( cmbProfile->currentItem());
	fillProfile(pr.data[prof].prof);
	pr.data[prof].changed=TRUE;
	pr.data[prof].deleted=FALSE;
	pr.data[prof].renaming=FALSE;
    }
    cmbProfileChanged( cmbProfile->currentItem() );
    cmbProfile->setFocus();
}
//================================
void Rename::fill_cmbProfile()
{
	cmbProfile->clear();
	QPixmap *pix=(QPixmap *)prDefault->pixmap();
	for(int i=0;i<pr.numOfProfiles;i++){
		if(!pr.data[i].deleted){
			if(pr.data[i].prof==pr.defProf) cmbProfile->insertItem(*pix,pr.data[i].Name);
			else cmbProfile->insertItem(pr.data[i].Name);
			if(pr.active==pr.data[i].prof){
				cmbProfile->setCurrentItem(i);
				applyProfile(i);
			}
		}
	}
}
//================================
void Rename::rStartClicked( int val )
{
	updateCounterView();
}
//================================
void Rename::headerClicked( int section )
{
	return;
//  if(rShow->isClicked() && rShow)
	QListViewItem *it;
	int ind=-1,found=-1;
	if(!rShow->isEnabled() || (rShow->isEnabled() && !rShow->isChecked())){
		it=View->itemAtIndex(0);
		View->ensureItemVisible(it);
	}else{

	qWarning("Header clicked, section %d",section);
	for(ind=0;ind<g.numOfFiles;ind++){
		qWarning("ind: %d",ind);
    it=View->itemAtIndex(ind);
		if(findSelected(it->text(2))){
			found=ind;
			qWarning("found = %d",found);
			//break;  //enable line to have first item visible
		}
	}
	if(found!=-1){
		it=View->itemAtIndex(found);
		View->ensureItemVisible(it);
	}
}
}
//================================
void Rename::updateNameView()
{
    QString a,b;
    if(nPref->currentText().isEmpty())
	for(int i=0;i<g.numOfFiles;i++) g.ren[g.getSorted(i)].Prefix="";
    else{
	tFormatDate=nPref->currentText();
	// Check fot date code
	tStamp *bStamp=new tStamp;
	if(bStamp->checkFormat(nPref->currentText())){
		useTimeStamp(0);
	}else{
	    for(int i=0;i<g.numOfFiles;i++){
		g.ren[g.getSorted(i)].Prefix=nPref->currentText();
	    }
	}
	delete bStamp;
    }
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    a=""; b="";
	    if( nOriginal->isChecked()){
		if( nLCase->isChecked()) a=g.ren[g.getSorted(i)].oldName.lower();
		else if( nUCase->isChecked()) a=g.ren[g.getSorted(i)].oldName.upper();
		else a=g.ren[g.getSorted(i)].oldName;

		if( nFCap->isChecked() && nFCap->isEnabled()){
		    a=g.ren[g.getSorted(i)].oldName.lower();
		    a=firstCapitalize(a);
		}else if( nSCap->isChecked() && nSCap->isEnabled()){
		    a=g.ren[g.getSorted(i)].oldName.lower();
		    a=allCapitalize(a);
		}else if(a.isEmpty()) a=g.ren[g.getSorted(i)].oldName;
	    }else{
		if(!rName->currentText().isEmpty()) a=rName->currentText();
	    }

	    b=a;
	    b.append(QString("_tmp"));
	    g.ren[g.getSorted(i)].newName=g.ren[g.getSorted(i)].Prefix+a;
	    g.ren[g.getSorted(i)].newTmpName=g.ren[g.getSorted(i)].Prefix+b;
	}
    }
    updateView();
}
//================================
void Rename::updateExtView()
{
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    QString a=QString("");
	    if(f.Type!=2) {
		if( rSelExt->isChecked()){
		    if( rLExt->isChecked()) a=g.ren[g.getSorted(i)].oldExtension.lower();
		    else if( rUExt->isChecked()) a=g.ren[g.getSorted(i)].oldExtension.upper();
		    else a=g.ren[g.getSorted(i)].oldExtension;
		}else{
		    if( !rExt->currentText().isEmpty()) a=rExt->currentText();
		}
	    }
	    g.ren[g.getSorted(i)].newExtension=a;
	}
    }
    updateView();
}
//================================
void Rename::updateCounterView()
{
    if(rShuffle->isChecked() && rShuffle->isEnabled() && f.items()>1){
	reRandomize->setEnabled(TRUE);
	rAllow->setEnabled(FALSE);
    }else{
	reRandomize->setEnabled(FALSE);
	if(f.items()>1 && rStep->value()!=0 && rStep->isEnabled() && nSpecify->isChecked()) rAllow->setEnabled(TRUE);
    }
    if(rStep->value()<0){
    	rAllow->setEnabled(FALSE);
	//rStart->setValue((-1)*rStep->value()*(f.numOfFiles-1));
    }
    updateView();
}
//================================
void Rename::prDefaultClicked()
{
    prDefault->setEnabled(FALSE);
    prLoad->setEnabled(FALSE);
    if(cmbProfile->count()==1){
	pr.defProf=0;
	QPixmap *pix=(QPixmap *)prDefault->pixmap();
	cmbProfile->changeItem(*pix,cmbProfile->text(0),0);
    }else{
	int i=getDefProfileIndex();
	cmbProfile->changeItem(cmbProfile->text(i),i);
	QPixmap *pix=(QPixmap *)prDefault->pixmap();
	i=cmbProfile->currentItem();
	cmbProfile->changeItem(*pix,cmbProfile->text(i),i);
	i=getProfileByIndex(i);
	pr.defProf=pr.data[i].prof;
    }
}
/////////////////////////////////////////////////////////////
//
//
//	End of Slots
//
//
/////////////////////////////////////////////////////////////
//================================
int Rename::calcDigits( void )
{
	QString tmp;
	int k=rStart->value();
	if(rStep->value()>0) for(int i=1;i<f.items();i++) k+=rStep->value();
	else for(int i=1;i<f.items();i++) k-=rStep->value();
	tmp.setNum(k);
	while((int)tmp.length()<rDigits->value()) tmp.prepend("0");
	int digits=(int) tmp.length();
	g.numOfDigits=digits;
	return digits;
}
//================================
QString Rename::getNumber( int num )
{
    QString s;
    s.setNum(num);
    while((int)s.length()<g.numOfDigits) s.prepend("0");
    return s;
}
//================================
QString Rename::getNumberByID( int num )
{
    QString tmp;
    int k;
    if(num==0){
	k=rStart->value();
    }
    else{
	k=rStart->value();
	for(int i=1;i<=num;i++) k+=rStep->value();
    }
    tmp.setNum(k);
    if(rWidth->isChecked()) calcDigits();
    else g.numOfDigits=rDigits->value();
    while((int)tmp.length()<g.numOfDigits) tmp.prepend("0");
    return tmp;
}
//================================
QString Rename::firstCapitalize( QString s )
{
QString tmp;
tmp=s.left(1).upper();
tmp+=s.mid(1,s.length());
return tmp;
}
//================================
QString Rename::allCapitalize( QString s )
{
uint i;
QString tmp=s;
for(i=0;i<s.length();i++){
    if((s.mid(i,1))==QString(" ")){
	tmp=s.replace(i+1,1,s.mid(i+1,1).upper());
    }
}
tmp=firstCapitalize(tmp);
 return tmp;
}

//================================
bool Rename::checkFile( int item )
{
    int i;
    QString tName;
    QString nName;
    nName=f.files[0].dirPath() + "/" + g.ren[g.getSorted(item)].newName + g.ren[g.getSorted(item)].Counter + g.ren[g.getSorted(item)].Suffix + "." + g.ren[g.getSorted(item)].newExtension;
    for(i=0;i<g.numOfFiles;i++){
	if(nName.find(g.ren[g.getSorted(i)].oldFileName ,0,FALSE)==0){
	    if(i!=item && !g.ren[g.getSorted(i)].selected){
		g.ren[g.getSorted(item)].inc++;
		return FALSE;
	    }
	}
    }
    for(i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected && i!=item){
	    tName=f.files[0].dirPath() + "/" + g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter  + g.ren[g.getSorted(i)].Suffix + "." + g.ren[g.getSorted(i)].newExtension;
		if(nName.find(tName ,0,FALSE)==0){
		    g.ren[g.getSorted(item)].inc++;
		    return FALSE;
		}
	    }
    }
    return TRUE;
}
//================================
void Rename::fixViewGeometry( int mode )
{
    for(int i=0;i<View->header()->count();i++) View->header()->setClickEnabled( TRUE, i);
    View->setAllColumnsShowFocus( TRUE );
    View->setShowSortIndicator(TRUE);
    View->setResizeMode( KListView::LastColumn );
    if(mode==0){
    }else{
    }
    View->setColumnWidth(0,col0);
    View->setColumnWidth(1,300);
}
//================================
void Rename::fixbuttonOk()
{
    if(getSameNewName()!=-1){
	buttonOk->setEnabled(FALSE);
	return;
    }
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    if(g.ren[g.getSorted(i)].oldFileName!=g.ren[g.getSorted(i)].newFileName){
		buttonOk->setEnabled(TRUE);
		return;
	    }
        }
    }
}
//================================
int Rename::getRandom()
{
    QString t;
    t=QString("%1").arg(rand());
    QString b=t.mid(4,1);
    int c=b.toInt();
    b=t.right((uint)c);
    b.prepend("0.");
    float l=b.toFloat();
    int k=f.items();
    l*=k;
    return (int) l;
}
//================================
bool Rename::randExist( int num )
{
    for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected && g.ren[g.getSorted(i)].randomNum==num) return TRUE;
    }
    return FALSE;
}
//================================
bool Rename::isRelaxed( int item )
{
    int i;
    bool ret=TRUE;
    QString old=g.ren[g.getSorted(item)].oldName;
    int oldLength=g.ren[g.getSorted(item)].oldName.length();
    if(!g.ren[g.getSorted(item)].oldExtension.isEmpty()){
	oldLength+=g.ren[g.getSorted(item)].oldExtension.length()+1;
	old+=".";
	old+=g.ren[g.getSorted(item)].oldExtension;
    }
    int regLength=g.fPart.pref.length()+g.fPart.digitNum+g.fPart.suf.length();
    QString t=g.fPart.pref;
    for(i=0;i<g.fPart.digitNum;i++) t+="[0-9]";
    t+=g.fPart.suf;
    if(!g.fPart.ext.isEmpty()){
	regLength+=g.fPart.ext.length()+1;
	t+=".";
	t+=g.fPart.ext;
    }
    t+="$";
    if(regLength == oldLength){
	QRegExp l=QRegExp(t,FALSE,FALSE);
	int ans=old.find(l,0);
	if(ans!=0) ret=FALSE;
    }else ret=FALSE;
    return ret;
}
//================================
void Rename::useTimeStamp( int mode )
{
    QString out;
    for(int j=0;j<g.numOfFiles;j++){
	if(g.ren[g.getSorted(j)].selected){
	    QDateTime fTime;
	    fTime=getTimeStampData(g.ren[g.getSorted(j)].oldFileName,tFormatDate.left(1));
	    out=tFormatBefore+fTime.toString(fixFormat(tFormatDate))+tFormatAfter;
	    if(mode==0) g.ren[g.getSorted(j)].Prefix=out;
	    else g.ren[g.getSorted(j)].Suffix=out;
	}
    }
}
//================================
QString Rename::fixFormat( QString mFormat )
{
    QString a=mFormat.right(mFormat.length()-1);
    QRegExp reg=QRegExp("D");a.replace(reg,"d");
    reg=QRegExp("Y");a.replace(reg,"y");
    reg=QRegExp("H");a.replace(reg,"h");
    reg=QRegExp("S");a.replace(reg,"s");
    reg=QRegExp("Z");a.replace(reg,"z");
    return a;
}
//================================
void Rename::getFormatParts( int mode )
{
    int i=-1;
    int pos,l=0;
    QString a,b,c;
    if(mode==0) c=nPref->currentText();
    else c=nSuf->currentText();
    while((i=c.find(":",i+1,TRUE))!=-1) l++;
    if(l==2){
	pos=c.find(":",0,TRUE);
	a=c.left(pos);
	pos=c.find(":",pos+1,TRUE);
	b=c.right(c.length()-pos-1);
    }else{
	pos=nPref->cursorPosition();
	a=nPref->currentText().left(pos);
	b=nPref->currentText().right(nPref->currentText().length()-pos);
	if((i=a.find(":",0,TRUE))!=-1) a=a.left(i);
	if((i=b.find(":",0,TRUE))!=-1) b=b.right(b.length()-i-1);
    }
    tFormatBefore=a;
    tFormatAfter=b;
}
//================================
bool Rename::canDoRelaxed( void )
{
    //return FALSE;
    int i=0;
    while(!g.ren[g.getSorted(i)].selected) i++;
    QString p=g.ren[g.getSorted(i)].Prefix;
    QString s=g.ren[g.getSorted(i)].Suffix;
    for(i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
	    if(p!=g.ren[g.getSorted(i)].Prefix) return FALSE;
	    if(s!=g.ren[g.getSorted(i)].Suffix) return FALSE;
	}
    }
    return TRUE;
}
//================================
QDateTime Rename::getTimeStampData( QString fName, QString type )
{
    QFileInfo f=QFileInfo(fName);
    if(type=="C") return f.created();
    else if(type=="M") return f.lastModified();
    else if(type=="R") return f.lastRead();
    else if(type=="E"){
	EXIF ex(fName);
	if(ex.isExif){
	    //read Exif data
	    QString retDate=ex.getExifDate(1);
	    if(isValidExifDate(retDate)){
		QDateTime dt;
		dt=exifToDate(retDate);
		if(!dt.isValid()) return f.created();
		return dt;
	    }else return f.created();
	}else return f.created();
    }else if(type=="L"){
	EXIF ex(fName);
	if(ex.isExif){
	    //read Exif data
	    QString retDate=ex.getExifDate(0);
	    if(isValidExifDate(retDate)){
		QDateTime dt;
		dt=exifToDate(retDate);
		if(!dt.isValid()) return f.lastModified();
		return dt;
	    }else return f.lastModified();
	}return f.lastModified();
    }
    return f.created();
}
//================================
bool Rename::isValidExifDate( QString s )
{
    QString a("^[0-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]$");
    QRegExp reg(a);
    if(s.find(reg,0)==-1) return FALSE;
    else return TRUE;
}
//================================
QDateTime Rename::exifToDate( QString x )
{
    int y,m,d;
    bool ok;
    y=x.left(4).toInt(&ok);
    m=x.mid(5,2).toInt(&ok);
    d=x.mid(8,2).toInt(&ok);
    QDate ddDate(y,m,d);
    int h,s,ms;
    h=x.mid(11,2).toInt(&ok);
    s=x.mid(14,2).toInt(&ok);
    ms=x.mid(17,2).toInt(&ok);
    QTime ttTime(h,s,ms);
    QDateTime r(ddDate,ttTime);
    return r;
}
//================================
bool Rename::checkIt( const QString mName )
{
    QString tName;
    for(int j=0;j<g.numOfFiles;j++){
	if(!g.ren[g.getSorted(j)].selected){
	    tName=g.ren[g.getSorted(j)].oldFileName;
	    //if(mName.find(tName ,0,FALSE)==0) return FALSE;
	    if(mName==tName) return FALSE;
	}
    }
    return TRUE;
}
/////////////////////////////////////////////////////////////
//
//
//	Profiles
//
//
/////////////////////////////////////////////////////////////
//================================
void Rename::readConfig()
{
    readHistory();
    if(noProfiles){
	btngrpProfiles->setEnabled(FALSE);
	return;
    }
  KConfig config("gwenrenamerc");
  config.setGroup("General");
  pr.useProf=config.readBoolEntry("use profiles",FALSE);
  pr.defProf=config.readNumEntry("default profile",0);
  pr.numOfProfiles=1;
  readProfiles(&config);
  //init Profile0
  pr.data[0].changed=FALSE; pr.data[0].deleted=FALSE;
  pr.data[0].prof=0; pr.data[0].Name=cmbProfile->text(0);
  pr.data[0].specName=""; pr.data[0].origModif=-1;
  pr.data[0].useOrigName=FALSE;
  pr.data[0].useNumeric=FALSE;
  pr.data[0].digits=3; pr.data[0].start=1; pr.data[0].step=1;
  pr.data[0].sameNum=TRUE; pr.data[0].allow=FALSE;
  pr.data[0].shuffle=FALSE; pr.data[0].newExt="";
  pr.data[0].extModif=-1;  pr.data[0].useOrigExt=TRUE;
  pr.data[0].showAll=FALSE; pr.data[0].prefix=""; pr.data[0].suffix="";
  //
  pr.active=0;
  fill_cmbProfile();
  int i=getDefProfileIndex();
  if(pr.useProf) applyProfile(i);
  cmbProfile->setCurrentItem(i);
  if(i!=0 && pr.useProf){
      prEdit->setEnabled(TRUE);
      prSave->setEnabled(TRUE);
      prDelete->setEnabled(TRUE);
  }
  chkProfile->setChecked(pr.useProf);
  prDefault->setEnabled(FALSE);
  prLoad->setEnabled(FALSE);
  //chkProfile->setChecked(i);
}
//================================
void Rename::writeConfig()
{
    if(noProfiles) return;
    KConfig config("gwenrenamerc");
    clearDeletedProfiles( &config );
    // Name group
    config.setGroup("General");
    config.writeEntry("use profiles",pr.useProf);
    config.writeEntry("default profile",pr.defProf);
    int count=0;
    for(int i=1;i<pr.numOfProfiles;i++){
	if(!pr.data[i].deleted){
	    count++;
	    if(count!=pr.data[i].prof){
		config.deleteGroup(QString("Profile%1").arg(pr.data[i].prof),TRUE,FALSE);
		if(pr.data[i].prof==pr.defProf) pr.defProf=count;
		pr.data[i].prof=count;
		pr.data[i].changed=TRUE;
	    }
	}
    }
    //config.writeEntry("number of profiles",pr.numOfProfiles);
    for(int i=1;i<pr.numOfProfiles;i++){
	if(pr.data[i].changed && !pr.data[i].deleted){
	    pr.data[i].changed=FALSE;
	    config.setGroup(QString("Profile%1").arg(pr.data[i].prof));
	    config.writeEntry("profile name",pr.data[i].Name);
	    // name
	    config.writeEntry("specified name",pr.data[i].specName);
	    config.writeEntry("original modifier",pr.data[i].origModif);
	    config.writeEntry("use original name",pr.data[i].useOrigName);
	    config.writeEntry("use numeric sorting",pr.data[i].useNumeric);
	    // counter
	    config.writeEntry("counter digits",pr.data[i].digits);
	    config.writeEntry("counter start",pr.data[i].start);
	    config.writeEntry("counter step",pr.data[i].step);
	    config.writeEntry("counter same number",pr.data[i].sameNum);
	    config.writeEntry("counter relaxed",pr.data[i].allow);
	    config.writeEntry("counter shuffle",pr.data[i].shuffle);
	    // extension
	    config.writeEntry("new extension",pr.data[i].newExt);
	    config.writeEntry("extension modifier",pr.data[i].extModif);
	    config.writeEntry("use original extension",pr.data[i].useOrigExt);
	    //Misc
	    config.writeEntry("show all",pr.data[i].showAll);
	    config.writeEntry("prefix",pr.data[i].prefix);
	    config.writeEntry("suffix",pr.data[i].suffix);
	}
    }
    config.sync();
}
//================================
bool Rename::reAllocateConfigData( int items )
{
    if(items<=pr.items) return TRUE;
    config_data *tmp;
    tmp=new config_data[items];
    if(tmp==NULL) exitError();
    for(int i=0;i<pr.numOfProfiles-1;i++){
	tmp[i].group=pr.data[i].group;
	tmp[i].Name=pr.data[i].Name;
	tmp[i].prof=pr.data[i].prof;
	tmp[i].changed=pr.data[i].changed;
	tmp[i].deleted=pr.data[i].deleted;
	tmp[i].renaming=pr.data[i].renaming;
	tmp[i].specName=pr.data[i].specName;
	tmp[i].origModif=pr.data[i].origModif;
	tmp[i].useOrigName=pr.data[i].useOrigName;
	tmp[i].digits=pr.data[i].digits;
	tmp[i].start=pr.data[i].start;
	tmp[i].step=pr.data[i].step;
	tmp[i].sameNum=pr.data[i].sameNum;
	tmp[i].allow=pr.data[i].allow;
	tmp[i].shuffle=pr.data[i].shuffle;
	tmp[i].newExt=pr.data[i].newExt;
	tmp[i].extModif=pr.data[i].extModif;
	tmp[i].useOrigExt=pr.data[i].useOrigExt;
	tmp[i].showAll=pr.data[i].showAll;
	tmp[i].prefix=pr.data[i].prefix;
	tmp[i].suffix=pr.data[i].suffix;
    }
    delete [] pr.data;
    pr.data=tmp;
    return TRUE;
}
//================================
void Rename::fillProfile( int item )
{
    pr.data[item].Name=cmbProfile->currentText();
    pr.data[item].changed=FALSE;
    pr.data[item].deleted=FALSE;
    pr.data[item].renaming=FALSE;
    // Name group
    pr.data[item].specName=rName->currentText();
    pr.data[item].useOrigName=nOriginal->isChecked();
    int modif=-1;
    if(nLCase->isChecked()) modif=0;
    else if(nUCase->isChecked()) modif=1;
    else if(nFCap->isChecked()) modif=2;
    else if(nSCap->isChecked()) modif=3;
    pr.data[item].origModif=modif;
    pr.data[item].useOrigName=nOriginal->isChecked();
    pr.data[item].useNumeric=sort->isChecked();
    // Counter group
    pr.data[item].digits=rDigits->value();
    pr.data[item].start=rStart->value();
    pr.data[item].step=rStep->value();
    pr.data[item].sameNum=rWidth->isChecked();
    pr.data[item].allow=rAllow->isChecked();
    pr.data[item].shuffle=rShuffle->isChecked();
    // Extension group
    pr.data[item].newExt=rExt->currentText();
    modif=-1;
    if(rLExt->isChecked()) modif=0;
    else if(rUExt->isChecked()) modif=1;
    pr.data[item].extModif=modif;
    pr.data[item].useOrigExt=rSelExt->isChecked();
    // Misc group
    pr.data[item].showAll=rShow->isChecked();
    pr.data[item].prefix=nPref->currentText();
    pr.data[item].suffix=nSuf->currentText();
}
//================================
void Rename::applyProfile( int index )
{
    InitiatedRename=FALSE;
    int i=getProfileByIndex(index);
    pr.active=i;
    // Name group
    rName->setCurrentText(pr.data[i].specName);
    int modif=pr.data[i].origModif;
    nLCase->setChecked(FALSE);nUCase->setChecked(FALSE);
    nFCap->setChecked(FALSE);nSCap->setChecked(FALSE);
    if(modif==0) nLCase->setChecked(TRUE);
    else if(modif==1) nUCase->setChecked(TRUE);
    else if(modif==2) nFCap->setChecked(TRUE);
    else if(modif==3) nSCap->setChecked(TRUE);
    nOriginal->setChecked(FALSE);
    nSpecify->setChecked(FALSE);
    if(pr.data[i].useOrigName) nOriginal->setChecked(TRUE);
    else nSpecify->setChecked(TRUE);
    if(pr.data[i].useNumeric && sort->isEnabled()) sort->setChecked(TRUE);
    else sort->setChecked(FALSE);
    // Counter group
    rDigits->setValue(pr.data[i].digits);
    rStart->setValue(pr.data[i].start);
     rStep->setValue(pr.data[i].step);
    //if(f.items()==1)    rStep->setValue(pr.data[i].step);
    //else{
    if(f.items()==1){
    	//rStep->setValue(1);
	rWidth->setEnabled(FALSE);
	rAllow->setEnabled(FALSE);
	rShuffle->setEnabled(FALSE);
	reRandomize->setEnabled(FALSE);
    }
    rWidth->setChecked(pr.data[i].sameNum);
    rAllow->setChecked(pr.data[i].allow);
    rShuffle->setChecked(pr.data[i].shuffle);
    // Extension group
    rExt->setCurrentText(pr.data[i].newExt);
    modif=pr.data[i].extModif;
    rLExt->setChecked(FALSE);rUExt->setChecked(FALSE);
    if(modif==0){
	rUExt->setChecked(FALSE);
	rLExt->setChecked(TRUE);
    }else if(modif==1){
	rLExt->setChecked(FALSE);
	rUExt->setChecked(TRUE);
    }
    rSelExt->setChecked(TRUE);
    rSelExt->setChecked(pr.data[i].useOrigExt);
    if(rSelExt->isChecked()){
	rUExt->setEnabled(TRUE);
	rLExt->setEnabled(TRUE);
	lExt->setEnabled(FALSE);
	rExt->setEnabled(FALSE);
    }else{
	rUExt->setEnabled(FALSE);
	rLExt->setEnabled(FALSE);
	lExt->setEnabled(TRUE);
	rExt->setEnabled(TRUE);
    }
    // Misc group
    rShow->setChecked(pr.data[i].showAll);
    nPref->setCurrentText(pr.data[i].prefix);
    nSuf->setCurrentText(pr.data[i].suffix);
    if(cmbProfile->isEnabled()) cmbProfile->setFocus();
    InitiatedRename=TRUE;
    updateView();
}
//================================
int Rename::getProfileByIndex( int index )
{
    int i;
    for(i=0;i<pr.numOfProfiles;i++)
	if(cmbProfile->text(index)==pr.data[i].Name && !pr.data[i].deleted) return i;
    return -1;
}
//================================
int Rename::getProfileByCurrentText()
{
    int i;
    QString tmp=cmbProfile->currentText();
    for(i=0;i<pr.numOfProfiles;i++)
	if(tmp==pr.data[i].Name && !pr.data[i].deleted) return i;
    return -1;
}
//================================
int Rename::getProfileByText(QString txt)
{
    int i;
    for(i=0;i<pr.numOfProfiles;i++)
	if(txt==pr.data[i].Name && !pr.data[i].deleted) return i;
    return -1;
}
//================================
int Rename::getDefProfileIndex()
{
    for(int i=0;i<pr.numOfProfiles;i++){
	if(!pr.data[i].deleted){
	    if(pr.data[i].prof==pr.defProf) return i;
	}
     }
    return 0;
}
//================================
QString Rename::getNewProfileNumber()
{
    int i;
    int max=0;
    QString txt;
    for(i=0;i<cmbProfile->count();i++){
	txt=cmbProfile->text(i);
	if(txt.find(profName)==0){
	    if(txt==profName) max=1;
	    else{
		bool ok;
    QString tmp=profName + " ";
		txt.remove(tmp);
		int num=txt.toInt(&ok)+1;
		if(num>max) max=num;
	    }
	}
    }
    if(max==0) return QString::null;
    else{
	QString tmp=" ";
	tmp.append(QString::number(max));
	return tmp;
    }
}
//================================
int Rename::readProfiles( KConfig *conf )
{
    bool ok=FALSE;int num=0;
    QStringList gr=conf->groupList();
    QStringList profs=gr.grep(QRegExp("Profile[0-9][0-9]*"));
    QStringList::iterator it=profs.begin();
    pr.numOfProfiles=profs.count()+1;
    pr.data=new config_data[pr.numOfProfiles];
    if(pr.data==NULL) exitError();
    for(;!(*it).isEmpty();++it){
	num++;
	conf->setGroup(*it);
	pr.data[num].deleted=FALSE;
	pr.data[num].changed=FALSE;
	pr.data[num].group=*it;
	pr.data[num].Name=conf->readEntry("profile name",*it);
	pr.data[num].specName=conf->readEntry("specified name",QString::null);
	pr.data[num].origModif=conf->readNumEntry("original modifier",-1);
	pr.data[num].useOrigName=conf->readBoolEntry("use original name",TRUE);
	pr.data[num].useNumeric=conf->readBoolEntry("use numeric sorting",FALSE);
	pr.data[num].digits=conf->readNumEntry("counter digits",3);
	pr.data[num].start=conf->readNumEntry("counter start",1);
	pr.data[num].step=conf->readNumEntry("counter step",1);
	pr.data[num].sameNum=conf->readBoolEntry("counter same number",FALSE);
	pr.data[num].allow=conf->readBoolEntry("counter relaxed",FALSE);
	pr.data[num].shuffle=conf->readBoolEntry("counter shuffle",FALSE);
	pr.data[num].newExt=conf->readEntry("new extension",QString::null);
	pr.data[num].extModif=conf->readNumEntry("extension modifier",-1);
	pr.data[num].useOrigExt=conf->readBoolEntry("use original extension",TRUE);
	pr.data[num].showAll=conf->readBoolEntry("show all",FALSE);
	pr.data[num].prefix=conf->readEntry("prefix",QString::null);
	pr.data[num].suffix=conf->readEntry("suffix",QString::null);
	pr.data[num].prof=(*it).remove("Profile").toInt(&ok);
    }
    return pr.numOfProfiles;
}
//================================
void Rename::clearDeletedProfiles( KConfig *conf )
{
    for(int i=1;i<pr.numOfProfiles;i++){
	if(pr.data[i].deleted) conf->deleteGroup(QString("Profile%1").arg(pr.data[i].prof),TRUE,FALSE);
    }
}
//================================
int Rename::getDeletedProfile()
{
for(int i=1;i<pr.numOfProfiles;i++) if(pr.data[i].deleted) return i;
return -1;
}
//================================
int Rename::getFreeProfileNum()
{
    int max=0;
    for(int i=1;i<pr.numOfProfiles-1;i++) if(pr.data[i].prof>max) max=pr.data[i].prof;
    max++;
    return max;
}
//================================
bool Rename::dublicateElement( QString tmp )
{
    int i;
    int limit;
    if(pr.inRename) limit=cmbProfile->count();
    else limit=cmbProfile->count()-1;
    for(i=0;i<pr.numOfProfiles;i++){
	if(!pr.data[i].deleted){
	    if(tmp==pr.data[i].Name && !pr.data[i].renaming) return TRUE;
	}
    }
    return FALSE;
}
//================================
int Rename::getActiveProfileIndex()
{
	QString a="GwenRename";
	for(int i=0;i<pr.numOfProfiles;i++){
		if(pr.active==pr.data[i].prof){
			a=pr.data[i].Name;
			break;
		}
	}
	int id=0;
	for(int i=0;i<cmbProfile->count();i++){
		if(a==cmbProfile->text(i)){
			id=i;
			break;
		}
	}
	return id;
}
//================================
bool Rename::notRevised( int id )
{
    for(int i=1;i<pr.numOfProfiles;i++)
	if(pr.data[i].prof==id && !pr.data[i].deleted) return FALSE;
    return TRUE;
}
//================================
void Rename::cmbProfileEnter( const QString &txt )
{
    pr.enteredName=txt;
}
//================================
void Rename::cmbProfileEnterPressed()
{
}
/////////////////////////////////////////////////////////////
//
//
//	End of Profiles
//
//
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//
//
//	History
//
//
/////////////////////////////////////////////////////////////
//================================
void Rename::readHistory()
{
    QString tmp;
    QString group;
    KConfig config("gwenrenamerc");
    config.setGroup("NameHistory");
    rName->clear();
    rName->insertItem("");
    for(int i=0;i<HISTORY_ITEMS;i++){
	group=QString("Exp%1").arg(i);
	tmp=config.readEntry(group,QString::null);
	if(tmp.isEmpty()) break;
	else if(historyItemExist(rName,tmp)) continue;
	else rName->insertItem(tmp);
    }
    for(int i=0;i<rName->count();i++) history[i]=rName->text(i);
    rName->setCurrentText("");
    config.setGroup("PrefixHistory");
    nPref->clear();
    nPref->insertItem("");
    for(int i=0;i<HISTORY_ITEMS;i++){
	group=QString("Exp%1").arg(i);
	tmp=config.readEntry(group,QString::null);
	if(tmp.isEmpty()) break;
	else if(historyItemExist(nPref,tmp)) continue;
	else nPref->insertItem(tmp);
    }
    for(int i=0;i<nPref->count();i++) history[P_H_INDEX+i]=nPref->text(i);
    nPref->setCurrentText("");
    config.setGroup("SuffixHistory");
    nSuf->clear();
    nSuf->insertItem("");
    for(int i=0;i<HISTORY_ITEMS;i++){
	group=QString("Exp%1").arg(i);
	tmp=config.readEntry(group,QString::null);
	if(tmp.isEmpty()) break;
	else if(historyItemExist(nSuf,tmp)) continue;
	else nSuf->insertItem(tmp);
    }
    for(int i=0;i<nSuf->count();i++) history[S_H_INDEX+i]=nSuf->text(i);
    nSuf->setCurrentText("");
    config.setGroup("ExtensionHistory");
    rExt->clear();
    rExt->insertItem("");
    for(int i=0;i<HISTORY_ITEMS;i++){
	group=QString("Exp%1").arg(i);
	tmp=config.readEntry(group,QString::null);
	if(tmp.isEmpty()) break;
	else if(historyItemExist(rExt,tmp)) continue;
	else rExt->insertItem(tmp);
    }
    for(int i=1;i<rExt->count();i++) history[E_H_INDEX+i]=rExt->text(i);
    rExt->setCurrentText("");
}
//================================
void Rename::writeHistory()
{
/*    rName->removeItem(0);
    nPref->removeItem(0);
    nSuf->removeItem(0);
    rExt->removeItem(0);*/
    QString cur;
    QString group;
    int index=0;
    KConfig config("gwenrenamerc");
    for(int j=0;j<4;j++){
	switch(j){
	case 0:
	    if(rName->isEnabled()) cur=rName->currentText();
	    else cur=QString::null;
	    group="NameHistory";
	    index=0;
	    break;
	case 1:
	    if(nPref->isEnabled()) cur=nPref->currentText();
		 else cur=QString::null;
	    group="PrefixHistory";
	    index=HISTORY_ITEMS;
	    break;
	case 2:
	    if(nSuf->isEnabled()) cur=nSuf->currentText();
		 else cur=QString::null;
	    group="SuffixHistory";
	    index=2*HISTORY_ITEMS;
	    break;
	case 3:
	    if(rExt->isEnabled()) cur=rExt->currentText();
	    else cur=QString::null;
	    group="ExtensionHistory";
	    index=3*HISTORY_ITEMS;
	    break;
	}
	if(!cur.isEmpty()){
		int i;
	    int found=-1;
	    for(int i=0;i<HISTORY_ITEMS;i++){
		if(cur==history[index+i]){
		    found=i;
		    break;
		}
	    }
	    if(found!=0){
		if(found==-1) for(i=HISTORY_ITEMS-2;i>=1;i--) history[index+i+1]=history[index+i];
		else for(i=found-1;i>=1;i--) history[index+i+1]=history[index+i];
	    }
	    history[index]=cur;
	    config.setGroup(group);
	    for(int i=0;i<HISTORY_ITEMS;i++){
		QString n;
		n=QString("Exp%1").arg(i);
		if(!history[index+i].isEmpty()) config.writeEntry(n,history[index+i]);
		else break;
	    }
	}
    }
/*    rName->insertItem("",0);
    nPref->insertItem("",0);
    nSuf->insertItem("",0);
    rExt->insertItem("",0);*/
}
/////////////////////////////////////////////////////////////
//
//
//	End of History
//
//
/////////////////////////////////////////////////////////////
//================================
int Rename::getSameNewName()
{
    for(int i=0;i<g.numOfFiles-1;i++){
    	if(g.ren[g.getSorted(i)].selected){
		if(g.ren[g.getSorted(i)].newFileName==f.files[0].dirPath() + "/" || g.ren[g.getSorted(i)].newFileName==f.files[0].dirPath() + "/." + g.ren[g.getSorted(i)].newExtension) return i;
		for(int j=0;j<g.numOfFiles;j++) if(g.ren[g.getSorted(i)].newFileName==g.ren[g.getSorted(j)].newFileName && j!=i) return i;
	}
    }
    return -1;
}
//================================
bool Rename::findSelected( QString name )
{
  QString nName;
	for(int i=0;i<g.numOfFiles;i++){
	if(g.ren[g.getSorted(i)].selected){
				if(g.ren[g.getSorted(i)].newExtension.isEmpty()) nName=g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter + g.ren[g.getSorted(i)].Suffix;
				else nName=g.ren[g.getSorted(i)].newName + g.ren[g.getSorted(i)].Counter + g.ren[g.getSorted(i)].Suffix + "." + g.ren[g.getSorted(i)].newExtension;
				if(name==nName) return TRUE;
			}
	}
	return FALSE;
}
//================================
QString Rename::increaseQString( QString tmp )
{
	int length=tmp.length();
	bool ok=FALSE;
	int val=tmp.toInt(&ok);
	val++;
	QString ret=QString::number(val);
	while((int)ret.length()<length) ret.prepend("0");
	return ret;
}
//================================
void Rename::sortToggled( bool state )
{
  if(g.setSortValue(state)==-1) exitError();
  updateView();
}
//================================
void Rename::loadIcons()
{
    QStringList picture("16x16/apps/gwenrename.png");
    if(ic.loadIcon(picture,0)==-1) exitError();
    picture=QStringList("16x16/apps/gwenrename-gray.png");
    if(ic.loadIcon(picture,1)==-1) exitError();
    picture=QStringList("16x16/apps/kalarm.png");
    if(ic.loadIcon(picture,2)==-1) exitError();
    picture=QStringList("16x16/filesystems/folder_home.png");
    picture+="16x16/actions/go_home.png";
    if(ic.loadIcon(picture,3)==-1) exitError();
    picture=QStringList("16x16/actions/filenew.png");
    if(ic.loadIcon(picture,4)==-1) exitError();
    picture=QStringList("16x16/actions/pencil.png");
    picture+="16x16/actions/color_line.png";
    if(ic.loadIcon(picture,5)==-1) exitError();
    picture=QStringList("16x16/actions/button_ok.png");
    picture+="16x16/actions/apply.png";
    if(ic.loadIcon(picture,6)==-1) exitError();
    picture=QStringList("16x16/actions/button_cancel.png");
    picture+="16x16/actions/remove.png";
   if( ic.loadIcon(picture,7)==-1) exitError();
    picture=QStringList("16x16/actions/redo.png");
    if(ic.loadIcon(picture,8)==-1) exitError();
    picture=QStringList("48x48/apps/gwenrename.png");
   if( ic.loadIcon(picture,9)==-1) exitError();
}
//================================
void Rename::renameError( int index, int mode )
{
	QString msg;
	if(index==-1 && mode==0) KMessageBox::error(0,i18n("Renaming process error\n\nNo files have been renamed"),0);
	else{
		QString line;
		QFile restore(f.files[0].dirPath()+"/gwenrename.restore");
		restore.remove();
		restore.open(IO_WriteOnly);
		QTextStream ts( &restore );
		if(mode==0){
			ts << "# gwenrename restore script" << endl;
			ts << "# restore filenames with '. ./gwenrename.restore'" << endl;
			for(int i=0;i<index;i++){
				if(g.ren[g.getSorted(i)].selected){
				line=QString("mv \"%1\" \"%2\"\n").arg(g.ren[g.getSorted(i)].newTmpFileName).arg(g.ren[g.getSorted(i)].oldFileName);
				ts << line;
				}
			}
			ts << "rm gwenrename.restore" << endl;
		}else{
			for(int i=0;i<index;i++){
				if(g.ren[g.getSorted(i)].selected){
					line=QString("mv \"%1\" \"%2\"\n").arg(g.ren[g.getSorted(i)].newFileName).arg(g.ren[g.getSorted(i)].newTmpFileName);
					ts << line;
				}
			}
			for(int i=0;i<g.numOfFiles;i++){
				if(g.ren[g.getSorted(i)].selected){
				line=QString("mv \"%1\" \"%2\"\n").arg(g.ren[g.getSorted(i)].newTmpFileName).arg(g.ren[g.getSorted(i)].oldFileName);
				ts << line;
				}
			}
			ts << "rm gwenrename.restore" << endl;
		}
		restore.close();
		msg=QString(i18n("Error renaming file \"%1\"\n\nA restore script named \"gwenrename.restore\" has been written in the working directory")).arg(g.ren[g.getSorted(index)].oldFileName);
		KMessageBox::error(0,msg,0);
	}
	close(TRUE);
}
//================================
bool Rename::historyItemExist( KComboBox *com, QString s )
{
for(int i=0;i<com->count();i++) if(com->text(i)==s) return TRUE;
return FALSE;
}
//================================
void Rename::exitError()
{
        KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
	close(TRUE);
}
