/* 

This file creates the window for add new download and its callback


*/


#include <gnome.h>
#include <glade/glade.h>
#include <config.h>
#include "nuevo_window.h"
#include "main_window.h"
#include "main_window_cb.h"
#include "gwget_data.h"
#include "utils.h"


/* xml of the new download window */
GladeXML *xml_new = NULL;


	

void on_boton_ok_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *window=NULL;
	GtkEntry *url_entry=NULL,*save_in_entry=NULL;
	gchar *url=NULL,*save_in=NULL;
	GwgetData *gwgetdata;
	gint response;
	
	
	window = glade_xml_get_widget(xml_new,"nuevo_window");
	url_entry = GTK_ENTRY(glade_xml_get_widget(xml_new,"url_entry"));
	save_in_entry=GTK_ENTRY(glade_xml_get_widget(xml_new,"save_in_entry"));
	
	
	url= g_strdup (gtk_entry_get_text(GTK_ENTRY(url_entry)));
	save_in=g_strdup(gtk_entry_get_text(GTK_ENTRY(save_in_entry)));
	
	if (!strcmp(save_in,"") && gwget2_pref.download_dir) {
		save_in=g_strdup(gwget2_pref.download_dir);
	}
	
	if (!strcmp(save_in,"") && !gwget2_pref.download_dir) {
		    save_in=g_strdup(getenv("HOME"));
	}
		
	
	gwgetdata = gwget_data_create(url,save_in);
	/* if the url it's not a file drop a dialog to recurse into the url */
	if (!strcmp(gwgetdata->filename,"") || !strcmp(gwgetdata->filename,gwgetdata->url)) {
		printf("Not a file!\n");
		response=run_dialog(_("Recurse into the Url ?"),_("The url it's not a file. \n Do you like to recurse into the url ?\nOtherwise only the index file will be downloaded."));
		if (response == GTK_RESPONSE_OK) {
			gwgetdata->recursive=TRUE;
		}
	}	

	gtk_widget_hide(window);
	downloads = g_list_append(downloads,gwgetdata);
	gwget_data_set_state(gwgetdata,DL_NOT_CONNECTED);
	new_download(gwgetdata);
	gwget_data_start_download(gwgetdata);
	g_free(save_in);
}

void on_boton_cancelar_clicked(GtkWidget *widget,gpointer data) 
{
	GtkWidget *window = NULL;
	
	window = glade_xml_get_widget(xml_new,"nuevo_window");
	
	gtk_widget_hide(window);
}
	

void create_nuevo_window(void)
{
	gchar *xml_file = NULL;
	GtkWidget *window = NULL;
	GtkEntry *entry = NULL;
	
	if (!xml_new) {
		xml_file =g_build_filename(PACKAGE_DATA_DIR,"nuevo.glade",NULL);
		xml_new = glade_xml_new(xml_file,NULL,NULL);
		glade_xml_signal_autoconnect(xml_new);
	}
	
	window = glade_xml_get_widget(xml_new,"nuevo_window");
	entry = GTK_ENTRY(glade_xml_get_widget(xml_new,"url_entry"));
	gtk_entry_set_text(GTK_ENTRY(entry),"");
	entry = GTK_ENTRY(glade_xml_get_widget(xml_new,"save_in_entry"));
	if (!gwget2_pref.download_dir) 
	{
		gtk_entry_set_text(GTK_ENTRY(entry),g_get_home_dir());
	}
	else 
	{
		gtk_entry_set_text(GTK_ENTRY(entry),gwget2_pref.download_dir);
	}
	gtk_widget_show(window);
}

void
on_new_browse_save_in_button_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *fs=NULL;
	
	fs=glade_xml_get_widget(xml_new,"new_fileselection1");
	gtk_widget_set_sensitive (GTK_WIDGET(GTK_FILE_SELECTION(fs)->file_list),FALSE);
	gtk_widget_show(fs);
	
}

void
on_new_fs_cancel_button_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *fs=NULL;
	
	fs=glade_xml_get_widget(xml_new,"new_fileselection1");
	gtk_widget_hide(fs);
}


void
on_new_fs_ok_button_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *fs=NULL,*save_in_entry=NULL;
	
	fs=glade_xml_get_widget(xml_new,"new_fileselection1");
	
	save_in_entry = glade_xml_get_widget(xml_new,"save_in_entry");
	
	gtk_entry_set_text(GTK_ENTRY(save_in_entry),gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
		
	gtk_widget_hide(fs);
}


