
class Operation:
  enabled = None
  function = None
  return_value = True
  first_only = False
  stream = None
  search = False
  icon = None
  transient = False
  dynamic = False
  account_tree = False
  path = "/gwibber/%(protocol)s/%(accountid)s/%(stream)s/"

  @classmethod
  def check(self, account):
    return (self.__name__ in features(account) and \
      ((account["%s_enabled" % self.enabled]) if self.enabled else True))

class send(Operation):
  description = "send message"
  enabled = "send"
  stream = "messages"

class retweet(Operation):
  description = "retweet"
  return_value = False

class delete(Operation):
  description = "delete message"
  return_value = False

class like(Operation):
  description = "like message"
  return_value = False

class send_thread(Operation):
  description = "send threaded response"
  enabled = "send"
  return_value = False

class reply(Operation):
  description = "send reply"
  #enabled = "send"
  function = "send"
  return_value = False
  first_only = True

class thread(Operation):
  description = "retrieve thread"
  path = "/gwibber/%(stream)s/%(query)s/%(protocol)s/%(accountid)s/"
  icon = "mail-reply-all"
  enabled = "receive"
  transient = True
  stream = "thread"
 
class responses(Operation):
  description = "retrieve responses"
  enabled = "receive"
  stream = "replies"
  icon = "mail-reply-all"
  account_tree = True

class private(Operation):
  description = "retrieve private messages"
  enabled = "receive"
  stream = "private"
  icon = "mail-inbox"
  account_tree = True

class favorites(Operation):
  description = "retrieve favorites"
  enabled = "receive"
  stream = "favorites"
  icon = "favorites"
  account_tree = True
  dynamic = True

class public(Operation):
  description = "retrieve public messages"
  enabled = "receive"
  stream = "public"
  icon = "public"
  account_tree = True
  dynamic = True

class receive(Operation):
  description = "retrieve messages"
  enabled = "receive"
  stream = "messages"
  icon = "messages"
  account_tree = True

class search(Operation):
  description = "perform search query"
  path = "/gwibber/%(stream)s/%(query)s/%(protocol)s/%(accountid)s/"
  enabled = "search"
  stream = "search"
  search = True
  transient = True

class search_url(search):
  description = "perform URL search query"

class tag(Operation):
  description = "perform tag query"

  @classmethod
  def act(self, client, query):
    return client.tag(query.lower().replace("#", ""))

class user_messages(Operation):
  description = "get user messages"
  path = "/gwibber/%(protocol)s/%(accountid)s/%(stream)s/%(query)s/"
  enabled = "receive"
  transient = True
  stream = "user"
  icon = "face-monkey"

  #@classmethod
  #def check(self, account, aid):
  #  return Operation.check(account) and account.id == aid

class group(Operation):
  description = "perform group query"
  enabled = "receive"

  @classmethod
  def act(self, client, query):
    return client.group(query.lower().replace("!", ""))

