#!/usr/bin/env python
#
# setup.py for gnuConcept

from distutils.core import setup
from DistUtilsExtra.command import *
from glob import glob

setup(name="gwibber",
      version="2.0.0",
      author="Ryan Paul",
      author_email="segphault@arstechnica.com",
      url="http://launchpad.net/gwibber/",
      license="GNU General Public License (GPL)",
      packages=['gwibber', 'gwibber.microblog',
          'gwibber.microblog.support', 'gwibber.urlshorter'],
      data_files=[
    ('share/gwibber/ui', glob("ui/*.glade")),
    ('share/gwibber/ui', glob("ui/*.png")),
    ('share/gwibber/ui/templates', glob("ui/templates/*.mako")),
    ('share/gwibber/ui/themes/compact', glob("ui/themes/compact/*")),
    ('share/gwibber/ui/themes/gwilouche', glob("ui/themes/gwilouche/*")),
    ('share/gwibber/ui/themes/default', glob("ui/themes/default/*")),
    ('share/gwibber/ui', ['ui/progress.gif']),
    ('share/gwibber/ui', ['ui/gwibber.svg']),
    ('share/gwibber/ui', ['ui/map.html']),
    ('share/pixmaps', ['ui/gwibber.svg']),
    ('share/applications', ['gwibber.desktop']),
    ('share/dbus-1/services', ['com.Gwibber.service']),
    ('share/dbus-1/services', ['com.GwibberClient.service']),
    ('share/gwibber/ui/icons', glob("ui/icons/*.png")),
    ('share/gwibber/ui/icons', glob("ui/icons/*.svg")),
    ('share/gwibber/ui/icons/16x16', glob("ui/icons/16x16/*.png")),
    ('share/gwibber/ui/icons/16x16', glob("ui/icons/16x16/*.svg")),
    ('share/gwibber/ui/icons/22x22', glob("ui/icons/22x22/*.png")),
    ('share/gwibber/ui/icons/22x22', glob("ui/icons/22x22/*.svg")),
    ('share/gwibber/ui/icons/32x32', glob("ui/icons/32x32/*.png")),
    ('share/gwibber/ui/icons/32x32', glob("ui/icons/32x32/*.svg")),
    ('share/gwibber/ui/cons/scalable', glob("ui/icons/scalable/*.png")),
    ('share/gwibber/ui/icons/scalable', glob("ui/icons/scalable/*.svg")),
    ('/usr/share/indicators/messages/applications', ['indicator/gwibber']),
    ],
      scripts=['bin/gwibber', 'bin/gwibber-daemon'],
      cmdclass = { "build" :  build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons
                 }
)
