;; @(#) $Id: gwyddion-devel.iss.in 6728 2006-10-02 19:10:27Z yeti-dn $
;; vim: set ff=dos :
[Setup]
AppName=Gwyddion Development
AppVersion=2.9
AppVerName=Gwyddion Development 2.9
AppPublisherURL=http://gwyddion.net/
AppCopyright=Copyright (C) 2003-2006 David Necas (Yeti), Petr Klapetek
DefaultDirName=C:\Dev-C++
DefaultGroupName=Gwyddion
DisableStartupPrompt=yes
WindowShowCaption=yes
WindowVisible=no
LicenseFile=COPYING.wri
Compression=bzip/9
SourceDir=.
; this means inst too
OutputDir=.
OutputBaseFilename=Gwyddion-Development-2.9

[Files]
Source: "lib\*.*"; DestDir: "{app}\lib"
Source: "include\libgwyddion\*.*"; DestDir: "{app}\include\libgwyddion"
Source: "include\libprocess\*.*"; DestDir: "{app}\include\libprocess"
Source: "include\libdraw\*.*"; DestDir: "{app}\include\libdraw"
Source: "include\libgwydgets\*.*"; DestDir: "{app}\include\libgwydgets"
Source: "include\libgwymodule\*.*"; DestDir: "{app}\include\libgwymodule"
Source: "include\app\*.*"; DestDir: "{app}\include\app"
Source: "devel-docs\libgwyapp\*.*"; DestDir: "{app}\devel-docs\libgwyapp"
Source: "devel-docs\libgwyddion\*.*"; DestDir: "{app}\devel-docs\libgwyddion"
Source: "devel-docs\libgwydgets\*.*"; DestDir: "{app}\devel-docs\libgwydgets"
Source: "devel-docs\libgwydraw\*.*"; DestDir: "{app}\devel-docs\libgwydraw"
Source: "devel-docs\libgwymodule\*.*"; DestDir: "{app}\devel-docs\libgwymodule"
Source: "devel-docs\libgwyprocess\*.*"; DestDir: "{app}\devel-docs\libgwyprocess"
Source: "COPYING.wri"; DestDir: "{app}"

[Icons]
Name: "{group}\API reference of libgwyapp"; Filename: "{app}\devel-docs\libgwyapp\index.html"
Name: "{group}\API reference of libgwyddion"; Filename: "{app}\devel-docs\libgwyddion\index.html"
Name: "{group}\API reference of libgwydgets"; Filename: "{app}\devel-docs\libgwydgets\index.html"
Name: "{group}\API reference of libgwydraw"; Filename: "{app}\devel-docs\libgwydraw\index.html"
Name: "{group}\API reference of libgwymodule"; Filename: "{app}\devel-docs\libgwymodule\index.html"
Name: "{group}\API reference of libgwyprocess"; Filename: "{app}\devel-docs\libgwyprocess\index.html"
Name: "{group}\Uninstall Gwyddion-Development"; Filename: "{uninstallexe}"

[Registry]
Root: HKLM; Subkey: "Software\Gwyddion Development"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Gwyddion Development\1.0"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\Gwyddion Development\1.0"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Gwyddion Development\1.0"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Gwyddion Development\1.0"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey


[Code]
var
  Exists: Boolean;
  GtkPath: String;

function GetGtkInstalled (): Boolean;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;
   Result := Exists
end;

function GetGtkPath (S: String): String;
begin
    Result := GtkPath;
end;

function InitializeSetup(): Boolean;
begin
  Result := GetGtkInstalled ();
  if not Result then begin
    MsgBox ('Please install the GTK+ 2.8 (or newer) Development Environment before installing Gwyddion.  The preferred Gtk+ package is GladeWin32: http://gladewin32.sourceforge.net/.', mbError, MB_OK);
  end;
end;

