/*
 * Copyright (C) 2001-2005 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: key_events.h,v 1.8 2005/10/13 23:58:53 dsalt Exp $
 *
 * key event handler, keymap editor
 */

#ifndef HAVE_KEY_EVENTS_H
#define HAVE_KEY_EVENTS_H

#include <gtk/gtk.h>

struct kb_xine_event_id_s
{
  char name[16];
  int number;
};
typedef struct kb_xine_event_id_s kb_xine_event_id_t;

struct kb_xine_event_map_s {
  char prefix[8];
  const kb_xine_event_id_t id[];
};
typedef struct kb_xine_event_map_s kb_xine_event_map_t;

gboolean keypress_cb (GtkWidget *, GdkEventKey *, gpointer);
gboolean buttonpress_cb (GtkWidget *, GdkEventButton *, gpointer);
gboolean buttonrelease_cb (GtkWidget *, GdkEventButton *, gpointer);

void kb_edit_show (void) ;

void key_events_init (void) ;

void save_key_bindings (void) ;

/* returns xine event number (XINE_EVENT_*) or 0 on failure */
int kb_xine_event_lookup (const kb_xine_event_map_t *, const char *);

JSBool js_event_generic (JSContext *, JSObject *, uintN argc, jsval *argv,
			 jsval *rval, const char *func, const char *mrlprefix,
			 ...);

#endif
