-- Copyright 2004-2022 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

SELECT
    NULL IS UNKNOWN, FALSE IS UNKNOWN, TRUE IS UNKNOWN,
    NULL IS FALSE, FALSE IS FALSE, TRUE IS FALSE,
    NULL IS TRUE, FALSE IS TRUE, TRUE IS TRUE;
> TRUE FALSE FALSE FALSE TRUE FALSE FALSE FALSE TRUE
> ---- ----- ----- ----- ---- ----- ----- ----- ----
> TRUE FALSE FALSE FALSE TRUE FALSE FALSE FALSE TRUE
> rows: 1

SELECT
    NULL IS NOT UNKNOWN, FALSE IS NOT UNKNOWN, TRUE IS NOT UNKNOWN,
    NULL IS NOT FALSE, FALSE IS NOT FALSE, TRUE IS NOT FALSE,
    NULL IS NOT TRUE, FALSE IS NOT TRUE, TRUE IS NOT TRUE;
> FALSE TRUE TRUE TRUE FALSE TRUE TRUE TRUE FALSE
> ----- ---- ---- ---- ----- ---- ---- ---- -----
> FALSE TRUE TRUE TRUE FALSE TRUE TRUE TRUE FALSE
> rows: 1

CREATE TABLE TEST(B BOOLEAN, N INT) AS VALUES (NULL, NULL), (FALSE, 0), (TRUE, 1);
> ok

CREATE INDEX TEST_B_IDX ON TEST(B);
> ok

CREATE INDEX TEST_N_IDX ON TEST(N);
> ok

SELECT B, B IS UNKNOWN, N IS UNKNOWN, B IS FALSE, N IS FALSE, B IS TRUE, N IS TRUE FROM TEST;
> B     B IS UNKNOWN N IS UNKNOWN B IS FALSE N IS FALSE B IS TRUE N IS TRUE
> ----- ------------ ------------ ---------- ---------- --------- ---------
> FALSE FALSE        FALSE        TRUE       TRUE       FALSE     FALSE
> TRUE  FALSE        FALSE        FALSE      FALSE      TRUE      TRUE
> null  TRUE         TRUE         FALSE      FALSE      FALSE     FALSE
> rows: 3

SELECT B, B IS NOT UNKNOWN, N IS NOT UNKNOWN, B IS NOT FALSE, N IS NOT FALSE, B IS NOT TRUE, N IS NOT TRUE FROM TEST;
> B     B IS NOT UNKNOWN N IS NOT UNKNOWN B IS NOT FALSE N IS NOT FALSE B IS NOT TRUE N IS NOT TRUE
> ----- ---------------- ---------------- -------------- -------------- ------------- -------------
> FALSE TRUE             TRUE             FALSE          FALSE          TRUE          TRUE
> TRUE  TRUE             TRUE             TRUE           TRUE           FALSE         FALSE
> null  FALSE            FALSE            TRUE           TRUE           TRUE          TRUE
> rows: 3

SELECT B, NOT B IS NOT UNKNOWN, NOT N IS NOT UNKNOWN, NOT B IS NOT FALSE, NOT N IS NOT FALSE,
    NOT B IS NOT TRUE, NOT N IS NOT TRUE FROM TEST;
> B     B IS UNKNOWN N IS UNKNOWN B IS FALSE N IS FALSE B IS TRUE N IS TRUE
> ----- ------------ ------------ ---------- ---------- --------- ---------
> FALSE FALSE        FALSE        TRUE       TRUE       FALSE     FALSE
> TRUE  FALSE        FALSE        FALSE      FALSE      TRUE      TRUE
> null  TRUE         TRUE         FALSE      FALSE      FALSE     FALSE
> rows: 3

EXPLAIN SELECT B FROM TEST WHERE B IS UNKNOWN;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX: B IS UNKNOWN */ WHERE "B" IS UNKNOWN

SELECT B FROM TEST WHERE B IS UNKNOWN;
>> null

EXPLAIN SELECT N FROM TEST WHERE N IS UNKNOWN;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS UNKNOWN

EXPLAIN SELECT B FROM TEST WHERE B IS NOT UNKNOWN;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX: B IN(FALSE, TRUE) */ WHERE "B" IS NOT UNKNOWN

SELECT B FROM TEST WHERE B IS NOT UNKNOWN;
> B
> -----
> FALSE
> TRUE
> rows: 2

EXPLAIN SELECT N FROM TEST WHERE N IS NOT UNKNOWN;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS NOT UNKNOWN

EXPLAIN SELECT B FROM TEST WHERE B IS FALSE;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX: B IS FALSE */ WHERE "B" IS FALSE

SELECT B FROM TEST WHERE B IS FALSE;
>> FALSE

EXPLAIN SELECT N FROM TEST WHERE N IS FALSE;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS FALSE

EXPLAIN SELECT B FROM TEST WHERE B IS NOT FALSE;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX */ WHERE "B" IS NOT FALSE

SELECT B FROM TEST WHERE B IS NOT FALSE;
> B
> ----
> TRUE
> null
> rows: 2

EXPLAIN SELECT N FROM TEST WHERE N IS NOT FALSE;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS NOT FALSE

EXPLAIN SELECT B FROM TEST WHERE B IS TRUE;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX: B IS TRUE */ WHERE "B" IS TRUE

SELECT B FROM TEST WHERE B IS TRUE;
>> TRUE

EXPLAIN SELECT N FROM TEST WHERE N IS TRUE;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS TRUE

EXPLAIN SELECT B FROM TEST WHERE B IS NOT TRUE;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX */ WHERE "B" IS NOT TRUE

SELECT B FROM TEST WHERE B IS NOT TRUE;
> B
> -----
> FALSE
> null
> rows: 2

EXPLAIN SELECT N FROM TEST WHERE N IS NOT TRUE;
>> SELECT "N" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_N_IDX */ WHERE "N" IS NOT TRUE

DELETE FROM TEST WHERE B IS NULL;
> update count: 1

ALTER TABLE TEST ALTER COLUMN B SET NOT NULL;
> ok

-- If column is NOT NULL index condition for IS NOT UNKNOWN shouldn't exist
EXPLAIN SELECT B FROM TEST WHERE B IS NOT UNKNOWN;
>> SELECT "B" FROM "PUBLIC"."TEST" /* PUBLIC.TEST_B_IDX */ WHERE "B" IS NOT UNKNOWN

DROP TABLE TEST;
> ok
