{-# OPTIONS -fallow-overlapping-instances #-}
import Control.Monad.State
import HAppS hiding(simpleHTTP)
import HAppS.Protocols.SimpleHTTP
import HAppS.Util.Common
import Text.Html

data MyState = MyState [(Integer,Envelope String)] deriving(Read,Show)

instance StartState MyState where startStateM = return $ MyState []
instance Serialize  MyState where
    typeString _  = "mail.MyState"
    decodeStringM = defaultDecodeStringM
    encodeStringM = defaultEncodeStringM

mh = do ev <- getEvent
        rn <- getRandom
        modify (\(MyState evs) -> MyState ((rn,ev):evs))

hh GET _ []        = redirect "/list"
hh GET _ ["list"]  = list
hh GET _ ["del",k] = del =<< readM k
hh _   _ _         = sresult 404 "Not found."

list = do
    MyState ee <- get
    let w (rn,el) = pre << contents el +++ anchor ! [href ("/del/"++show rn)] << "delete" +++ hr
    let h = header << thetitle << "Messages" +++ h1 << "List of messages" +++ concatHtml (map w ee)
    sresult 200 $ renderHtml h

del k = do
    MyState ee <- get
    put $ MyState $ filter (\x -> k /= fst x) ee
    redirect "/list"

main = stdMain $ simpleHTTP "" [] hh 
             :*: smtpServer mh
             :*: End

