module HAppS.MACID.Logger
    (LogFormat(..), Logger, LogChan,
     newLogChan, addToLog
    ) where

import Control.Concurrent.Chan
import Control.Exception as E(Exception)
import Data.ByteString.Char8(pack)
import System.IO
import System.Locale(defaultTimeLocale)
import System.Time

import HAppS.MACID.Saver
import HAppS.MACID.Types
import HAppS.Util.Concurrent(forkEver)

type Logger req  = TxContext req -> Exception -> IO ()
type LogChan     = Chan String

class LogFormat ty where
    logFormat :: Int -> ty -> String
    logFormat _ _ = "<LoggerFormat: not supported>"

instance LogFormat () where logFormat _ _ = "()"


newLogChan :: SaverImpl -> IO LogChan
newLogChan si = do
  ch <- newChan
  forkEver (readChan ch >>= \s -> saverAdd si [pack s] (return ()))
  return ch

addToLog :: LogFormat req => LogChan -> Logger req
addToLog ch req exc = do
  ct <- toCalendarTime $ TOD (fromIntegral (txTime req)) 0
  writeChan ch $ concat ["================================================================================"
                        ,"\nTransaction: ", show $ txId req
                        ,"\nTx time:     ", show $ txTime req, formatCalendarTime defaultTimeLocale " = %Y-%m-%d %T %Z" ct
                        ,"\nError:       ", show exc
                        ,"\nRequest:\n",    logFormat 5 $ txEvent req
                        ,"\n================================================================================\n"
                        ]
