module HAppS.MACID.Saver.Impl.File(fileSaver) where

import HAppS.MACID.Saver.Types

import Control.Concurrent
import Control.Exception        ( try )
import qualified Data.ByteString.Char8 as P
import qualified Data.ByteString.Lazy.Char8 as L
import System.Directory         ( createDirectory, renameFile )
import System.IO
import System.Random            ( randomIO )
import System.Log.Logger

logMF = logM "HAppS.MACID.Saver.Impl.File"

fileSaver :: FilePath -> String -> IO SaverImpl
fileSaver prefix f0 = do
  logMF NOTICE ("fileSaver: "++f0++" @ "++prefix)
  try $ createDirectory prefix
  hmv <- newMVar =<< openBinaryFile (prefix++"/"++f0) WriteMode
  return $ Saver { saverOpen  = fileSaver prefix
                 , saverClose = withMVar hmv hClose
                 , saverAdd   = \m f -> do logMF NOTICE "fileSaver: saverAdd"
                                           withMVar hmv (\h -> mapM_ (P.hPut h) m >> hFlush h)
                                           forkIO f
                                           return ()
                 , saverGet   = \fp -> do logMF NOTICE "fileSaver: saverGet"
                                          fmap L.toChunks $ L.readFile (prefix++"/"++fp)
                 , saverAtomicReplace = \name ss -> atomicWriteFile (prefix++"/"++name) ss
                 , saverArchive = \name -> do logMF NOTICE $ "fileSaver: archive " ++ name ++ " @ " ++ prefix
                                              try $ createDirectory (prefix++"/archive")
                                              try $ renameFile (prefix++"/"++name)
                                                               (prefix++"/archive/"++name)
                                              return ()
                 }

-- | Just to avoid a dependency.
atomicWriteFile path string = do
  r <- randomIO :: IO Int
  let p' = path ++ ".atomic-tmp-" ++ show (abs r)
  writeFile p' string
  renameFile p' path
