module HAppS.Util.StdMain.Config(ConfHandler(..), OptM, ArgDescr(..), OptDescr(..), runOptM, getOptM, copt) where

import Control.Monad
import HAppS.MACID
import System.Console.GetOpt

-- Configuration
class ConfHandler cf where
    confHandler :: (cf -> Handler st) -> OptM (Handler st)
    confUsage   :: (cf -> Handler st) -> [OptDescr ()]

newtype OptM a = OptM { runOptM :: Options -> Either Errors (a,Options) }
type Errors = [String]
type Options= [String]
instance Monad OptM where
    return x = OptM $ \c -> Right (x,c)
    m >>= f  = OptM $ \c -> case runOptM m c of
                              Left e      -> Left e
                              Right (v,o) -> runOptM (f v) o
    fail s   = OptM $ \_ -> Left [s]
instance Functor OptM where fmap = liftM

getOptM :: [OptDescr a] -> OptM [a]
getOptM ho = OptM $ \c -> case getOpt' Permute ho c of
                            (res, [], extra, []) -> Right (res,extra)
                            (_,   fi, _,     []) -> Left ["Files in getOptM while there should be only options: "++show f | f <- fi]
                            (_,   _,  _,   errs) -> Left ["Error in getOptM: "++err | err <- errs]


copt :: [OptDescr a] -> [OptDescr ()]
copt = map w
    where w (Option a b c d) = Option a b (q c) d
          q (NoArg _)        = NoArg ()
          q (ReqArg _ s)     = ReqArg (const ()) s
          q (OptArg _ s)     = OptArg (const ()) s



