{-# OPTIONS -fth -cpp #-}
module HAppS.Util.StdMain.StartStateTH
    (inferRecordUpdaters, inferStartState, inferStartStateAny, inferToElement
    ) where

import Data.Char(toUpper,toLower)
import HAppS.MACID(Handler(LABEL),localState)
import HAppS.Util.StdMain.StartState
import Language.Haskell.TH
import HAppS.Protocols.MinHaXML

-- | Infer a StartState instance for a record. Note that event types are bound to the field
--   names inside the record.
inferStartState :: Name -> Q [Dec]
inferStartState t = inferStartStateEx t (ConT t)

-- | Infer a StartState instance for a record. Note that event types are bound to the field
--   names inside the record.
inferStartStateAny :: Name -> Q [Dec]
inferStartStateAny typeName = inferStartStateEx typeName . VarT =<< newName "outer"

inferStartStateEx :: Name -> Type -> Q [Dec]
#ifndef __HADDOCK__
inferStartStateEx typeName stv = do
    dec <- nameToDec typeName
    fun <- [d| startStateExM p = ($(createStartStateM typeName)) p
               runPartEx i o   = $(createHandlers typeName) i o
            |]
    return [instanceType ''StartStateEx stv typeName dec fun]

#endif
-- | Infer updating functions for a record @a_foo :: component -> record -> record@ and
--   @withFoo = localState foo a_foo@.
inferRecordUpdaters :: Name -> Q [Dec]
#ifndef __HADDOCK__
inferRecordUpdaters typeName = do
    con <- decToSimpleRecord =<< nameToDec typeName
    let c name upd sel = do let un = mkName ("a_"++ns)
                                wn = mkName ("with"++(toUpper (head ns):tail ns))
                                ns = nameBase name
                            ud <- un `sdef` upd
                            wd <- wn `sdef` (varE 'localState `appE` sel `appE` varE un)
                            return [ud, wd]
    xs <- sequence $ zipWith3 c (fieldNames con) (updFuns con) (selFuns con)
    return $ concat xs


-- | Takes a type name and creates an expression suitable for "startStateExM".
createStartStateM :: Name -> ExpQ
createStartStateM typeName = do
    con <- decToSimpleRecord =<< nameToDec typeName
    let p = head $ vnames "p"
    let (name,vs) = conVars con
    let parts = [ bindS (varP vn) [| startStateExM $(varE p) |] | vn <- vs ]
    let ret   = noBindS (varE 'return `appE` (foldl (\a e -> appE a (varE e)) (conE name) vs))
    lamE [varP p] $ doE (parts ++ [ret])

-- | Takes a type name and cretes 
createHandlers :: Name -> ExpQ
createHandlers typeName = do
    con <- decToSimpleRecord =<< nameToDec typeName
    let vs = map stringE $ map show $ fieldNames con
        i  = mkName "i"
        o  = mkName "o"
    let parts = [ [| map (LABEL $(vn)) $ runPartEx ($(sfun) . $(varE i)) (\u v -> $(varE o) ($(ufun) u ($(varE i) v)) v) |]
                      | (vn,sfun,ufun) <- zip3 vs (selFuns con) (updFuns con) ]
    [varP i, varP o] `lamE` (varE 'concat `appE` listE parts)

#endif
-- | Infer a ToElement instance for a record. Every field will be lowercase and converted to a
--   string with 'Prelude.show'.
inferToElement :: Name -> Q [Dec]
#ifndef __HADDOCK__
inferToElement typeName = do
  dec <- nameToDec typeName
  con <- decToSimpleRecord dec
  let fields = fieldNames con
      name = getname typeName
  fun <- [d| toElement e = listElem $(stringE name) [] . 
                      map (\(n,f) -> listElem n [] [f e] ) $ $(listE . map mkTup $ fields) |]
  mkInst fun
         where
           getname = map toLower . nameBase
           mkTup name = let base = getname name 
                        in [| ($(stringE base) , toElement . $(varE name)) |]
           mkInst f = return $ [InstanceD [] (AppT (ConT ''ToElement) (ConT typeName)) f]

-- Utilities

conVars con = (name,vars)
    where (name, len) = cnorm con
          vars        = take len $ vnames "v"

cnorm (NormalC n l)   = (n,length l)
cnorm (RecC    n l)   = (n,length l)
cnorm (InfixC _ n _)  = (n,2)
cnorm (ForallC _ _ n) = cnorm n

-- | Generate an infinite list of variable names with the given prefix.
vnames :: String -> [Name]
vnames pre = map (\n -> mkName (pre++show n)) [1..]

decToSimpleRecord :: Dec -> Q Con
decToSimpleRecord (DataD _ _ _ [con] _)  = return con
decToSimpleRecord (DataD _ n _ _     _)  =
    fail ("Not a simple record (has multiple constructors): "++show n)
decToSimpleRecord (NewtypeD _ _ _ con _) = return con
decToSimpleRecord x = fail ("Wanted a simple record, got: "++show x)

nameToDec :: Name -> Q Dec
nameToDec ty = reify ty >>= un
    where un (TyConI d) = return $ d
          un _          = fail "nameToDec: expected TyCon"

-- | Create a list of selection functions for a record.
selFuns :: Con -> [ExpQ]
selFuns (RecC _ ts) = [ varE n | (n,_,_) <- ts ]

-- | Create a list of update functions for a record.
updFuns :: Con -> [ExpQ]
updFuns (RecC _ ts) = [ upd n | (n,_,_) <- ts ]
    where [x,y] = map mkName ["x","y"]
          upd f = lamE [varP x, varP y] $ rup f
          rup f = recUpdE (varE y) [return (f,VarE x)]


-- | Return field names
fieldNames (RecC _ ts) = [ n | (n,_,_) <- ts ]

-- | Construct the correct instance definition (AppT folding and Ctx).
instanceType :: Name -> Type -> Name -> Dec -> [Dec] -> Dec
instanceType cn outer ctype (NewtypeD a b c d e) = instanceType cn outer ctype (DataD a b c [d] e)
instanceType cn outer ctype (DataD _ _ exts _ _) =
  let names = length exts `take` vnames "t"
      iraw  = (foldl (\a e -> AppT a (VarT e)) (ConT ctype) names)
      itype = AppT (AppT (ConT cn) outer) iraw
      ictx  = map (\t -> (AppT (ConT cn) outer) `AppT` (VarT t)) names
  in InstanceD ictx itype

-- | Simple definition
sdef vn ve = valD (varP vn) (normalB ve) []

#endif
