/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "support.h"
#include "preferences.h"

extern GtkWidget *window;
extern preferencestype preferences;

/* clean all entries, do not touch any toolbar entries */
void clearall (void)
{
	GtkWidget *nrentry, *descriptionentry, *typeentry, *materialentry,
		*periodentry, *notes, *dateentry, *valueentry, *referenceentry,
		*finddateentry, *locationentry, *coordinatesentry, *spotnotes, 
		*image1entry, *image2entry, *image1, *image2;
	GtkTextBuffer *buffer;
	GtkTextIter start, end;
	GdkPixbuf *pixbuf1, *pixbuf2;

	nrentry = lookup_widget (window, "nrentry");
	descriptionentry = lookup_widget (window, "descriptionentry");
	typeentry = lookup_widget (window, "typeentry");
	materialentry = lookup_widget (window, "materialentry");
	periodentry = lookup_widget (window, "periodentry");
	notes = lookup_widget (window, "notes");
	dateentry = lookup_widget (window, "dateentry");
	valueentry = lookup_widget (window, "valueentry");
	referenceentry = lookup_widget (window, "referenceentry");

	finddateentry = lookup_widget (window, "finddateentry");
	locationentry = lookup_widget (window, "locationentry");
	coordinatesentry = lookup_widget (window, "coordinatesentry");
	spotnotes = lookup_widget (window, "spotnotes");

	image1entry = lookup_widget (window, "image1entry");
	image2entry = lookup_widget (window, "image2entry");
	image1 = lookup_widget (window, "image1");
	image2 = lookup_widget (window, "image2");

	gtk_editable_delete_text (GTK_EDITABLE (nrentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (descriptionentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (typeentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (materialentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (periodentry), 0, -1);
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (notes));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_delete (buffer, &start, &end);
	gtk_editable_delete_text (GTK_EDITABLE (dateentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (valueentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (referenceentry), 0, -1);

	gtk_editable_delete_text (GTK_EDITABLE (finddateentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (locationentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (coordinatesentry), 0, -1);
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (spotnotes));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_delete (buffer, &start, &end);

	gtk_editable_delete_text (GTK_EDITABLE (image1entry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (image2entry), 0, -1);

	pixbuf1 = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 100, 100);
	gdk_pixbuf_fill (pixbuf1, 0x00000000);
	gtk_image_set_from_pixbuf(GTK_IMAGE(image1), pixbuf1);
	g_object_unref (pixbuf1);

	pixbuf2 = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 100, 100);
	gdk_pixbuf_fill (pixbuf2, 0x00000000);
	gtk_image_set_from_pixbuf(GTK_IMAGE(image2), pixbuf2);
	g_object_unref (pixbuf2);
}

/* set popdown strings */
void set_combostrings (void)
{
	GtkWidget *combo;
	gchar **split;
	gint i=0;
	GList *combo_items = NULL;

	combo = lookup_widget (window, "periodcombo");
	split = g_strsplit (preferences.periods, ",", 0);
	while (split[i])
	{
		combo_items = g_list_append (combo_items, split[i]);
		i++;
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
	g_list_free (combo_items);
	g_strfreev (split);

	combo = lookup_widget (window, "materialcombo");
	split = g_strsplit (preferences.materials, ",", 0);
	i = 0;
	combo_items = NULL;
	while (split[i])
	{
		combo_items = g_list_append (combo_items, split[i]);
		i++;
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
	g_list_free (combo_items);
	g_strfreev (split);

	combo = lookup_widget (window, "typecombo");
	split = g_strsplit (preferences.types, ",", 0);
	i = 0;
	combo_items = NULL;
	while (split[i])
	{
		combo_items = g_list_append (combo_items, split[i]);
		i++;
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
	g_list_free (combo_items);
	g_strfreev (split);
}
