/*
 * Hardware Information, version 0.3.2
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 *
 */

#include "details.h"
#include "hardinfo.h"

gboolean
detail_window_close(GtkWidget *widget, gpointer data)
{
	DetailWindow *dw = (DetailWindow *) data;
	
	gtk_widget_destroy(dw->window);
	
	return FALSE;
}

void
detail_window_set_title(DetailWindow *dw, const gchar *title)
{
	if (!dw) return;
	
	gtk_window_set_title(GTK_WINDOW(dw->window), title);
}

void
detail_window_update_names(DetailWindow *dw)
{
	gchar *buf;
	
	if (dw->device_name && strstr(dw->device_name, "&")) {
		gchar *temp, *temp2;
		
		temp = (gchar *) malloc (strlen (dw->device_name) * 2);
		
		temp2 = temp;
		
		while (*(dw->device_name)) {
			if (*(dw->device_name) == '&') {
				*(temp++) = '&';
				*(temp++) = 'a';
				*(temp++) = 'm';
				*(temp++) = 'p';
				*(temp++) = ';';
			} else {
				*(temp++) = *(dw->device_name);
			}
			dw->device_name++;
		}
		
		*(temp++) = 0;
		
		temp = temp2;
		
		g_free(dw->device_name);
		dw->device_name = g_strdup(temp);
		
		g_free(temp);
	}
	
	if (!dw->device_type)
		dw->device_type = "";
	
	buf = g_strdup_printf("<big><b>%s</b></big>\n%s",
			      dw->device_name, dw->device_type);

	gtk_label_set_markup(GTK_LABEL(dw->name_label), buf);
	
	g_free(buf);
}

void 
detail_window_append_separator(DetailWindow *dw)
{
	GtkWidget *sep;
	
	sep = gtk_hseparator_new();
	gtk_widget_show(sep);

	gtk_table_attach_defaults(GTK_TABLE(dw->info_table), sep, 0, 2, dw->last_info,
		                  dw->last_info + 1);
	
	dw->last_info++;	
}

void
detail_window_set_dev_type(DetailWindow *dw, const gchar *type)
{
	dw->device_type = g_strdup(type);
	
	detail_window_update_names(dw);
}

void
detail_window_set_dev_name(DetailWindow *dw, const gchar *name)
{
	dw->device_name = g_strdup(name);
	
	detail_window_update_names(dw);
}

void
detail_window_append_info_int(DetailWindow *dw, const gchar *name, gint val,
			      gboolean hex)
{
	gchar *buf;
	
	buf = g_strdup_printf(hex ? "0x%X" : "%d", val);
	detail_window_append_info(dw, name, buf);
	g_free(buf);
}

void
detail_window_append_info(DetailWindow *dw, const gchar *name, gchar *val)
{
	GtkWidget *label;
	gchar *buf;
	
	if (dw->last_info == 0) 
		dw->last_info = 1;

	buf = g_strdup_printf("<b>%s:</b>", name);
	label = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
	gtk_widget_show(label);
	gtk_table_attach_defaults(GTK_TABLE(dw->info_table), label, 0, 1, dw->last_info,
		                  dw->last_info + 1);
	g_free(buf);

	label = gtk_label_new(val);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_widget_show(label);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_label_set_selectable(GTK_LABEL(label), TRUE);
	gtk_table_attach(GTK_TABLE(dw->info_table), label, 1, 2, dw->last_info,
			 dw->last_info + 1, GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
				  
	dw->last_info++;				  
		
}

static gboolean
notebook_hide_tabs(GtkWidget *widget, gpointer data)
{
	if (gtk_notebook_get_n_pages(GTK_NOTEBOOK(widget)) == 1) {
		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(widget), FALSE);
		gtk_notebook_set_show_border(GTK_NOTEBOOK(widget), FALSE);
	} else {
		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(widget), TRUE);
		gtk_notebook_set_show_border(GTK_NOTEBOOK(widget), TRUE);
	}
	
	return FALSE;
}

void 
detail_window_set_icon(DetailWindow *dw, const gchar *path)
{
	if (!dw || !dw->icon) return;

	gtk_image_set_from_file(GTK_IMAGE(dw->icon), path);
}

DetailWindow *
detail_window_new(void)
{
	DetailWindow *dw;
	GtkWidget *window, *vbox, *btn, *hbbox, *notebook, *table,
		  *label, *info_table;
	GtkWidget *icon, *vb, *hb;
	
	dw = g_new0(DetailWindow, 1);
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 5);
	gtk_window_set_title(GTK_WINDOW(window), "Hardware Details");
	gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_UTILITY);
	gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
	gtk_widget_realize(window);
	
	dw->window = window;
		
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	
	dw->vbox = vbox;

	notebook = gtk_notebook_new();
	gtk_widget_show(notebook);
	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook), FALSE);
	dw->notebook = notebook;

	g_signal_connect(G_OBJECT(notebook), "expose-event",
			 G_CALLBACK(notebook_hide_tabs), notebook);

	table = gtk_table_new(1, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 8);
	gtk_table_set_row_spacings(GTK_TABLE(table), 4);
	gtk_table_set_col_spacings(GTK_TABLE(table), 16);
	gtk_widget_show(table);
		
	label = gtk_label_new(_("Information"));
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, 
				 label);

	hb = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hb);
	gtk_table_attach_defaults(GTK_TABLE(table), hb, 0, 1, 0, 1);

	icon = gtk_image_new();
	gtk_misc_set_alignment(GTK_MISC(icon), 0.5, 0.0);
	gtk_widget_show(icon);
	dw->icon = icon;

	gtk_table_attach_defaults(GTK_TABLE(table), icon, 0, 1, 0, 1);

	vb = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb);
	gtk_box_pack_start(GTK_BOX(hb), vb, TRUE, TRUE, 0);

	label = gtk_label_new(_("No device selected."));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1,
			 GTK_FILL | GTK_EXPAND, 0, 0, 0);
	dw->name_label = label;	
	
	info_table = gtk_table_new(0, 0, FALSE);
	gtk_widget_show(info_table);
	gtk_table_attach(GTK_TABLE(table), info_table, 1, 2, 2, 3,
			 GTK_EXPAND | GTK_FILL, 0, 0, 0);
	gtk_table_set_col_spacings(GTK_TABLE(info_table), 4);
	gtk_table_set_row_spacings(GTK_TABLE(info_table), 2);
	dw->info_table = info_table;
	
	hbbox = gtk_hbutton_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(hbbox), 4);
	gtk_widget_show(hbbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbbox, FALSE, FALSE, 0);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbbox), 6);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbbox), GTK_BUTTONBOX_END);

	btn = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
	g_signal_connect(G_OBJECT(btn), "clicked", G_CALLBACK(detail_window_close), dw);
	gtk_widget_show(btn);
	gtk_box_pack_end(GTK_BOX(hbbox), btn, FALSE, FALSE, 0);

	detail_window_set_icon(dw, IMG_PREFIX "logo.png");

	return dw;
}

void
detail_window_show(GtkWidget *widget, gpointer data)
{
	MainWindow *mainwindow = (MainWindow *) data;
	GenericDevice *dev;
	
	mainwindow->det_window = detail_window_new();

	dev = (GenericDevice *) gtk_ctree_node_get_row_data
	    (GTK_CTREE(mainwindow->ctree), GTK_CLIST(mainwindow->ctree)->
	     selection->data);

	hi_show_device_info_real(mainwindow, dev);

	gtk_window_set_modal(GTK_WINDOW(mainwindow->det_window->window), TRUE);	
	gtk_window_set_position(GTK_WINDOW(mainwindow->det_window->window), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_transient_for(GTK_WINDOW(mainwindow->det_window->window),
				     GTK_WINDOW(mainwindow->window));
	gtk_widget_show(mainwindow->det_window->window);
}
