/*
 * Hardware Information, version 0.3
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 * SCSI support by Pascal F.Martin <pascalmartin@earthlink.net>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 */

#include "hardinfo.h"
#include "scsi.h"

SCSIDevice *hi_scan_scsi(void)
{
	FILE *proc_scsi;
	gchar buffer[256], *buf;
	gint n=0;
	SCSIDevice *scsi_dev = NULL, *scsi;
	struct stat st;
	
	scsi = NULL;
	
	if(stat("/proc/scsi/scsi", &st)) return NULL;

	proc_scsi = fopen("/proc/scsi/scsi", "r");
	while(fgets(buffer, 256, proc_scsi)) {
		buf = g_strstrip(buffer);
		if(!strncmp(buf, "Host: scsi", 10)) {
			gint scsi_controller;
			gint scsi_channel;
			gint scsi_id;
			gint scsi_lun;

			sscanf(buf,
				"Host: scsi%d Channel: %d Id: %d Lun: %d",
				&scsi_controller,
				&scsi_channel,
				&scsi_id,
				&scsi_lun);

			buf = strstr (buffer, "Rev: ");
			if (buf == NULL) {
				buf = "(unknown)";
			} else {
				buf += 5;
			}
			scsi_dev = g_new0(SCSIDevice, 1);
			
			scsi_dev->next = scsi;
			scsi = scsi_dev;
			
			scsi_dev->controller = scsi_controller;
			scsi_dev->channel = scsi_channel;
			scsi_dev->id = scsi_id;
			scsi_dev->lun = scsi_lun;

			n++;			

		} else if (!strncmp(buf, "Vendor: ", 8)) {

			char *p;
			char *model = strstr (buf, "Model: ");
			char *rev = strstr (buf, "Rev: ");

			if (model == NULL) {
				model = buf + strlen(buf);
			}
			p = model;
			while (*(--p) == ' ') ;
			*(++p) = 0;
			scsi_dev->vendor = g_strdup(buf+8);

			if (rev != NULL) {
				scsi_dev->revision = g_strdup(rev+5);
			} else {
				rev = model + strlen(model);
			}
			p = rev;
			while (*(--p) == ' ') ;
			*(++p) = 0;
			scsi_dev->model =
				g_strdup_printf
					("%s %s", scsi_dev->vendor, model+7);

		} else if (!strncmp(buf, "Type:   ", 8)) {
			char *p = strstr (buf, "ANSI SCSI revi");

			if (p != NULL) {
				while (*(--p) == ' ') ;
				*(++p) = 0;
				scsi_dev->type = g_strdup(buf+8);
			}
		}
	}
	fclose(proc_scsi);
	
	return scsi;
}

void hi_show_scsi_info(MainWindow *mainwindow, SCSIDevice *device)
{
        static struct {
                char *type;
                char *label;
                char *icon; 
        } type2icon[] = {   
                {"Direct-Access",       "Disk",         "hdd.png"},
                {"Sequential-Access",   "Tape",         "tape.png"},
                {"Printer",             "Printer",      "lpr.png"}, 
                {"WORM",                "CD-ROM",       "cd.png"},  
                {"CD-ROM",              "CD-ROM",       "cd.png"},  
                {"Scanner",             "Scanner",      "scan.png"},
                {NULL,                  "Generic",      "scsi.png"} 
        };

        int i;
        gchar *buf;

        if(!device) return;

        for (i = 0; type2icon[i].type != NULL; ++i) {
                if (!strcmp(device->type, type2icon[i].type)) break;
        }

        buf = g_strdup_printf("%s%s", IMG_PREFIX, type2icon[i].icon);
	detail_window_set_icon(mainwindow->det_window, buf);        
        g_free(buf);

        buf = g_strdup_printf(_("SCSI %s Device"), type2icon[i].label);
        gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), buf);        
	detail_window_set_dev_type(mainwindow->det_window, buf);
        g_free(buf);

	detail_window_set_dev_name(mainwindow->det_window, device->model);


	detail_window_append_info(mainwindow->det_window, _("Revision"), device->revision);
	detail_window_append_info(mainwindow->det_window, _("Type"), device->type);

	detail_window_append_separator(mainwindow->det_window);

	detail_window_append_info_int(mainwindow->det_window, _("Controller"), device->controller, FALSE);
	detail_window_append_info_int(mainwindow->det_window, _("Channel"), device->channel, FALSE);
	detail_window_append_info_int(mainwindow->det_window, _("ID"), device->id, FALSE);
	detail_window_append_info_int(mainwindow->det_window, _("LUN"), device->lun, FALSE);
}
