/*
 * Based on GAIM's stock.c
 * Copyright (C) 2002-2003, Christian Hammond <chipx86@gnupdate.org>
 *
 * Also distributed under GNU GPL version 2.
 */ 
 
#include <gtk/gtk.h>
#include "stock.h"
#include "hardinfo.h"
#include "config.h"

static struct StockIcon {
	const char *name;
	const char *filename;
} const stock_icons[] = {
	{ HI_ABOUT,   "stock-about-16.png" },
	{ HI_DETAILS, "stock-details.png"  }
};

const GtkStockItem stock_items[] = {
	{ HI_ABOUT,   "About...",	0, 0, NULL },
	{ HI_DETAILS, "_Details...",	0, 0, NULL }
};

static gint stock_icon_count = sizeof stock_icons / sizeof(*stock_icons);
static gint stock_item_count = sizeof stock_items / sizeof(*stock_items);
static gboolean stock_inited = FALSE;

void hi_stock_init(void)
{
	GtkIconFactory *ift;
	int i;
	GtkWidget *win;
	
	if (stock_inited) return;
	
	ift = gtk_icon_factory_new();
	gtk_icon_factory_add_default(ift);
	
	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(win);
	
	for (i = 0; i < stock_icon_count; i++) {
		GdkPixbuf *pixbuf;
		GtkIconSet *iconset;
		gchar *filename;
		
		filename = g_strdup_printf("%s/%s", IMG_PREFIX, stock_icons[i].filename);		
		pixbuf = gdk_pixbuf_new_from_file(filename, NULL);
		g_free(filename);
		
		iconset = gtk_icon_set_new_from_pixbuf(pixbuf);		 
		gtk_icon_factory_add(ift, stock_icons[i].name, iconset);
		gtk_icon_set_unref(iconset);
	}
	
	gtk_widget_destroy(win);	
	g_object_unref(G_OBJECT(ift));
	gtk_stock_add_static(stock_items, stock_item_count);
	
	stock_inited = TRUE;
}

