module Sound.MIDI.Message.Class.Utility where

import Sound.MIDI.Message.Channel.Voice (Pitch, Velocity, )

import qualified Sound.MIDI.Message.Channel.Voice as VoiceMsg


explicitNoteOff ::
   (Velocity, Pitch, Bool) -> (Velocity, Pitch, Bool)
explicitNoteOff x@(v,p,b) =
   if b && v == VoiceMsg.toVelocity 0
     then (VoiceMsg.toVelocity 64, p, False)
     else x

implicitNoteOff ::
   (Velocity, Pitch, Bool) -> (Velocity, Pitch, Bool)
implicitNoteOff x@(v,p,b) =
   if not b && v == VoiceMsg.toVelocity 64
     then (VoiceMsg.toVelocity 0, p, True)
     else x
