module Hat.Data.Word (Word(),Word8(),Word16(),Word32(),Word64()) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Data.WordBuiltin 
import Hat.PreludeBuiltinTypes 
import qualified Data.Word 
import Ix 
import Hat.Ix 
import Hat.Ratio 

geqWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Bool))

geqWord peqWord p = T.ufun2 aeqWord peqWord p heqWord

heqWord z1eqWord z2eqWord keqWord =
  fromBool keqWord
    ((toWord keqWord z1eqWord) Prelude.== (toWord keqWord z2eqWord))

instance Eq (Word)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) = T.uconstDef T.mkRoot (+>$=>@=>$=#!>==) (\ p -> geqWord T.mkNoSrcPos p)
  

geqWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Bool))

geqWord8 peqWord8 p = T.ufun2 aeqWord8 peqWord8 p heqWord8

heqWord8 z1eqWord8 z2eqWord8 keqWord8 =
  fromBool keqWord8
    ((toWord8 keqWord8 z1eqWord8) Prelude.== (toWord8 keqWord8 z2eqWord8))

instance Eq (Word8)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) =
    T.uconstDef T.mkRoot (+>%=#!$=>%=##&==) (\ p -> geqWord8 T.mkNoSrcPos p)
  

geqWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Bool))

geqWord16 peqWord16 p = T.ufun2 aeqWord16 peqWord16 p heqWord16

heqWord16 z1eqWord16 z2eqWord16 keqWord16 =
  fromBool keqWord16
    ((toWord16 keqWord16 z1eqWord16) Prelude.== (toWord16 keqWord16 z2eqWord16))

instance Eq (Word16)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) =
    T.uconstDef T.mkRoot (+>&=#!+=>&=##>==) (\ p -> geqWord16 T.mkNoSrcPos p)
  

geqWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Bool))

geqWord32 peqWord32 p = T.ufun2 aeqWord32 peqWord32 p heqWord32

heqWord32 z1eqWord32 z2eqWord32 keqWord32 =
  fromBool keqWord32
    ((toWord32 keqWord32 z1eqWord32) Prelude.== (toWord32 keqWord32 z2eqWord32))

instance Eq (Word32)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) =
    T.uconstDef T.mkRoot (+>*=#!+=>*=##>==) (\ p -> geqWord32 T.mkNoSrcPos p)
  

geqWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Bool))

geqWord64 peqWord64 p = T.ufun2 aeqWord64 peqWord64 p heqWord64

heqWord64 z1eqWord64 z2eqWord64 keqWord64 =
  fromBool keqWord64
    ((toWord64 keqWord64 z1eqWord64) Prelude.== (toWord64 keqWord64 z2eqWord64))

instance Eq (Word64)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) =
    T.uconstDef T.mkRoot (+>+=#!+=>+=##>==) (\ p -> geqWord64 T.mkNoSrcPos p)
  

gleWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Bool))

gleWord pleWord p = T.ufun2 aleWord pleWord p hleWord

hleWord z1leWord z2leWord kleWord =
  fromBool kleWord
    ((toWord kleWord z1leWord) Prelude.<= (toWord kleWord z2leWord))

instance Ord (Word)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) = T.uconstDef T.mkRoot (+>@=>>=>@=##!<=) (\ p -> gleWord T.mkNoSrcPos p)
  

gleWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Bool))

gleWord8 pleWord8 p = T.ufun2 aleWord8 pleWord8 p hleWord8

hleWord8 z1leWord8 z2leWord8 kleWord8 =
  fromBool kleWord8
    ((toWord8 kleWord8 z1leWord8) Prelude.<= (toWord8 kleWord8 z2leWord8))

instance Ord (Word8)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (+>>=#!%=>>=##*<=) (\ p -> gleWord8 T.mkNoSrcPos p)
  

gleWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Bool))

gleWord16 pleWord16 p = T.ufun2 aleWord16 pleWord16 p hleWord16

hleWord16 z1leWord16 z2leWord16 kleWord16 =
  fromBool kleWord16
    ((toWord16 kleWord16 z1leWord16) Prelude.<= (toWord16 kleWord16 z2leWord16))

instance Ord (Word16)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (+#!!=#!^=#!!=#$!<=) (\ p -> gleWord16 T.mkNoSrcPos p)
  

gleWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Bool))

gleWord32 pleWord32 p = T.ufun2 aleWord32 pleWord32 p hleWord32

hleWord32 z1leWord32 z2leWord32 kleWord32 =
  fromBool kleWord32
    ((toWord32 kleWord32 z1leWord32) Prelude.<= (toWord32 kleWord32 z2leWord32))

instance Ord (Word32)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (+#!#=#!^=#!#=#$!<=) (\ p -> gleWord32 T.mkNoSrcPos p)
  

gleWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Bool))

gleWord64 pleWord64 p = T.ufun2 aleWord64 pleWord64 p hleWord64

hleWord64 z1leWord64 z2leWord64 kleWord64 =
  fromBool kleWord64
    ((toWord64 kleWord64 z1leWord64) Prelude.<= (toWord64 kleWord64 z2leWord64))

instance Ord (Word64)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (+#!$=#!^=#!$=#$!<=) (\ p -> gleWord64 T.mkNoSrcPos p)
  

gaddWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Word))

gaddWord paddWord p = T.ufun2 aaddWord paddWord p haddWord

haddWord z1addWord z2addWord kaddWord =
  fromWord kaddWord
    ((toWord kaddWord z1addWord) Prelude.+ (toWord kaddWord z2addWord))

gsubWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Word))

gsubWord psubWord p = T.ufun2 asubWord psubWord p hsubWord

hsubWord z1subWord z2subWord ksubWord =
  fromWord ksubWord
    ((toWord ksubWord z1subWord) Prelude.- (toWord ksubWord z2subWord))

gmulWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Word))

gmulWord pmulWord p = T.ufun2 amulWord pmulWord p hmulWord

hmulWord z1mulWord z2mulWord kmulWord =
  fromWord kmulWord
    ((toWord kmulWord z1mulWord) Prelude.* (toWord kmulWord z2mulWord))

gabsWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word Word)

gabsWord pabsWord p = T.ufun1 aabsWord pabsWord p habsWord

habsWord z1absWord kabsWord =
  fromWord kabsWord (Prelude.abs (toWord kabsWord z1absWord))

gnegateWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word Word)

gnegateWord pnegateWord p = T.ufun1 anegateWord pnegateWord p hnegateWord

hnegateWord z1negateWord knegateWord =
  fromWord knegateWord (Prelude.negate (toWord knegateWord z1negateWord))

gsignumWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word Word)

gsignumWord psignumWord p = T.ufun1 asignumWord psignumWord p hsignumWord

hsignumWord z1signumWord ksignumWord =
  fromWord ksignumWord (Prelude.signum (toWord ksignumWord z1signumWord))

gfromIntegerWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Word)

gfromIntegerWord pfromIntegerWord p =
  T.ufun1 afromIntegerWord pfromIntegerWord p hfromIntegerWord

hfromIntegerWord z1fromIntegerWord kfromIntegerWord =
  fromWord kfromIntegerWord
    (Prelude.fromInteger (T.toInteger kfromIntegerWord z1fromIntegerWord))

instance Num (Word)
  where
  
  (!+) (%+) p = T.uconstUse (%+) p (|+)
  
  (|+) =
    T.uconstDef T.mkRoot (+#!&=*%$=#!&=*&%+) (\ p -> gaddWord T.mkNoSrcPos p)
  
  (!-) (%-) p = T.uconstUse (%-) p (|-)
  
  (|-) =
    T.uconstDef T.mkRoot (+#!&=*&@=#!&=**>-) (\ p -> gsubWord T.mkNoSrcPos p)
  
  (!*) (%*) p = T.uconstUse (%*) p (|*)
  
  (|*) =
    T.uconstDef T.mkRoot (+#!&=*+&=#!&=*^**) (\ p -> gmulWord T.mkNoSrcPos p)
  
  gabs pabs p = T.uconstUse pabs p sabs
  
  sabs =
    T.uconstDef T.mkRoot a104v579v104v591abs (\ p -> gabsWord T.mkNoSrcPos p)
  
  gnegate pnegate p = T.uconstUse pnegate p snegate
  
  snegate =
    T.uconstDef T.mkRoot a104v595v104v613negate
      (\ p -> gnegateWord T.mkNoSrcPos p)
  
  gsignum psignum p = T.uconstUse psignum p ssignum
  
  ssignum =
    T.uconstDef T.mkRoot a104v619v104v637signum
      (\ p -> gsignumWord T.mkNoSrcPos p)
  
  gfromInteger pfromInteger p = T.uconstUse pfromInteger p sfromInteger
  
  sfromInteger =
    T.uconstDef T.mkRoot a104v643v104v671fromInteger
      (\ p -> gfromIntegerWord T.mkNoSrcPos p)
  

gaddWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Word8))

gaddWord8 paddWord8 p = T.ufun2 aaddWord8 paddWord8 p haddWord8

haddWord8 z1addWord8 z2addWord8 kaddWord8 =
  fromWord8 kaddWord8
    ((toWord8 kaddWord8 z1addWord8) Prelude.+ (toWord8 kaddWord8 z2addWord8))

gsubWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Word8))

gsubWord8 psubWord8 p = T.ufun2 asubWord8 psubWord8 p hsubWord8

hsubWord8 z1subWord8 z2subWord8 ksubWord8 =
  fromWord8 ksubWord8
    ((toWord8 ksubWord8 z1subWord8) Prelude.- (toWord8 ksubWord8 z2subWord8))

gmulWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Word8))

gmulWord8 pmulWord8 p = T.ufun2 amulWord8 pmulWord8 p hmulWord8

hmulWord8 z1mulWord8 z2mulWord8 kmulWord8 =
  fromWord8 kmulWord8
    ((toWord8 kmulWord8 z1mulWord8) Prelude.* (toWord8 kmulWord8 z2mulWord8))

gabsWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 Word8)

gabsWord8 pabsWord8 p = T.ufun1 aabsWord8 pabsWord8 p habsWord8

habsWord8 z1absWord8 kabsWord8 =
  fromWord8 kabsWord8 (Prelude.abs (toWord8 kabsWord8 z1absWord8))

gnegateWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 Word8)

gnegateWord8 pnegateWord8 p = T.ufun1 anegateWord8 pnegateWord8 p hnegateWord8

hnegateWord8 z1negateWord8 knegateWord8 =
  fromWord8 knegateWord8 (Prelude.negate (toWord8 knegateWord8 z1negateWord8))

gsignumWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 Word8)

gsignumWord8 psignumWord8 p = T.ufun1 asignumWord8 psignumWord8 p hsignumWord8

hsignumWord8 z1signumWord8 ksignumWord8 =
  fromWord8 ksignumWord8 (Prelude.signum (toWord8 ksignumWord8 z1signumWord8))

gfromIntegerWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Word8)

gfromIntegerWord8 pfromIntegerWord8 p =
  T.ufun1 afromIntegerWord8 pfromIntegerWord8 p hfromIntegerWord8

hfromIntegerWord8 z1fromIntegerWord8 kfromIntegerWord8 =
  fromWord8 kfromIntegerWord8
    (Prelude.fromInteger (T.toInteger kfromIntegerWord8 z1fromIntegerWord8))

instance Num (Word8)
  where
  
  (!+) (%+) p = T.uconstUse (%+) p (|+)
  
  (|+) =
    T.uconstDef T.mkRoot (+#!*=**+=#!*=*+@+) (\ p -> gaddWord8 T.mkNoSrcPos p)
  
  (!-) (%-) p = T.uconstUse (%-) p (|-)
  
  (|-) =
    T.uconstDef T.mkRoot (+#!*=*@!=#!*=*>$-) (\ p -> gsubWord8 T.mkNoSrcPos p)
  
  (!*) (%*) p = T.uconstUse (%*) p (|*)
  
  (|*) =
    T.uconstDef T.mkRoot (+#!*=+!&=#!*=+#+*) (\ p -> gmulWord8 T.mkNoSrcPos p)
  
  gabs pabs p = T.uconstUse pabs p sabs
  
  sabs =
    T.uconstDef T.mkRoot a105v627v105v640abs (\ p -> gabsWord8 T.mkNoSrcPos p)
  
  gnegate pnegate p = T.uconstUse pnegate p snegate
  
  snegate =
    T.uconstDef T.mkRoot a105v651v105v670negate
      (\ p -> gnegateWord8 T.mkNoSrcPos p)
  
  gsignum psignum p = T.uconstUse psignum p ssignum
  
  ssignum =
    T.uconstDef T.mkRoot a105v675v105v694signum
      (\ p -> gsignumWord8 T.mkNoSrcPos p)
  
  gfromInteger pfromInteger p = T.uconstUse pfromInteger p sfromInteger
  
  sfromInteger =
    T.uconstDef T.mkRoot a105v699v105v728fromInteger
      (\ p -> gfromIntegerWord8 T.mkNoSrcPos p)
  

gaddWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Word16))

gaddWord16 paddWord16 p = T.ufun2 aaddWord16 paddWord16 p haddWord16

haddWord16 z1addWord16 z2addWord16 kaddWord16 =
  fromWord16 kaddWord16
    ((toWord16 kaddWord16 z1addWord16)
      Prelude.+
      (toWord16 kaddWord16 z2addWord16))

gsubWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Word16))

gsubWord16 psubWord16 p = T.ufun2 asubWord16 psubWord16 p hsubWord16

hsubWord16 z1subWord16 z2subWord16 ksubWord16 =
  fromWord16 ksubWord16
    ((toWord16 ksubWord16 z1subWord16)
      Prelude.-
      (toWord16 ksubWord16 z2subWord16))

gmulWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Word16))

gmulWord16 pmulWord16 p = T.ufun2 amulWord16 pmulWord16 p hmulWord16

hmulWord16 z1mulWord16 z2mulWord16 kmulWord16 =
  fromWord16 kmulWord16
    ((toWord16 kmulWord16 z1mulWord16)
      Prelude.*
      (toWord16 kmulWord16 z2mulWord16))

gabsWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 Word16)

gabsWord16 pabsWord16 p = T.ufun1 aabsWord16 pabsWord16 p habsWord16

habsWord16 z1absWord16 kabsWord16 =
  fromWord16 kabsWord16 (Prelude.abs (toWord16 kabsWord16 z1absWord16))

gnegateWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 Word16)

gnegateWord16 pnegateWord16 p =
  T.ufun1 anegateWord16 pnegateWord16 p hnegateWord16

hnegateWord16 z1negateWord16 knegateWord16 =
  fromWord16 knegateWord16
    (Prelude.negate (toWord16 knegateWord16 z1negateWord16))

gsignumWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 Word16)

gsignumWord16 psignumWord16 p =
  T.ufun1 asignumWord16 psignumWord16 p hsignumWord16

hsignumWord16 z1signumWord16 ksignumWord16 =
  fromWord16 ksignumWord16
    (Prelude.signum (toWord16 ksignumWord16 z1signumWord16))

gfromIntegerWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Word16)

gfromIntegerWord16 pfromIntegerWord16 p =
  T.ufun1 afromIntegerWord16 pfromIntegerWord16 p hfromIntegerWord16

hfromIntegerWord16 z1fromIntegerWord16 kfromIntegerWord16 =
  fromWord16 kfromIntegerWord16
    (Prelude.fromInteger (T.toInteger kfromIntegerWord16 z1fromIntegerWord16))

instance Num (Word16)
  where
  
  (!+) (%+) p = T.uconstUse (%+) p (|+)
  
  (|+) =
    T.uconstDef T.mkRoot (+#!+=*@!=#!+=*>%+) (\ p -> gaddWord16 T.mkNoSrcPos p)
  
  (!-) (%-) p = T.uconstUse (%-) p (|-)
  
  (|-) =
    T.uconstDef T.mkRoot (+#!+=+!&=#!+=+#^-) (\ p -> gsubWord16 T.mkNoSrcPos p)
  
  (!*) (%*) p = T.uconstUse (%*) p (|*)
  
  (|*) =
    T.uconstDef T.mkRoot (+#!+=+$@=#!+=+&#*) (\ p -> gmulWord16 T.mkNoSrcPos p)
  
  gabs pabs p = T.uconstUse pabs p sabs
  
  sabs =
    T.uconstDef T.mkRoot a106v651v106v665abs (\ p -> gabsWord16 T.mkNoSrcPos p)
  
  gnegate pnegate p = T.uconstUse pnegate p snegate
  
  snegate =
    T.uconstDef T.mkRoot a106v675v106v695negate
      (\ p -> gnegateWord16 T.mkNoSrcPos p)
  
  gsignum psignum p = T.uconstUse psignum p ssignum
  
  ssignum =
    T.uconstDef T.mkRoot a106v699v106v719signum
      (\ p -> gsignumWord16 T.mkNoSrcPos p)
  
  gfromInteger pfromInteger p = T.uconstUse pfromInteger p sfromInteger
  
  sfromInteger =
    T.uconstDef T.mkRoot a106v723v106v753fromInteger
      (\ p -> gfromIntegerWord16 T.mkNoSrcPos p)
  

gaddWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Word32))

gaddWord32 paddWord32 p = T.ufun2 aaddWord32 paddWord32 p haddWord32

haddWord32 z1addWord32 z2addWord32 kaddWord32 =
  fromWord32 kaddWord32
    ((toWord32 kaddWord32 z1addWord32)
      Prelude.+
      (toWord32 kaddWord32 z2addWord32))

gsubWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Word32))

gsubWord32 psubWord32 p = T.ufun2 asubWord32 psubWord32 p hsubWord32

hsubWord32 z1subWord32 z2subWord32 ksubWord32 =
  fromWord32 ksubWord32
    ((toWord32 ksubWord32 z1subWord32)
      Prelude.-
      (toWord32 ksubWord32 z2subWord32))

gmulWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Word32))

gmulWord32 pmulWord32 p = T.ufun2 amulWord32 pmulWord32 p hmulWord32

hmulWord32 z1mulWord32 z2mulWord32 kmulWord32 =
  fromWord32 kmulWord32
    ((toWord32 kmulWord32 z1mulWord32)
      Prelude.*
      (toWord32 kmulWord32 z2mulWord32))

gabsWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 Word32)

gabsWord32 pabsWord32 p = T.ufun1 aabsWord32 pabsWord32 p habsWord32

habsWord32 z1absWord32 kabsWord32 =
  fromWord32 kabsWord32 (Prelude.abs (toWord32 kabsWord32 z1absWord32))

gnegateWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 Word32)

gnegateWord32 pnegateWord32 p =
  T.ufun1 anegateWord32 pnegateWord32 p hnegateWord32

hnegateWord32 z1negateWord32 knegateWord32 =
  fromWord32 knegateWord32
    (Prelude.negate (toWord32 knegateWord32 z1negateWord32))

gsignumWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 Word32)

gsignumWord32 psignumWord32 p =
  T.ufun1 asignumWord32 psignumWord32 p hsignumWord32

hsignumWord32 z1signumWord32 ksignumWord32 =
  fromWord32 ksignumWord32
    (Prelude.signum (toWord32 ksignumWord32 z1signumWord32))

gfromIntegerWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Word32)

gfromIntegerWord32 pfromIntegerWord32 p =
  T.ufun1 afromIntegerWord32 pfromIntegerWord32 p hfromIntegerWord32

hfromIntegerWord32 z1fromIntegerWord32 kfromIntegerWord32 =
  fromWord32 kfromIntegerWord32
    (Prelude.fromInteger (T.toInteger kfromIntegerWord32 z1fromIntegerWord32))

instance Num (Word32)
  where
  
  (!+) (%+) p = T.uconstUse (%+) p (|+)
  
  (|+) =
    T.uconstDef T.mkRoot (+#!^=*@!=#!^=*>%+) (\ p -> gaddWord32 T.mkNoSrcPos p)
  
  (!-) (%-) p = T.uconstUse (%-) p (|-)
  
  (|-) =
    T.uconstDef T.mkRoot (+#!^=+!&=#!^=+#^-) (\ p -> gsubWord32 T.mkNoSrcPos p)
  
  (!*) (%*) p = T.uconstUse (%*) p (|*)
  
  (|*) =
    T.uconstDef T.mkRoot (+#!^=+$@=#!^=+&#*) (\ p -> gmulWord32 T.mkNoSrcPos p)
  
  gabs pabs p = T.uconstUse pabs p sabs
  
  sabs =
    T.uconstDef T.mkRoot a107v651v107v665abs (\ p -> gabsWord32 T.mkNoSrcPos p)
  
  gnegate pnegate p = T.uconstUse pnegate p snegate
  
  snegate =
    T.uconstDef T.mkRoot a107v675v107v695negate
      (\ p -> gnegateWord32 T.mkNoSrcPos p)
  
  gsignum psignum p = T.uconstUse psignum p ssignum
  
  ssignum =
    T.uconstDef T.mkRoot a107v699v107v719signum
      (\ p -> gsignumWord32 T.mkNoSrcPos p)
  
  gfromInteger pfromInteger p = T.uconstUse pfromInteger p sfromInteger
  
  sfromInteger =
    T.uconstDef T.mkRoot a107v723v107v753fromInteger
      (\ p -> gfromIntegerWord32 T.mkNoSrcPos p)
  

gaddWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Word64))

gaddWord64 paddWord64 p = T.ufun2 aaddWord64 paddWord64 p haddWord64

haddWord64 z1addWord64 z2addWord64 kaddWord64 =
  fromWord64 kaddWord64
    ((toWord64 kaddWord64 z1addWord64)
      Prelude.+
      (toWord64 kaddWord64 z2addWord64))

gsubWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Word64))

gsubWord64 psubWord64 p = T.ufun2 asubWord64 psubWord64 p hsubWord64

hsubWord64 z1subWord64 z2subWord64 ksubWord64 =
  fromWord64 ksubWord64
    ((toWord64 ksubWord64 z1subWord64)
      Prelude.-
      (toWord64 ksubWord64 z2subWord64))

gmulWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Word64))

gmulWord64 pmulWord64 p = T.ufun2 amulWord64 pmulWord64 p hmulWord64

hmulWord64 z1mulWord64 z2mulWord64 kmulWord64 =
  fromWord64 kmulWord64
    ((toWord64 kmulWord64 z1mulWord64)
      Prelude.*
      (toWord64 kmulWord64 z2mulWord64))

gabsWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 Word64)

gabsWord64 pabsWord64 p = T.ufun1 aabsWord64 pabsWord64 p habsWord64

habsWord64 z1absWord64 kabsWord64 =
  fromWord64 kabsWord64 (Prelude.abs (toWord64 kabsWord64 z1absWord64))

gnegateWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 Word64)

gnegateWord64 pnegateWord64 p =
  T.ufun1 anegateWord64 pnegateWord64 p hnegateWord64

hnegateWord64 z1negateWord64 knegateWord64 =
  fromWord64 knegateWord64
    (Prelude.negate (toWord64 knegateWord64 z1negateWord64))

gsignumWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 Word64)

gsignumWord64 psignumWord64 p =
  T.ufun1 asignumWord64 psignumWord64 p hsignumWord64

hsignumWord64 z1signumWord64 ksignumWord64 =
  fromWord64 ksignumWord64
    (Prelude.signum (toWord64 ksignumWord64 z1signumWord64))

gfromIntegerWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Word64)

gfromIntegerWord64 pfromIntegerWord64 p =
  T.ufun1 afromIntegerWord64 pfromIntegerWord64 p hfromIntegerWord64

hfromIntegerWord64 z1fromIntegerWord64 kfromIntegerWord64 =
  fromWord64 kfromIntegerWord64
    (Prelude.fromInteger (T.toInteger kfromIntegerWord64 z1fromIntegerWord64))

instance Num (Word64)
  where
  
  (!+) (%+) p = T.uconstUse (%+) p (|+)
  
  (|+) =
    T.uconstDef T.mkRoot (+#!@=*@!=#!@=*>%+) (\ p -> gaddWord64 T.mkNoSrcPos p)
  
  (!-) (%-) p = T.uconstUse (%-) p (|-)
  
  (|-) =
    T.uconstDef T.mkRoot (+#!@=+!&=#!@=+#^-) (\ p -> gsubWord64 T.mkNoSrcPos p)
  
  (!*) (%*) p = T.uconstUse (%*) p (|*)
  
  (|*) =
    T.uconstDef T.mkRoot (+#!@=+$@=#!@=+&#*) (\ p -> gmulWord64 T.mkNoSrcPos p)
  
  gabs pabs p = T.uconstUse pabs p sabs
  
  sabs =
    T.uconstDef T.mkRoot a108v651v108v665abs (\ p -> gabsWord64 T.mkNoSrcPos p)
  
  gnegate pnegate p = T.uconstUse pnegate p snegate
  
  snegate =
    T.uconstDef T.mkRoot a108v675v108v695negate
      (\ p -> gnegateWord64 T.mkNoSrcPos p)
  
  gsignum psignum p = T.uconstUse psignum p ssignum
  
  ssignum =
    T.uconstDef T.mkRoot a108v699v108v719signum
      (\ p -> gsignumWord64 T.mkNoSrcPos p)
  
  gfromInteger pfromInteger p = T.uconstUse pfromInteger p sfromInteger
  
  sfromInteger =
    T.uconstDef T.mkRoot a108v723v108v753fromInteger
      (\ p -> gfromIntegerWord64 T.mkNoSrcPos p)
  

gminWord :: T.RefSrcPos -> T.RefExp -> T.R Word

gminWord pminWord p = T.uconstUse pminWord p sminWord

sminWord = T.uconstDef T.mkRoot aminWord (\ p -> fromWord p Prelude.minBound)

gmaxWord :: T.RefSrcPos -> T.RefExp -> T.R Word

gmaxWord pmaxWord p = T.uconstUse pmaxWord p smaxWord

smaxWord = T.uconstDef T.mkRoot amaxWord (\ p -> fromWord p Prelude.maxBound)

instance Bounded (Word)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a110v163v110v180minBound
      (\ p -> gminWord T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a110v187v110v204maxBound
      (\ p -> gmaxWord T.mkNoSrcPos p)
  

gminWord8 :: T.RefSrcPos -> T.RefExp -> T.R Word8

gminWord8 pminWord8 p = T.uconstUse pminWord8 p sminWord8

sminWord8 = T.uconstDef T.mkRoot aminWord8 (\ p -> fromWord8 p Prelude.minBound)

gmaxWord8 :: T.RefSrcPos -> T.RefExp -> T.R Word8

gmaxWord8 pmaxWord8 p = T.uconstUse pmaxWord8 p smaxWord8

smaxWord8 = T.uconstDef T.mkRoot amaxWord8 (\ p -> fromWord8 p Prelude.maxBound)

instance Bounded (Word8)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a111v163v111v181minBound
      (\ p -> gminWord8 T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a111v187v111v205maxBound
      (\ p -> gmaxWord8 T.mkNoSrcPos p)
  

gminWord16 :: T.RefSrcPos -> T.RefExp -> T.R Word16

gminWord16 pminWord16 p = T.uconstUse pminWord16 p sminWord16

sminWord16 =
  T.uconstDef T.mkRoot aminWord16 (\ p -> fromWord16 p Prelude.minBound)

gmaxWord16 :: T.RefSrcPos -> T.RefExp -> T.R Word16

gmaxWord16 pmaxWord16 p = T.uconstUse pmaxWord16 p smaxWord16

smaxWord16 =
  T.uconstDef T.mkRoot amaxWord16 (\ p -> fromWord16 p Prelude.maxBound)

instance Bounded (Word16)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a112v163v112v182minBound
      (\ p -> gminWord16 T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a112v187v112v206maxBound
      (\ p -> gmaxWord16 T.mkNoSrcPos p)
  

gminWord32 :: T.RefSrcPos -> T.RefExp -> T.R Word32

gminWord32 pminWord32 p = T.uconstUse pminWord32 p sminWord32

sminWord32 =
  T.uconstDef T.mkRoot aminWord32 (\ p -> fromWord32 p Prelude.minBound)

gmaxWord32 :: T.RefSrcPos -> T.RefExp -> T.R Word32

gmaxWord32 pmaxWord32 p = T.uconstUse pmaxWord32 p smaxWord32

smaxWord32 =
  T.uconstDef T.mkRoot amaxWord32 (\ p -> fromWord32 p Prelude.maxBound)

instance Bounded (Word32)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a113v163v113v182minBound
      (\ p -> gminWord32 T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a113v187v113v206maxBound
      (\ p -> gmaxWord32 T.mkNoSrcPos p)
  

gminWord64 :: T.RefSrcPos -> T.RefExp -> T.R Word64

gminWord64 pminWord64 p = T.uconstUse pminWord64 p sminWord64

sminWord64 =
  T.uconstDef T.mkRoot aminWord64 (\ p -> fromWord64 p Prelude.minBound)

gmaxWord64 :: T.RefSrcPos -> T.RefExp -> T.R Word64

gmaxWord64 pmaxWord64 p = T.uconstUse pmaxWord64 p smaxWord64

smaxWord64 =
  T.uconstDef T.mkRoot amaxWord64 (\ p -> fromWord64 p Prelude.maxBound)

instance Bounded (Word64)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a114v163v114v182minBound
      (\ p -> gminWord64 T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a114v187v114v206maxBound
      (\ p -> gmaxWord64 T.mkNoSrcPos p)
  

instance Real (Word)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a116v35v116v64toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uwrapForward p
        (((T.uwrapForward p (htoIntWord fx p))
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Real (Word8)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a117v35v117v65toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uwrapForward p
        (((T.uwrapForward p (htoIntWord8 fx p))
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Real (Word16)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a118v35v118v66toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uwrapForward p
        (((T.uwrapForward p (htoIntWord16 fx p))
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Real (Word32)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a119v35v119v66toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uwrapForward p
        (((T.uwrapForward p (htoIntWord32 fx p))
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Real (Word64)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a120v35v120v66toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uwrapForward p
        (((T.uwrapForward p (htoIntWord64 fx p))
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

gquotWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Word))

gquotWord pquotWord p = T.ufun2 aquotWord pquotWord p hquotWord

hquotWord z1quotWord z2quotWord kquotWord =
  fromWord kquotWord
    (Prelude.quot (toWord kquotWord z1quotWord) (toWord kquotWord z2quotWord))

gremWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word Word))

gremWord premWord p = T.ufun2 aremWord premWord p hremWord

hremWord z1remWord z2remWord kremWord =
  fromWord kremWord
    (Prelude.rem (toWord kremWord z1remWord) (toWord kremWord z2remWord))

gtoIntWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word Hat.Prelude.Integer)

gtoIntWord ptoIntWord p = T.ufun1 atoIntWord ptoIntWord p htoIntWord

htoIntWord z1toIntWord ktoIntWord =
  T.fromInteger ktoIntWord (Prelude.toInteger (toWord ktoIntWord z1toIntWord))

instance Integral (Word)
  where
  
  gquot pquot p = T.uconstUse pquot p squot
  
  squot =
    T.uconstDef T.mkRoot a122v275v122v289quot (\ p -> gquotWord T.mkNoSrcPos p)
  
  grem prem p = T.uconstUse prem p srem
  
  srem =
    T.uconstDef T.mkRoot a122v299v122v312rem (\ p -> gremWord T.mkNoSrcPos p)
  
  gtoInteger ptoInteger p = T.uconstUse ptoInteger p stoInteger
  
  stoInteger =
    T.uconstDef T.mkRoot a122v323v122v343toInteger
      (\ p -> gtoIntWord T.mkNoSrcPos p)
  

gquotWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Word8))

gquotWord8 pquotWord8 p = T.ufun2 aquotWord8 pquotWord8 p hquotWord8

hquotWord8 z1quotWord8 z2quotWord8 kquotWord8 =
  fromWord8 kquotWord8
    (Prelude.quot (toWord8 kquotWord8 z1quotWord8)
      (toWord8 kquotWord8 z2quotWord8))

gremWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 Word8))

gremWord8 premWord8 p = T.ufun2 aremWord8 premWord8 p hremWord8

hremWord8 z1remWord8 z2remWord8 kremWord8 =
  fromWord8 kremWord8
    (Prelude.rem (toWord8 kremWord8 z1remWord8) (toWord8 kremWord8 z2remWord8))

gtoIntWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 Hat.Prelude.Integer)

gtoIntWord8 ptoIntWord8 p = T.ufun1 atoIntWord8 ptoIntWord8 p htoIntWord8

htoIntWord8 z1toIntWord8 ktoIntWord8 =
  T.fromInteger ktoIntWord8
    (Prelude.toInteger (toWord8 ktoIntWord8 z1toIntWord8))

instance Integral (Word8)
  where
  
  gquot pquot p = T.uconstUse pquot p squot
  
  squot =
    T.uconstDef T.mkRoot a123v283v123v298quot (\ p -> gquotWord8 T.mkNoSrcPos p)
  
  grem prem p = T.uconstUse prem p srem
  
  srem =
    T.uconstDef T.mkRoot a123v307v123v321rem (\ p -> gremWord8 T.mkNoSrcPos p)
  
  gtoInteger ptoInteger p = T.uconstUse ptoInteger p stoInteger
  
  stoInteger =
    T.uconstDef T.mkRoot a123v331v123v352toInteger
      (\ p -> gtoIntWord8 T.mkNoSrcPos p)
  

gquotWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Word16))

gquotWord16 pquotWord16 p = T.ufun2 aquotWord16 pquotWord16 p hquotWord16

hquotWord16 z1quotWord16 z2quotWord16 kquotWord16 =
  fromWord16 kquotWord16
    (Prelude.quot (toWord16 kquotWord16 z1quotWord16)
      (toWord16 kquotWord16 z2quotWord16))

gremWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 Word16))

gremWord16 premWord16 p = T.ufun2 aremWord16 premWord16 p hremWord16

hremWord16 z1remWord16 z2remWord16 kremWord16 =
  fromWord16 kremWord16
    (Prelude.rem (toWord16 kremWord16 z1remWord16)
      (toWord16 kremWord16 z2remWord16))

gtoIntWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 Hat.Prelude.Integer)

gtoIntWord16 ptoIntWord16 p = T.ufun1 atoIntWord16 ptoIntWord16 p htoIntWord16

htoIntWord16 z1toIntWord16 ktoIntWord16 =
  T.fromInteger ktoIntWord16
    (Prelude.toInteger (toWord16 ktoIntWord16 z1toIntWord16))

instance Integral (Word16)
  where
  
  gquot pquot p = T.uconstUse pquot p squot
  
  squot =
    T.uconstDef T.mkRoot a124v299v124v315quot
      (\ p -> gquotWord16 T.mkNoSrcPos p)
  
  grem prem p = T.uconstUse prem p srem
  
  srem =
    T.uconstDef T.mkRoot a124v323v124v338rem (\ p -> gremWord16 T.mkNoSrcPos p)
  
  gtoInteger ptoInteger p = T.uconstUse ptoInteger p stoInteger
  
  stoInteger =
    T.uconstDef T.mkRoot a124v347v124v369toInteger
      (\ p -> gtoIntWord16 T.mkNoSrcPos p)
  

gquotWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Word32))

gquotWord32 pquotWord32 p = T.ufun2 aquotWord32 pquotWord32 p hquotWord32

hquotWord32 z1quotWord32 z2quotWord32 kquotWord32 =
  fromWord32 kquotWord32
    (Prelude.quot (toWord32 kquotWord32 z1quotWord32)
      (toWord32 kquotWord32 z2quotWord32))

gremWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 Word32))

gremWord32 premWord32 p = T.ufun2 aremWord32 premWord32 p hremWord32

hremWord32 z1remWord32 z2remWord32 kremWord32 =
  fromWord32 kremWord32
    (Prelude.rem (toWord32 kremWord32 z1remWord32)
      (toWord32 kremWord32 z2remWord32))

gtoIntWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 Hat.Prelude.Integer)

gtoIntWord32 ptoIntWord32 p = T.ufun1 atoIntWord32 ptoIntWord32 p htoIntWord32

htoIntWord32 z1toIntWord32 ktoIntWord32 =
  T.fromInteger ktoIntWord32
    (Prelude.toInteger (toWord32 ktoIntWord32 z1toIntWord32))

instance Integral (Word32)
  where
  
  gquot pquot p = T.uconstUse pquot p squot
  
  squot =
    T.uconstDef T.mkRoot a125v299v125v315quot
      (\ p -> gquotWord32 T.mkNoSrcPos p)
  
  grem prem p = T.uconstUse prem p srem
  
  srem =
    T.uconstDef T.mkRoot a125v323v125v338rem (\ p -> gremWord32 T.mkNoSrcPos p)
  
  gtoInteger ptoInteger p = T.uconstUse ptoInteger p stoInteger
  
  stoInteger =
    T.uconstDef T.mkRoot a125v347v125v369toInteger
      (\ p -> gtoIntWord32 T.mkNoSrcPos p)
  

gquotWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Word64))

gquotWord64 pquotWord64 p = T.ufun2 aquotWord64 pquotWord64 p hquotWord64

hquotWord64 z1quotWord64 z2quotWord64 kquotWord64 =
  fromWord64 kquotWord64
    (Prelude.quot (toWord64 kquotWord64 z1quotWord64)
      (toWord64 kquotWord64 z2quotWord64))

gremWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 Word64))

gremWord64 premWord64 p = T.ufun2 aremWord64 premWord64 p hremWord64

hremWord64 z1remWord64 z2remWord64 kremWord64 =
  fromWord64 kremWord64
    (Prelude.rem (toWord64 kremWord64 z1remWord64)
      (toWord64 kremWord64 z2remWord64))

gtoIntWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 Hat.Prelude.Integer)

gtoIntWord64 ptoIntWord64 p = T.ufun1 atoIntWord64 ptoIntWord64 p htoIntWord64

htoIntWord64 z1toIntWord64 ktoIntWord64 =
  T.fromInteger ktoIntWord64
    (Prelude.toInteger (toWord64 ktoIntWord64 z1toIntWord64))

instance Integral (Word64)
  where
  
  gquot pquot p = T.uconstUse pquot p squot
  
  squot =
    T.uconstDef T.mkRoot a126v299v126v315quot
      (\ p -> gquotWord64 T.mkNoSrcPos p)
  
  grem prem p = T.uconstUse prem p srem
  
  srem =
    T.uconstDef T.mkRoot a126v323v126v338rem (\ p -> gremWord64 T.mkNoSrcPos p)
  
  gtoInteger ptoInteger p = T.uconstUse ptoInteger p stoInteger
  
  stoInteger =
    T.uconstDef T.mkRoot a126v347v126v369toInteger
      (\ p -> gtoIntWord64 T.mkNoSrcPos p)
  

gtoEnumWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Word)

gtoEnumWord ptoEnumWord p = T.ufun1 atoEnumWord ptoEnumWord p htoEnumWord

htoEnumWord z1toEnumWord ktoEnumWord =
  fromWord ktoEnumWord (Prelude.toEnum (T.toInt ktoEnumWord z1toEnumWord))

gfromEnumWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word Int)

gfromEnumWord pfromEnumWord p =
  T.ufun1 afromEnumWord pfromEnumWord p hfromEnumWord

hfromEnumWord z1fromEnumWord kfromEnumWord =
  T.fromInt kfromEnumWord
    (Prelude.fromEnum (toWord kfromEnumWord z1fromEnumWord))

genumFromWord :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.List Word))

genumFromWord penumFromWord p =
  T.ufun1 aenumFromWord penumFromWord p henumFromWord

henumFromWord z1enumFromWord kenumFromWord =
  (fromList fromWord) kenumFromWord
    (Prelude.enumFrom (toWord kenumFromWord z1enumFromWord))

genumFromThenWord ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word (T.Fun Word (T.List Word)))

genumFromThenWord penumFromThenWord p =
  T.ufun2 aenumFromThenWord penumFromThenWord p henumFromThenWord

henumFromThenWord z1enumFromThenWord z2enumFromThenWord kenumFromThenWord =
  (fromList fromWord) kenumFromThenWord
    (Prelude.enumFromThen (toWord kenumFromThenWord z1enumFromThenWord)
      (toWord kenumFromThenWord z2enumFromThenWord))

instance Enum (Word)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a136v348v136v366toEnum
      (\ p -> gtoEnumWord T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a136v372v136v394fromEnum
      (\ p -> gfromEnumWord T.mkNoSrcPos p)
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a136v404v136v426enumFrom
      (\ p -> genumFromWord T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a136v436v136v466enumFromThen
      (\ p -> genumFromThenWord T.mkNoSrcPos p)
  

gtoEnumWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Word8)

gtoEnumWord8 ptoEnumWord8 p = T.ufun1 atoEnumWord8 ptoEnumWord8 p htoEnumWord8

htoEnumWord8 z1toEnumWord8 ktoEnumWord8 =
  fromWord8 ktoEnumWord8 (Prelude.toEnum (T.toInt ktoEnumWord8 z1toEnumWord8))

gfromEnumWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 Int)

gfromEnumWord8 pfromEnumWord8 p =
  T.ufun1 afromEnumWord8 pfromEnumWord8 p hfromEnumWord8

hfromEnumWord8 z1fromEnumWord8 kfromEnumWord8 =
  T.fromInt kfromEnumWord8
    (Prelude.fromEnum (toWord8 kfromEnumWord8 z1fromEnumWord8))

genumFromWord8 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.List Word8))

genumFromWord8 penumFromWord8 p =
  T.ufun1 aenumFromWord8 penumFromWord8 p henumFromWord8

henumFromWord8 z1enumFromWord8 kenumFromWord8 =
  (fromList fromWord8) kenumFromWord8
    (Prelude.enumFrom (toWord8 kenumFromWord8 z1enumFromWord8))

genumFromThenWord8 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word8 (T.Fun Word8 (T.List Word8)))

genumFromThenWord8 penumFromThenWord8 p =
  T.ufun2 aenumFromThenWord8 penumFromThenWord8 p henumFromThenWord8

henumFromThenWord8 z1enumFromThenWord8 z2enumFromThenWord8 kenumFromThenWord8 =
  (fromList fromWord8) kenumFromThenWord8
    (Prelude.enumFromThen (toWord8 kenumFromThenWord8 z1enumFromThenWord8)
      (toWord8 kenumFromThenWord8 z2enumFromThenWord8))

instance Enum (Word8)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a137v364v137v383toEnum
      (\ p -> gtoEnumWord8 T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a137v388v137v411fromEnum
      (\ p -> gfromEnumWord8 T.mkNoSrcPos p)
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a137v420v137v443enumFrom
      (\ p -> genumFromWord8 T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a137v452v137v483enumFromThen
      (\ p -> genumFromThenWord8 T.mkNoSrcPos p)
  

gtoEnumWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Word16)

gtoEnumWord16 ptoEnumWord16 p =
  T.ufun1 atoEnumWord16 ptoEnumWord16 p htoEnumWord16

htoEnumWord16 z1toEnumWord16 ktoEnumWord16 =
  fromWord16 ktoEnumWord16
    (Prelude.toEnum (T.toInt ktoEnumWord16 z1toEnumWord16))

gfromEnumWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 Int)

gfromEnumWord16 pfromEnumWord16 p =
  T.ufun1 afromEnumWord16 pfromEnumWord16 p hfromEnumWord16

hfromEnumWord16 z1fromEnumWord16 kfromEnumWord16 =
  T.fromInt kfromEnumWord16
    (Prelude.fromEnum (toWord16 kfromEnumWord16 z1fromEnumWord16))

genumFromWord16 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.List Word16))

genumFromWord16 penumFromWord16 p =
  T.ufun1 aenumFromWord16 penumFromWord16 p henumFromWord16

henumFromWord16 z1enumFromWord16 kenumFromWord16 =
  (fromList fromWord16) kenumFromWord16
    (Prelude.enumFrom (toWord16 kenumFromWord16 z1enumFromWord16))

genumFromThenWord16 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word16 (T.Fun Word16 (T.List Word16)))

genumFromThenWord16 penumFromThenWord16 p =
  T.ufun2 aenumFromThenWord16 penumFromThenWord16 p henumFromThenWord16

henumFromThenWord16 z1enumFromThenWord16 z2enumFromThenWord16
  kenumFromThenWord16 =
  (fromList fromWord16) kenumFromThenWord16
    (Prelude.enumFromThen (toWord16 kenumFromThenWord16 z1enumFromThenWord16)
      (toWord16 kenumFromThenWord16 z2enumFromThenWord16))

instance Enum (Word16)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a138v380v138v400toEnum
      (\ p -> gtoEnumWord16 T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a138v412v138v436fromEnum
      (\ p -> gfromEnumWord16 T.mkNoSrcPos p)
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a138v444v138v468enumFrom
      (\ p -> genumFromWord16 T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a138v476v138v508enumFromThen
      (\ p -> genumFromThenWord16 T.mkNoSrcPos p)
  

gtoEnumWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Word32)

gtoEnumWord32 ptoEnumWord32 p =
  T.ufun1 atoEnumWord32 ptoEnumWord32 p htoEnumWord32

htoEnumWord32 z1toEnumWord32 ktoEnumWord32 =
  fromWord32 ktoEnumWord32
    (Prelude.toEnum (T.toInt ktoEnumWord32 z1toEnumWord32))

gfromEnumWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 Int)

gfromEnumWord32 pfromEnumWord32 p =
  T.ufun1 afromEnumWord32 pfromEnumWord32 p hfromEnumWord32

hfromEnumWord32 z1fromEnumWord32 kfromEnumWord32 =
  T.fromInt kfromEnumWord32
    (Prelude.fromEnum (toWord32 kfromEnumWord32 z1fromEnumWord32))

genumFromWord32 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.List Word32))

genumFromWord32 penumFromWord32 p =
  T.ufun1 aenumFromWord32 penumFromWord32 p henumFromWord32

henumFromWord32 z1enumFromWord32 kenumFromWord32 =
  (fromList fromWord32) kenumFromWord32
    (Prelude.enumFrom (toWord32 kenumFromWord32 z1enumFromWord32))

genumFromThenWord32 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word32 (T.Fun Word32 (T.List Word32)))

genumFromThenWord32 penumFromThenWord32 p =
  T.ufun2 aenumFromThenWord32 penumFromThenWord32 p henumFromThenWord32

henumFromThenWord32 z1enumFromThenWord32 z2enumFromThenWord32
  kenumFromThenWord32 =
  (fromList fromWord32) kenumFromThenWord32
    (Prelude.enumFromThen (toWord32 kenumFromThenWord32 z1enumFromThenWord32)
      (toWord32 kenumFromThenWord32 z2enumFromThenWord32))

instance Enum (Word32)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a139v380v139v400toEnum
      (\ p -> gtoEnumWord32 T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a139v412v139v436fromEnum
      (\ p -> gfromEnumWord32 T.mkNoSrcPos p)
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a139v444v139v468enumFrom
      (\ p -> genumFromWord32 T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a139v476v139v508enumFromThen
      (\ p -> genumFromThenWord32 T.mkNoSrcPos p)
  

gtoEnumWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Word64)

gtoEnumWord64 ptoEnumWord64 p =
  T.ufun1 atoEnumWord64 ptoEnumWord64 p htoEnumWord64

htoEnumWord64 z1toEnumWord64 ktoEnumWord64 =
  fromWord64 ktoEnumWord64
    (Prelude.toEnum (T.toInt ktoEnumWord64 z1toEnumWord64))

gfromEnumWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 Int)

gfromEnumWord64 pfromEnumWord64 p =
  T.ufun1 afromEnumWord64 pfromEnumWord64 p hfromEnumWord64

hfromEnumWord64 z1fromEnumWord64 kfromEnumWord64 =
  T.fromInt kfromEnumWord64
    (Prelude.fromEnum (toWord64 kfromEnumWord64 z1fromEnumWord64))

genumFromWord64 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.List Word64))

genumFromWord64 penumFromWord64 p =
  T.ufun1 aenumFromWord64 penumFromWord64 p henumFromWord64

henumFromWord64 z1enumFromWord64 kenumFromWord64 =
  (fromList fromWord64) kenumFromWord64
    (Prelude.enumFrom (toWord64 kenumFromWord64 z1enumFromWord64))

genumFromThenWord64 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Word64 (T.Fun Word64 (T.List Word64)))

genumFromThenWord64 penumFromThenWord64 p =
  T.ufun2 aenumFromThenWord64 penumFromThenWord64 p henumFromThenWord64

henumFromThenWord64 z1enumFromThenWord64 z2enumFromThenWord64
  kenumFromThenWord64 =
  (fromList fromWord64) kenumFromThenWord64
    (Prelude.enumFromThen (toWord64 kenumFromThenWord64 z1enumFromThenWord64)
      (toWord64 kenumFromThenWord64 z2enumFromThenWord64))

instance Enum (Word64)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a140v380v140v400toEnum
      (\ p -> gtoEnumWord64 T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a140v412v140v436fromEnum
      (\ p -> gfromEnumWord64 T.mkNoSrcPos p)
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a140v444v140v468enumFrom
      (\ p -> genumFromWord64 T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a140v476v140v508enumFromThen
      (\ p -> genumFromThenWord64 T.mkNoSrcPos p)
  

greadsPrecWord ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun String (T.List (T.Tuple2 Word String))))

greadsPrecWord preadsPrecWord p =
  T.ufun2 areadsPrecWord preadsPrecWord p hreadsPrecWord

hreadsPrecWord z1readsPrecWord z2readsPrecWord kreadsPrecWord =
  (fromList (T.fromTuple2 fromWord fromString)) kreadsPrecWord
    (Prelude.readsPrec (T.toInt kreadsPrecWord z1readsPrecWord)
      (toString kreadsPrecWord z2readsPrecWord))

instance Read (Word)
  where
  
  greadsPrec preadsPrec p = T.uconstUse preadsPrec p sreadsPrec
  
  sreadsPrec =
    T.uconstDef T.mkRoot a142v141v142v165readsPrec
      (\ p -> greadsPrecWord T.mkNoSrcPos p)
  

greadsPrecWord8 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun String (T.List (T.Tuple2 Word8 String))))

greadsPrecWord8 preadsPrecWord8 p =
  T.ufun2 areadsPrecWord8 preadsPrecWord8 p hreadsPrecWord8

hreadsPrecWord8 z1readsPrecWord8 z2readsPrecWord8 kreadsPrecWord8 =
  (fromList (T.fromTuple2 fromWord8 fromString)) kreadsPrecWord8
    (Prelude.readsPrec (T.toInt kreadsPrecWord8 z1readsPrecWord8)
      (toString kreadsPrecWord8 z2readsPrecWord8))

instance Read (Word8)
  where
  
  greadsPrec preadsPrec p = T.uconstUse preadsPrec p sreadsPrec
  
  sreadsPrec =
    T.uconstDef T.mkRoot a143v141v143v166readsPrec
      (\ p -> greadsPrecWord8 T.mkNoSrcPos p)
  

greadsPrecWord16 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun String (T.List (T.Tuple2 Word16 String))))

greadsPrecWord16 preadsPrecWord16 p =
  T.ufun2 areadsPrecWord16 preadsPrecWord16 p hreadsPrecWord16

hreadsPrecWord16 z1readsPrecWord16 z2readsPrecWord16 kreadsPrecWord16 =
  (fromList (T.fromTuple2 fromWord16 fromString)) kreadsPrecWord16
    (Prelude.readsPrec (T.toInt kreadsPrecWord16 z1readsPrecWord16)
      (toString kreadsPrecWord16 z2readsPrecWord16))

instance Read (Word16)
  where
  
  greadsPrec preadsPrec p = T.uconstUse preadsPrec p sreadsPrec
  
  sreadsPrec =
    T.uconstDef T.mkRoot a144v141v144v167readsPrec
      (\ p -> greadsPrecWord16 T.mkNoSrcPos p)
  

greadsPrecWord32 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun String (T.List (T.Tuple2 Word32 String))))

greadsPrecWord32 preadsPrecWord32 p =
  T.ufun2 areadsPrecWord32 preadsPrecWord32 p hreadsPrecWord32

hreadsPrecWord32 z1readsPrecWord32 z2readsPrecWord32 kreadsPrecWord32 =
  (fromList (T.fromTuple2 fromWord32 fromString)) kreadsPrecWord32
    (Prelude.readsPrec (T.toInt kreadsPrecWord32 z1readsPrecWord32)
      (toString kreadsPrecWord32 z2readsPrecWord32))

instance Read (Word32)
  where
  
  greadsPrec preadsPrec p = T.uconstUse preadsPrec p sreadsPrec
  
  sreadsPrec =
    T.uconstDef T.mkRoot a145v141v145v167readsPrec
      (\ p -> greadsPrecWord32 T.mkNoSrcPos p)
  

greadsPrecWord64 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun String (T.List (T.Tuple2 Word64 String))))

greadsPrecWord64 preadsPrecWord64 p =
  T.ufun2 areadsPrecWord64 preadsPrecWord64 p hreadsPrecWord64

hreadsPrecWord64 z1readsPrecWord64 z2readsPrecWord64 kreadsPrecWord64 =
  (fromList (T.fromTuple2 fromWord64 fromString)) kreadsPrecWord64
    (Prelude.readsPrec (T.toInt kreadsPrecWord64 z1readsPrecWord64)
      (toString kreadsPrecWord64 z2readsPrecWord64))

instance Read (Word64)
  where
  
  greadsPrec preadsPrec p = T.uconstUse preadsPrec p sreadsPrec
  
  sreadsPrec =
    T.uconstDef T.mkRoot a146v141v146v167readsPrec
      (\ p -> greadsPrecWord64 T.mkNoSrcPos p)
  

gshowsPrecWord ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Word (T.Fun String String)))

gshowsPrecWord pshowsPrecWord p =
  T.ufun3 ashowsPrecWord pshowsPrecWord p hshowsPrecWord

hshowsPrecWord z1showsPrecWord z2showsPrecWord z3showsPrecWord kshowsPrecWord =
  fromString kshowsPrecWord
    (Prelude.showsPrec (T.toInt kshowsPrecWord z1showsPrecWord)
      (toWord kshowsPrecWord z2showsPrecWord)
      (toString kshowsPrecWord z3showsPrecWord))

instance Show (Word)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a148v133v148v157showsPrec
      (\ p -> gshowsPrecWord T.mkNoSrcPos p)
  

gshowsPrecWord8 ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Word8 (T.Fun String String)))

gshowsPrecWord8 pshowsPrecWord8 p =
  T.ufun3 ashowsPrecWord8 pshowsPrecWord8 p hshowsPrecWord8

hshowsPrecWord8 z1showsPrecWord8 z2showsPrecWord8 z3showsPrecWord8
  kshowsPrecWord8 =
  fromString kshowsPrecWord8
    (Prelude.showsPrec (T.toInt kshowsPrecWord8 z1showsPrecWord8)
      (toWord8 kshowsPrecWord8 z2showsPrecWord8)
      (toString kshowsPrecWord8 z3showsPrecWord8))

instance Show (Word8)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a149v133v149v158showsPrec
      (\ p -> gshowsPrecWord8 T.mkNoSrcPos p)
  

gshowsPrecWord16 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun Word16 (T.Fun String String)))

gshowsPrecWord16 pshowsPrecWord16 p =
  T.ufun3 ashowsPrecWord16 pshowsPrecWord16 p hshowsPrecWord16

hshowsPrecWord16 z1showsPrecWord16 z2showsPrecWord16 z3showsPrecWord16
  kshowsPrecWord16 =
  fromString kshowsPrecWord16
    (Prelude.showsPrec (T.toInt kshowsPrecWord16 z1showsPrecWord16)
      (toWord16 kshowsPrecWord16 z2showsPrecWord16)
      (toString kshowsPrecWord16 z3showsPrecWord16))

instance Show (Word16)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a150v133v150v159showsPrec
      (\ p -> gshowsPrecWord16 T.mkNoSrcPos p)
  

gshowsPrecWord32 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun Word32 (T.Fun String String)))

gshowsPrecWord32 pshowsPrecWord32 p =
  T.ufun3 ashowsPrecWord32 pshowsPrecWord32 p hshowsPrecWord32

hshowsPrecWord32 z1showsPrecWord32 z2showsPrecWord32 z3showsPrecWord32
  kshowsPrecWord32 =
  fromString kshowsPrecWord32
    (Prelude.showsPrec (T.toInt kshowsPrecWord32 z1showsPrecWord32)
      (toWord32 kshowsPrecWord32 z2showsPrecWord32)
      (toString kshowsPrecWord32 z3showsPrecWord32))

instance Show (Word32)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a151v133v151v159showsPrec
      (\ p -> gshowsPrecWord32 T.mkNoSrcPos p)
  

gshowsPrecWord64 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun Word64 (T.Fun String String)))

gshowsPrecWord64 pshowsPrecWord64 p =
  T.ufun3 ashowsPrecWord64 pshowsPrecWord64 p hshowsPrecWord64

hshowsPrecWord64 z1showsPrecWord64 z2showsPrecWord64 z3showsPrecWord64
  kshowsPrecWord64 =
  fromString kshowsPrecWord64
    (Prelude.showsPrec (T.toInt kshowsPrecWord64 z1showsPrecWord64)
      (toWord64 kshowsPrecWord64 z2showsPrecWord64)
      (toString kshowsPrecWord64 z3showsPrecWord64))

instance Show (Word64)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a152v133v152v159showsPrec
      (\ p -> gshowsPrecWord64 T.mkNoSrcPos p)
  

tData_Word = T.mkModule "Data.Word" "Data/Word.hs" Prelude.False

aeqWord = T.mkVariable tData_Word 920003 920068 3 2 "eqWord" Prelude.False

(+>$=>@=>$=#!>==) =
  T.mkVariable tData_Word 920098 920109 16 0 "==" Prelude.False

aeqWord8 = T.mkVariable tData_Word 930003 930071 3 2 "eqWord8" Prelude.False

(+>%=#!$=>%=##&==) =
  T.mkVariable tData_Word 930102 930114 16 0 "==" Prelude.False

aeqWord16 = T.mkVariable tData_Word 940003 940074 3 2 "eqWord16" Prelude.False

(+>&=#!+=>&=##>==) =
  T.mkVariable tData_Word 940106 940119 16 0 "==" Prelude.False

aeqWord32 = T.mkVariable tData_Word 950003 950074 3 2 "eqWord32" Prelude.False

(+>*=#!+=>*=##>==) =
  T.mkVariable tData_Word 950106 950119 16 0 "==" Prelude.False

aeqWord64 = T.mkVariable tData_Word 960003 960074 3 2 "eqWord64" Prelude.False

(+>+=#!+=>+=##>==) =
  T.mkVariable tData_Word 960106 960119 16 0 "==" Prelude.False

aleWord = T.mkVariable tData_Word 980003 980068 3 2 "leWord" Prelude.False

(+>@=>>=>@=##!<=) =
  T.mkVariable tData_Word 980099 980110 16 0 "<=" Prelude.False

aleWord8 = T.mkVariable tData_Word 990003 990071 3 2 "leWord8" Prelude.False

(+>>=#!%=>>=##*<=) =
  T.mkVariable tData_Word 990103 990115 16 0 "<=" Prelude.False

aleWord16 = T.mkVariable tData_Word 1000003 1000074 3 2 "leWord16" Prelude.False

(+#!!=#!^=#!!=#$!<=) =
  T.mkVariable tData_Word 1000107 1000120 16 0 "<=" Prelude.False

aleWord32 = T.mkVariable tData_Word 1010003 1010074 3 2 "leWord32" Prelude.False

(+#!#=#!^=#!#=#$!<=) =
  T.mkVariable tData_Word 1010107 1010120 16 0 "<=" Prelude.False

aleWord64 = T.mkVariable tData_Word 1020003 1020074 3 2 "leWord64" Prelude.False

(+#!$=#!^=#!$=#$!<=) =
  T.mkVariable tData_Word 1020107 1020120 16 0 "<=" Prelude.False

aaddWord = T.mkVariable tData_Word 1040003 1040068 3 2 "addWord" Prelude.False

asubWord = T.mkVariable tData_Word 1040072 1040137 3 2 "subWord" Prelude.False

amulWord = T.mkVariable tData_Word 1040141 1040206 3 2 "mulWord" Prelude.False

aabsWord = T.mkVariable tData_Word 1040210 1040275 3 1 "absWord" Prelude.False

anegateWord =
  T.mkVariable tData_Word 1040279 1040344 3 1 "negateWord" Prelude.False

asignumWord =
  T.mkVariable tData_Word 1040348 1040413 3 1 "signumWord" Prelude.False

afromIntegerWord =
  T.mkVariable tData_Word 1040417 1040495 3 1 "fromIntegerWord" Prelude.False

(+#!&=*%$=#!&=*&%+) =
  T.mkVariable tData_Word 1040532 1040543 26 0 "+" Prelude.False

(+#!&=*&@=#!&=**>-) =
  T.mkVariable tData_Word 1040548 1040559 26 0 "-" Prelude.False

(+#!&=*+&=#!&=*^**) =
  T.mkVariable tData_Word 1040564 1040575 30 0 "*" Prelude.False

a104v579v104v591abs =
  T.mkVariable tData_Word 1040579 1040591 3 0 "abs" Prelude.False

a104v595v104v613negate =
  T.mkVariable tData_Word 1040595 1040613 3 0 "negate" Prelude.False

a104v619v104v637signum =
  T.mkVariable tData_Word 1040619 1040637 3 0 "signum" Prelude.False

a104v643v104v671fromInteger =
  T.mkVariable tData_Word 1040643 1040671 3 0 "fromInteger" Prelude.False

aaddWord8 = T.mkVariable tData_Word 1050003 1050072 3 2 "addWord8" Prelude.False

asubWord8 = T.mkVariable tData_Word 1050076 1050145 3 2 "subWord8" Prelude.False

amulWord8 = T.mkVariable tData_Word 1050149 1050218 3 2 "mulWord8" Prelude.False

aabsWord8 = T.mkVariable tData_Word 1050222 1050290 3 1 "absWord8" Prelude.False

anegateWord8 =
  T.mkVariable tData_Word 1050294 1050362 3 1 "negateWord8" Prelude.False

asignumWord8 =
  T.mkVariable tData_Word 1050366 1050434 3 1 "signumWord8" Prelude.False

afromIntegerWord8 =
  T.mkVariable tData_Word 1050438 1050518 3 1 "fromIntegerWord8" Prelude.False

(+#!*=**+=#!*=*+@+) =
  T.mkVariable tData_Word 1050556 1050568 26 0 "+" Prelude.False

(+#!*=*@!=#!*=*>$-) =
  T.mkVariable tData_Word 1050580 1050592 26 0 "-" Prelude.False

(+#!*=+!&=#!*=+#+*) =
  T.mkVariable tData_Word 1050604 1050616 30 0 "*" Prelude.False

a105v627v105v640abs =
  T.mkVariable tData_Word 1050627 1050640 3 0 "abs" Prelude.False

a105v651v105v670negate =
  T.mkVariable tData_Word 1050651 1050670 3 0 "negate" Prelude.False

a105v675v105v694signum =
  T.mkVariable tData_Word 1050675 1050694 3 0 "signum" Prelude.False

a105v699v105v728fromInteger =
  T.mkVariable tData_Word 1050699 1050728 3 0 "fromInteger" Prelude.False

aaddWord16 =
  T.mkVariable tData_Word 1060003 1060076 3 2 "addWord16" Prelude.False

asubWord16 =
  T.mkVariable tData_Word 1060080 1060153 3 2 "subWord16" Prelude.False

amulWord16 =
  T.mkVariable tData_Word 1060157 1060230 3 2 "mulWord16" Prelude.False

aabsWord16 =
  T.mkVariable tData_Word 1060234 1060305 3 1 "absWord16" Prelude.False

anegateWord16 =
  T.mkVariable tData_Word 1060309 1060380 3 1 "negateWord16" Prelude.False

asignumWord16 =
  T.mkVariable tData_Word 1060384 1060455 3 1 "signumWord16" Prelude.False

afromIntegerWord16 =
  T.mkVariable tData_Word 1060459 1060541 3 1 "fromIntegerWord16" Prelude.False

(+#!+=*@!=#!+=*>%+) =
  T.mkVariable tData_Word 1060580 1060593 26 0 "+" Prelude.False

(+#!+=+!&=#!+=+#^-) =
  T.mkVariable tData_Word 1060604 1060617 26 0 "-" Prelude.False

(+#!+=+$@=#!+=+&#*) =
  T.mkVariable tData_Word 1060628 1060641 30 0 "*" Prelude.False

a106v651v106v665abs =
  T.mkVariable tData_Word 1060651 1060665 3 0 "abs" Prelude.False

a106v675v106v695negate =
  T.mkVariable tData_Word 1060675 1060695 3 0 "negate" Prelude.False

a106v699v106v719signum =
  T.mkVariable tData_Word 1060699 1060719 3 0 "signum" Prelude.False

a106v723v106v753fromInteger =
  T.mkVariable tData_Word 1060723 1060753 3 0 "fromInteger" Prelude.False

aaddWord32 =
  T.mkVariable tData_Word 1070003 1070076 3 2 "addWord32" Prelude.False

asubWord32 =
  T.mkVariable tData_Word 1070080 1070153 3 2 "subWord32" Prelude.False

amulWord32 =
  T.mkVariable tData_Word 1070157 1070230 3 2 "mulWord32" Prelude.False

aabsWord32 =
  T.mkVariable tData_Word 1070234 1070305 3 1 "absWord32" Prelude.False

anegateWord32 =
  T.mkVariable tData_Word 1070309 1070380 3 1 "negateWord32" Prelude.False

asignumWord32 =
  T.mkVariable tData_Word 1070384 1070455 3 1 "signumWord32" Prelude.False

afromIntegerWord32 =
  T.mkVariable tData_Word 1070459 1070541 3 1 "fromIntegerWord32" Prelude.False

(+#!^=*@!=#!^=*>%+) =
  T.mkVariable tData_Word 1070580 1070593 26 0 "+" Prelude.False

(+#!^=+!&=#!^=+#^-) =
  T.mkVariable tData_Word 1070604 1070617 26 0 "-" Prelude.False

(+#!^=+$@=#!^=+&#*) =
  T.mkVariable tData_Word 1070628 1070641 30 0 "*" Prelude.False

a107v651v107v665abs =
  T.mkVariable tData_Word 1070651 1070665 3 0 "abs" Prelude.False

a107v675v107v695negate =
  T.mkVariable tData_Word 1070675 1070695 3 0 "negate" Prelude.False

a107v699v107v719signum =
  T.mkVariable tData_Word 1070699 1070719 3 0 "signum" Prelude.False

a107v723v107v753fromInteger =
  T.mkVariable tData_Word 1070723 1070753 3 0 "fromInteger" Prelude.False

aaddWord64 =
  T.mkVariable tData_Word 1080003 1080076 3 2 "addWord64" Prelude.False

asubWord64 =
  T.mkVariable tData_Word 1080080 1080153 3 2 "subWord64" Prelude.False

amulWord64 =
  T.mkVariable tData_Word 1080157 1080230 3 2 "mulWord64" Prelude.False

aabsWord64 =
  T.mkVariable tData_Word 1080234 1080305 3 1 "absWord64" Prelude.False

anegateWord64 =
  T.mkVariable tData_Word 1080309 1080380 3 1 "negateWord64" Prelude.False

asignumWord64 =
  T.mkVariable tData_Word 1080384 1080455 3 1 "signumWord64" Prelude.False

afromIntegerWord64 =
  T.mkVariable tData_Word 1080459 1080541 3 1 "fromIntegerWord64" Prelude.False

(+#!@=*@!=#!@=*>%+) =
  T.mkVariable tData_Word 1080580 1080593 26 0 "+" Prelude.False

(+#!@=+!&=#!@=+#^-) =
  T.mkVariable tData_Word 1080604 1080617 26 0 "-" Prelude.False

(+#!@=+$@=#!@=+&#*) =
  T.mkVariable tData_Word 1080628 1080641 30 0 "*" Prelude.False

a108v651v108v665abs =
  T.mkVariable tData_Word 1080651 1080665 3 0 "abs" Prelude.False

a108v675v108v695negate =
  T.mkVariable tData_Word 1080675 1080695 3 0 "negate" Prelude.False

a108v699v108v719signum =
  T.mkVariable tData_Word 1080699 1080719 3 0 "signum" Prelude.False

a108v723v108v753fromInteger =
  T.mkVariable tData_Word 1080723 1080753 3 0 "fromInteger" Prelude.False

aminWord = T.mkVariable tData_Word 1100003 1100059 3 0 "minWord" Prelude.False

amaxWord = T.mkVariable tData_Word 1100067 1100123 3 0 "maxWord" Prelude.False

a110v163v110v180minBound =
  T.mkVariable tData_Word 1100163 1100180 3 0 "minBound" Prelude.False

a110v187v110v204maxBound =
  T.mkVariable tData_Word 1100187 1100204 3 0 "maxBound" Prelude.False

aminWord8 = T.mkVariable tData_Word 1110003 1110061 3 0 "minWord8" Prelude.False

amaxWord8 = T.mkVariable tData_Word 1110067 1110125 3 0 "maxWord8" Prelude.False

a111v163v111v181minBound =
  T.mkVariable tData_Word 1110163 1110181 3 0 "minBound" Prelude.False

a111v187v111v205maxBound =
  T.mkVariable tData_Word 1110187 1110205 3 0 "maxBound" Prelude.False

aminWord16 =
  T.mkVariable tData_Word 1120003 1120063 3 0 "minWord16" Prelude.False

amaxWord16 =
  T.mkVariable tData_Word 1120067 1120127 3 0 "maxWord16" Prelude.False

a112v163v112v182minBound =
  T.mkVariable tData_Word 1120163 1120182 3 0 "minBound" Prelude.False

a112v187v112v206maxBound =
  T.mkVariable tData_Word 1120187 1120206 3 0 "maxBound" Prelude.False

aminWord32 =
  T.mkVariable tData_Word 1130003 1130063 3 0 "minWord32" Prelude.False

amaxWord32 =
  T.mkVariable tData_Word 1130067 1130127 3 0 "maxWord32" Prelude.False

a113v163v113v182minBound =
  T.mkVariable tData_Word 1130163 1130182 3 0 "minBound" Prelude.False

a113v187v113v206maxBound =
  T.mkVariable tData_Word 1130187 1130206 3 0 "maxBound" Prelude.False

aminWord64 =
  T.mkVariable tData_Word 1140003 1140063 3 0 "minWord64" Prelude.False

amaxWord64 =
  T.mkVariable tData_Word 1140067 1140127 3 0 "maxWord64" Prelude.False

a114v163v114v182minBound =
  T.mkVariable tData_Word 1140163 1140182 3 0 "minBound" Prelude.False

a114v187v114v206maxBound =
  T.mkVariable tData_Word 1140187 1140206 3 0 "maxBound" Prelude.False

a116v35v116v64toRational =
  T.mkVariable tData_Word 1160035 1160064 3 1 "toRational" Prelude.False

a117v35v117v65toRational =
  T.mkVariable tData_Word 1170035 1170065 3 1 "toRational" Prelude.False

a118v35v118v66toRational =
  T.mkVariable tData_Word 1180035 1180066 3 1 "toRational" Prelude.False

a119v35v119v66toRational =
  T.mkVariable tData_Word 1190035 1190066 3 1 "toRational" Prelude.False

a120v35v120v66toRational =
  T.mkVariable tData_Word 1200035 1200066 3 1 "toRational" Prelude.False

aquotWord = T.mkVariable tData_Word 1220003 1220072 3 2 "quotWord" Prelude.False

aremWord = T.mkVariable tData_Word 1220083 1220152 3 2 "remWord" Prelude.False

atoIntWord =
  T.mkVariable tData_Word 1220156 1220234 3 1 "toIntWord" Prelude.False

a122v275v122v289quot =
  T.mkVariable tData_Word 1220275 1220289 30 0 "quot" Prelude.False

a122v299v122v312rem =
  T.mkVariable tData_Word 1220299 1220312 30 0 "rem" Prelude.False

a122v323v122v343toInteger =
  T.mkVariable tData_Word 1220323 1220343 3 0 "toInteger" Prelude.False

aquotWord8 =
  T.mkVariable tData_Word 1230003 1230076 3 2 "quotWord8" Prelude.False

aremWord8 = T.mkVariable tData_Word 1230083 1230156 3 2 "remWord8" Prelude.False

atoIntWord8 =
  T.mkVariable tData_Word 1230160 1230240 3 1 "toIntWord8" Prelude.False

a123v283v123v298quot =
  T.mkVariable tData_Word 1230283 1230298 30 0 "quot" Prelude.False

a123v307v123v321rem =
  T.mkVariable tData_Word 1230307 1230321 30 0 "rem" Prelude.False

a123v331v123v352toInteger =
  T.mkVariable tData_Word 1230331 1230352 3 0 "toInteger" Prelude.False

aquotWord16 =
  T.mkVariable tData_Word 1240003 1240080 3 2 "quotWord16" Prelude.False

aremWord16 =
  T.mkVariable tData_Word 1240091 1240168 3 2 "remWord16" Prelude.False

atoIntWord16 =
  T.mkVariable tData_Word 1240172 1240254 3 1 "toIntWord16" Prelude.False

a124v299v124v315quot =
  T.mkVariable tData_Word 1240299 1240315 30 0 "quot" Prelude.False

a124v323v124v338rem =
  T.mkVariable tData_Word 1240323 1240338 30 0 "rem" Prelude.False

a124v347v124v369toInteger =
  T.mkVariable tData_Word 1240347 1240369 3 0 "toInteger" Prelude.False

aquotWord32 =
  T.mkVariable tData_Word 1250003 1250080 3 2 "quotWord32" Prelude.False

aremWord32 =
  T.mkVariable tData_Word 1250091 1250168 3 2 "remWord32" Prelude.False

atoIntWord32 =
  T.mkVariable tData_Word 1250172 1250254 3 1 "toIntWord32" Prelude.False

a125v299v125v315quot =
  T.mkVariable tData_Word 1250299 1250315 30 0 "quot" Prelude.False

a125v323v125v338rem =
  T.mkVariable tData_Word 1250323 1250338 30 0 "rem" Prelude.False

a125v347v125v369toInteger =
  T.mkVariable tData_Word 1250347 1250369 3 0 "toInteger" Prelude.False

aquotWord64 =
  T.mkVariable tData_Word 1260003 1260080 3 2 "quotWord64" Prelude.False

aremWord64 =
  T.mkVariable tData_Word 1260091 1260168 3 2 "remWord64" Prelude.False

atoIntWord64 =
  T.mkVariable tData_Word 1260172 1260254 3 1 "toIntWord64" Prelude.False

a126v299v126v315quot =
  T.mkVariable tData_Word 1260299 1260315 30 0 "quot" Prelude.False

a126v323v126v338rem =
  T.mkVariable tData_Word 1260323 1260338 30 0 "rem" Prelude.False

a126v347v126v369toInteger =
  T.mkVariable tData_Word 1260347 1260369 3 0 "toInteger" Prelude.False

atoEnumWord =
  T.mkVariable tData_Word 1360003 1360071 3 1 "toEnumWord" Prelude.False

afromEnumWord =
  T.mkVariable tData_Word 1360075 1360143 3 1 "fromEnumWord" Prelude.False

aenumFromWord =
  T.mkVariable tData_Word 1360147 1360213 3 1 "enumFromWord" Prelude.False

aenumFromThenWord =
  T.mkVariable tData_Word 1360227 1360305 3 2 "enumFromThenWord" Prelude.False

a136v348v136v366toEnum =
  T.mkVariable tData_Word 1360348 1360366 3 0 "toEnum" Prelude.False

a136v372v136v394fromEnum =
  T.mkVariable tData_Word 1360372 1360394 3 0 "fromEnum" Prelude.False

a136v404v136v426enumFrom =
  T.mkVariable tData_Word 1360404 1360426 3 0 "enumFrom" Prelude.False

a136v436v136v466enumFromThen =
  T.mkVariable tData_Word 1360436 1360466 3 0 "enumFromThen" Prelude.False

atoEnumWord8 =
  T.mkVariable tData_Word 1370003 1370073 3 1 "toEnumWord8" Prelude.False

afromEnumWord8 =
  T.mkVariable tData_Word 1370083 1370153 3 1 "fromEnumWord8" Prelude.False

aenumFromWord8 =
  T.mkVariable tData_Word 1370163 1370231 3 1 "enumFromWord8" Prelude.False

aenumFromThenWord8 =
  T.mkVariable tData_Word 1370243 1370324 3 2 "enumFromThenWord8" Prelude.False

a137v364v137v383toEnum =
  T.mkVariable tData_Word 1370364 1370383 3 0 "toEnum" Prelude.False

a137v388v137v411fromEnum =
  T.mkVariable tData_Word 1370388 1370411 3 0 "fromEnum" Prelude.False

a137v420v137v443enumFrom =
  T.mkVariable tData_Word 1370420 1370443 3 0 "enumFrom" Prelude.False

a137v452v137v483enumFromThen =
  T.mkVariable tData_Word 1370452 1370483 3 0 "enumFromThen" Prelude.False

atoEnumWord16 =
  T.mkVariable tData_Word 1380003 1380075 3 1 "toEnumWord16" Prelude.False

afromEnumWord16 =
  T.mkVariable tData_Word 1380083 1380155 3 1 "fromEnumWord16" Prelude.False

aenumFromWord16 =
  T.mkVariable tData_Word 1380163 1380233 3 1 "enumFromWord16" Prelude.False

aenumFromThenWord16 =
  T.mkVariable tData_Word 1380251 1380335 3 2 "enumFromThenWord16" Prelude.False

a138v380v138v400toEnum =
  T.mkVariable tData_Word 1380380 1380400 3 0 "toEnum" Prelude.False

a138v412v138v436fromEnum =
  T.mkVariable tData_Word 1380412 1380436 3 0 "fromEnum" Prelude.False

a138v444v138v468enumFrom =
  T.mkVariable tData_Word 1380444 1380468 3 0 "enumFrom" Prelude.False

a138v476v138v508enumFromThen =
  T.mkVariable tData_Word 1380476 1380508 3 0 "enumFromThen" Prelude.False

atoEnumWord32 =
  T.mkVariable tData_Word 1390003 1390075 3 1 "toEnumWord32" Prelude.False

afromEnumWord32 =
  T.mkVariable tData_Word 1390083 1390155 3 1 "fromEnumWord32" Prelude.False

aenumFromWord32 =
  T.mkVariable tData_Word 1390163 1390233 3 1 "enumFromWord32" Prelude.False

aenumFromThenWord32 =
  T.mkVariable tData_Word 1390251 1390335 3 2 "enumFromThenWord32" Prelude.False

a139v380v139v400toEnum =
  T.mkVariable tData_Word 1390380 1390400 3 0 "toEnum" Prelude.False

a139v412v139v436fromEnum =
  T.mkVariable tData_Word 1390412 1390436 3 0 "fromEnum" Prelude.False

a139v444v139v468enumFrom =
  T.mkVariable tData_Word 1390444 1390468 3 0 "enumFrom" Prelude.False

a139v476v139v508enumFromThen =
  T.mkVariable tData_Word 1390476 1390508 3 0 "enumFromThen" Prelude.False

atoEnumWord64 =
  T.mkVariable tData_Word 1400003 1400075 3 1 "toEnumWord64" Prelude.False

afromEnumWord64 =
  T.mkVariable tData_Word 1400083 1400155 3 1 "fromEnumWord64" Prelude.False

aenumFromWord64 =
  T.mkVariable tData_Word 1400163 1400233 3 1 "enumFromWord64" Prelude.False

aenumFromThenWord64 =
  T.mkVariable tData_Word 1400251 1400335 3 2 "enumFromThenWord64" Prelude.False

a140v380v140v400toEnum =
  T.mkVariable tData_Word 1400380 1400400 3 0 "toEnum" Prelude.False

a140v412v140v436fromEnum =
  T.mkVariable tData_Word 1400412 1400436 3 0 "fromEnum" Prelude.False

a140v444v140v468enumFrom =
  T.mkVariable tData_Word 1400444 1400468 3 0 "enumFrom" Prelude.False

a140v476v140v508enumFromThen =
  T.mkVariable tData_Word 1400476 1400508 3 0 "enumFromThen" Prelude.False

areadsPrecWord =
  T.mkVariable tData_Word 1420003 1420083 3 2 "readsPrecWord" Prelude.False

a142v141v142v165readsPrec =
  T.mkVariable tData_Word 1420141 1420165 3 0 "readsPrec" Prelude.False

areadsPrecWord8 =
  T.mkVariable tData_Word 1430003 1430084 3 2 "readsPrecWord8" Prelude.False

a143v141v143v166readsPrec =
  T.mkVariable tData_Word 1430141 1430166 3 0 "readsPrec" Prelude.False

areadsPrecWord16 =
  T.mkVariable tData_Word 1440003 1440085 3 2 "readsPrecWord16" Prelude.False

a144v141v144v167readsPrec =
  T.mkVariable tData_Word 1440141 1440167 3 0 "readsPrec" Prelude.False

areadsPrecWord32 =
  T.mkVariable tData_Word 1450003 1450085 3 2 "readsPrecWord32" Prelude.False

a145v141v145v167readsPrec =
  T.mkVariable tData_Word 1450141 1450167 3 0 "readsPrec" Prelude.False

areadsPrecWord64 =
  T.mkVariable tData_Word 1460003 1460085 3 2 "readsPrecWord64" Prelude.False

a146v141v146v167readsPrec =
  T.mkVariable tData_Word 1460141 1460167 3 0 "readsPrec" Prelude.False

ashowsPrecWord =
  T.mkVariable tData_Word 1480003 1480090 3 3 "showsPrecWord" Prelude.False

a148v133v148v157showsPrec =
  T.mkVariable tData_Word 1480133 1480157 3 0 "showsPrec" Prelude.False

ashowsPrecWord8 =
  T.mkVariable tData_Word 1490003 1490092 3 3 "showsPrecWord8" Prelude.False

a149v133v149v158showsPrec =
  T.mkVariable tData_Word 1490133 1490158 3 0 "showsPrec" Prelude.False

ashowsPrecWord16 =
  T.mkVariable tData_Word 1500003 1500094 3 3 "showsPrecWord16" Prelude.False

a150v133v150v159showsPrec =
  T.mkVariable tData_Word 1500133 1500159 3 0 "showsPrec" Prelude.False

ashowsPrecWord32 =
  T.mkVariable tData_Word 1510003 1510094 3 3 "showsPrecWord32" Prelude.False

a151v133v151v159showsPrec =
  T.mkVariable tData_Word 1510133 1510159 3 0 "showsPrec" Prelude.False

ashowsPrecWord64 =
  T.mkVariable tData_Word 1520003 1520094 3 3 "showsPrecWord64" Prelude.False

a152v133v152v159showsPrec =
  T.mkVariable tData_Word 1520133 1520159 3 0 "showsPrec" Prelude.False
