package cli

import (
	"fmt"

	"github.com/spf13/cobra"
)

func newNetworkDeleteCommand(cli *CLI) *cobra.Command {
	cmd := &cobra.Command{
		Use:                   "delete [FLAGS] NETWORK",
		Short:                 "Delete a network",
		Args:                  cobra.ExactArgs(1),
		TraverseChildren:      true,
		DisableFlagsInUseLine: true,
		PreRunE:               cli.ensureToken,
		RunE:                  cli.wrap(runNetworkDelete),
	}
	return cmd
}

func runNetworkDelete(cli *CLI, cmd *cobra.Command, args []string) error {
	idOrName := args[0]
	network, _, err := cli.Client().Network.Get(cli.Context, idOrName)
	if err != nil {
		return err
	}
	if network == nil {
		return fmt.Errorf("network not found: %s", idOrName)
	}

	_, err = cli.Client().Network.Delete(cli.Context, network)
	if err != nil {
		return err
	}

	fmt.Printf("Network %d deleted\n", network.ID)
	return nil
}
