/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdf.ncsa.uiuc.edu/HDF5/doc/Copyright.html.  If you do not have     *
 * access to either file, you may request a copy from hdfhelp@ncsa.uiuc.edu. *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#ifndef _H5f90_H
#define _H5f90_H 

#include "hdf5.h"
#include "H5f90i.h"
#include "H5f90proto.h"

/* Constants used in H5Rff.f90 and H5Rf.c files */
#define REF_REG_BUF_LEN_F    3

/* Constants used in H5Gf.c files */
#define OBJECT_NAMELEN_DEFAULT_F -1
#define H5_MAX(a,b)            (((a)>(b)) ? (a) : (b))
#endif /* _H5f90_H */
