@ ECHO OFF

REM The Dynamic Discovery of Szip Encoder features is implemented in this batch file.
REM We do not need to manually set HDF5_SZIP_ENCODE environment variable.
REM We will check whether the SZIP library available includes encoder or not by 
REM calling the szip encoder detecting executable file testh5repack_detect_szip(dll).exe
REM and check the printed value.
REM If the printed value is "yes", then the SZIP library has encoder, HDF5_SZIP_ENCODE will be set as 1.
REM Otherwise,  HDF5_SZIP_ENCODE will be set as 0, and some tests will be skipped.

FOR /F "delims=" %%a in ('testfiles\testh5repack_detect_szip%2\%1\testh5repack_detect_szip%2.exe') Do Set "Output=%%a"
if "%Output%"=="yes" (
	Set HDF5_SZIP_ENCODE=1
)	else (
	Set HDF5_SZIP_ENCODE=0
)

REM testfiles\h5repacktst\%1\h5repacktst

mkdir temptest
type nul > temptest\empty.txt
echo 0 differences found> temptest\empty.txt
type nul > repacktest%2_%1.txt
echo ========================================== >> repacktest%2_%1.txt
echo Testing repacktest.bat >> repacktest%2_%1.txt
echo ========================================== >> repacktest%2_%1.txt

cd h5repack%2\%1

REM
REM The tests
REM We use the files generated by h5repack test
REM Each run generates "out.test*.h5" and the tool h5diff is used to
REM compare the input and output files.  The output from tool h5diff is 
REM redirected to a file, which should be an empty file when the input 
REM and output files are identical.  We can check whether the h5diff output
REM file is empty so we can know whether h5repack test passed.

REM copy files (these files have no filters; test2.h5 has copied references that h5diff detects)
REM TOOLTEST test0.h5
h5repack%2 -i ..\..\testfiles\test0.h5 -o ..\..\temptest\out.test0.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test0.h5 ..\..\temptest\out.test0.h5 > ..\..\temptest\test0.results 2>..\..\temptest\test0_error.results
more ..\..\temptest\test0_error.results >> ..\..\temptest\test0.results
fc ..\..\temptest\test0.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test0.h5                                              PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test0.h5                                              FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test0.h5
del ..\..\temptest\test0.results
del ..\..\temptest\test0_error.results

REM TOOLTEST test1.h5
h5repack%2 -i ..\..\testfiles\test1.h5 -o ..\..\temptest\out.test1.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test1.h5 ..\..\temptest\out.test1.h5 > ..\..\temptest\test1.results 2>..\..\temptest\test1_error.results
more ..\..\temptest\test1_error.results >> ..\..\temptest\test1.results
fc ..\..\temptest\test1.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test1.h5                                              PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test1.h5                                              FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test1.h5
del ..\..\temptest\test1.results
del ..\..\temptest\test1_error.results

REM TOOLTEST test3.h5
h5repack%2 -i ..\..\testfiles\test3.h5 -o ..\..\temptest\out.test3.h5 
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test3.h5 ..\..\temptest\out.test3.h5 > ..\..\temptest\test3.results 2>..\..\temptest\test3_error.results
more ..\..\temptest\test3_error.results >> ..\..\temptest\test3.results
fc ..\..\temptest\test3.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test3.h5                                              PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test3.h5                                              FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test3.h5
del ..\..\temptest\test3.results
del ..\..\temptest\test3_error.results

REM TOOLTEST test4.h5
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5                                              PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5                                              FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test5.h5
h5repack%2 -i ..\..\testfiles\test5.h5 -o ..\..\temptest\out.test5.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test5.h5 ..\..\temptest\out.test5.h5 > ..\..\temptest\test5.results 2>..\..\temptest\test5_error.results
more ..\..\temptest\test5_error.results >> ..\..\temptest\test5.results
fc ..\..\temptest\test5.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test5.h5                                              PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test5.h5                                              FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test5.h5
del ..\..\temptest\test5.results
del ..\..\temptest\test5_error.results

REM use test4.h5 to write some filters (this file has no filters)
REM gzip with individual object
REM TOOLTEST test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP1
if %HDF5_EXT_ZLIB%==zdll.lib (
    h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10
    ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
    more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
    fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
    if %ERRORLEVEL%==0 (
       echo Testing h5repack test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10        PASSED >> ..\..\repacktest%2_%1.txt
    ) else (
        echo Testing h5repack test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10        FAILED >> ..\..\repacktest%2_%1.txt
        more temp.txt >> ..\..\repacktest%2_%1.txt
    )
    del temp.txt
    del ..\..\temptest\out.test4.h5
    del ..\..\temptest\test4.results
    del ..\..\temptest\test4_error.results
    GOTO NEXTSTEP2
) else (
    echo Testing h5repack test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10        -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP2
)

:NEXTSTEP1
echo Testing h5repack test4.h5 -f dset1:GZIP=1  -l dset1:CHUNK=20x10        -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP2

REM gzip for all
REM TOOLTEST test4.h5 -f GZIP=1
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP3
if %HDF5_EXT_ZLIB%==zdll.lib (
    h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f GZIP=1
    ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
    more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
    fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
    if %ERRORLEVEL%==0 (
       echo Testing h5repack test4.h5 -f GZIP=1                                    PASSED >> ..\..\repacktest%2_%1.txt
    ) else (
        echo Testing h5repack test4.h5 -f GZIP=1                                    FAILED >> ..\..\repacktest%2_%1.txt
        more temp.txt >> ..\..\repacktest%2_%1.txt
    )
    del temp.txt
    del ..\..\temptest\out.test4.h5
    del ..\..\temptest\test4.results
    del ..\..\temptest\test4_error.results
    GOTO NEXTSTEP4
) else (
    echo Testing h5repack test4.h5 -f GZIP=1                                    -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP4
)

:NEXTSTEP3
echo Testing h5repack test4.h5 -f GZIP=1                                    -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP4

REM szip with individual object
REM TOOLTEST test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP5
if %HDF5_EXT_SZIP%==szlibdll.lib (
   if %HDF5_SZIP_ENCODE%==1 (
      h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10
      ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
      more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
      fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
      if %ERRORLEVEL%==0 (
         echo Testing h5repack test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10     PASSED >> ..\..\repacktest%2_%1.txt
      ) else (
          echo Testing h5repack test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10     FAILED >> ..\..\repacktest%2_%1.txt
          more temp.txt >> ..\..\repacktest%2_%1.txt
      )
      del temp.txt
      del ..\..\temptest\out.test4.h5
      del ..\..\temptest\test4.results
      del ..\..\temptest\test4_error.results
      GOTO NEXTSTEP6
      ) else (
          echo Testing h5repack test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10     -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP6
      )
) else (
    echo Testing h5repack test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10     -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP6
)

:NEXTSTEP5
echo Testing h5repack test4.h5 -f dset2:SZIP=8,EC  -l dset2:CHUNK=20x10     -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP6

REM szip for all
REM TOOLTEST test4.h5 -f SZIP=8,NN
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP7
if %HDF5_EXT_SZIP%==szlibdll.lib (
   if %HDF5_SZIP_ENCODE%==1 (
      h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f SZIP=8,NN
      ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
      more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
      fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
      if %ERRORLEVEL%==0 (
         echo Testing h5repack test4.h5 -f SZIP=8,NN                                 PASSED >> ..\..\repacktest%2_%1.txt
      ) else (
          echo Testing h5repack test4.h5 -f SZIP=8,NN                                 FAILED >> ..\..\repacktest%2_%1.txt
          more temp.txt >> ..\..\repacktest%2_%1.txt
      )
      del temp.txt
      del ..\..\temptest\out.test4.h5
      del ..\..\temptest\test4.results
      del ..\..\temptest\test4_error.results
      GOTO NEXTSTEP8
      ) else (
          echo Testing h5repack test4.h5 -f SZIP=8,NN                                 -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP8
      )
) else (
    echo Testing h5repack test4.h5 -f SZIP=8,NN                                 -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP8
)

:NEXTSTEP7
echo Testing h5repack test4.h5 -f SZIP=8,NN                                 -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP8

REM shuffle with individual object
REM TOOLTEST test4.h5 -f dset2:SHUF  -l dset2:CHUNK=20x10
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f dset2:SHUF  -l dset2:CHUNK=20x10
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -f dset2:SHUF  -l dset2:CHUNK=20x10          PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -f dset2:SHUF  -l dset2:CHUNK=20x10          FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM shuffle for all
REM TOOLTEST test4.h5 -f SHUF
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f SHUF
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -f SHUF                                      PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -f SHUF                                      FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM fletcher32  with individual object
REM TOOLTEST test4.h5 -f dset2:FLET  -l dset2:CHUNK=20x10
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f dset2:FLET  -l dset2:CHUNK=20x10
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -f dset2:FLET  -l dset2:CHUNK=20x10          PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -f dset2:FLET  -l dset2:CHUNK=20x10          FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM fletcher32 for all
REM TOOLTEST test4.h5 -f FLET
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f FLET
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -f FLET                                      PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -f FLET                                      FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM all filters
REM TOOLTEST test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8,NN -f dset2:GZIP=1 -l dset2:CHUNK=20x10
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP9
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP9
if %HDF5_EXT_ZLIB%==zdll.lib (
   if %HDF5_EXT_SZIP%==szlibdll.lib (
      if %HDF5_SZIP_ENCODE%==1 (
         h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f dset2:SZIP=8,NN -f dset2:GZIP=1 -l dset2:CHUNK=20x10
         ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
         more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
         fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
         if %ERRORLEVEL%==0 (
            echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, PASSED >> ..\..\repacktest%2_%1.txt
         ) else (
             echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, FAILED >> ..\..\repacktest%2_%1.txt
             more temp.txt >> ..\..\repacktest%2_%1.txt
         )
         del temp.txt
         del ..\..\temptest\out.test4.h5
         del ..\..\temptest\test4.results
         del ..\..\temptest\test4_error.results
         GOTO NEXTSTEP10
         ) else (
             echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, -SKIP- >> ..\..\repacktest%2_%1.txt
             GOTO NEXTSTEP10
         )
      ) else (
          echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP10
      )
) else (
    echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP10
)

:NEXTSTEP9
echo Testing h5repack test4.h5 -f dset2:SHUF -f dset2:FLET -f dset2:SZIP=8, -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP10

REM ###########################################################
REM # the following tests assume the input files have filters
REM ###########################################################

REM szip copy
REM TOOLTEST test_szip.h5
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP11
if %HDF5_EXT_SZIP%==szlibdll.lib (
   if %HDF5_SZIP_ENCODE%==1 (
      h5repack%2 -i ..\..\testfiles\test_szip.h5 -o ..\..\temptest\out.test_szip.h5
      ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_szip.h5 ..\..\temptest\out.test_szip.h5 > ..\..\temptest\test_szip.results 2>..\..\temptest\test_szip_error.results
      more ..\..\temptest\test_szip_error.results >> ..\..\temptest\test_szip.results
      fc ..\..\temptest\test_szip.results ..\..\temptest\empty.txt >temp.txt
      if %ERRORLEVEL%==0 (
         echo Testing h5repack test_szip.h5                                          PASSED >> ..\..\repacktest%2_%1.txt
      ) else (
         echo Testing h5repack test_szip.h5                                          FAILED >> ..\..\repacktest%2_%1.txt
         more temp.txt >> ..\..\repacktest%2_%1.txt
      )
      del temp.txt
      del ..\..\temptest\out.test_szip.h5
      del ..\..\temptest\test_szip.results
      del ..\..\temptest\test_szip_error.results
      GOTO NEXTSTEP12
      ) else (
          echo Testing h5repack test_szip.h5                                          -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP12
      )
) else (
    echo Testing h5repack test_szip.h5                                          -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP12
)

:NEXTSTEP11
echo Testing h5repack test_szip.h5                                          -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP12
  
REM szip remove
REM TOOLTEST test_szip.h5 -f dset_szip:NONE
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP13
if %HDF5_EXT_SZIP%==szlibdll.lib (
   if %HDF5_SZIP_ENCODE%==1 (
      h5repack%2 -i ..\..\testfiles\test_szip.h5 -o ..\..\temptest\out.test_szip.h5 -f dset_szip:NONE
      ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_szip.h5 ..\..\temptest\out.test_szip.h5 > ..\..\temptest\test_szip.results 2>..\..\temptest\test_szip_error.results
      more ..\..\temptest\test_szip_error.results >> ..\..\temptest\test_szip.results
      fc ..\..\temptest\test_szip.results ..\..\temptest\empty.txt >temp.txt
      if %ERRORLEVEL%==0 (
         echo Testing h5repack test_szip.h5 -f dset_szip:NONE                        PASSED >> ..\..\repacktest%2_%1.txt
      ) else (
         echo Testing h5repack test_szip.h5 -f dset_szip:NONE                        FAILED >> ..\..\repacktest%2_%1.txt
         more temp.txt >> ..\..\repacktest%2_%1.txt
      )
      del temp.txt
      del ..\..\temptest\out.test_szip.h5
      del ..\..\temptest\test_szip.results
      del ..\..\temptest\test_szip_error.results
      GOTO NEXTSTEP14
      ) else (
          echo Testing h5repack test_szip.h5 -f dset_szip:NONE                        -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP14
      )
) else (
    echo Testing h5repack test_szip.h5 -f dset_szip:NONE                        -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP14
)

:NEXTSTEP13
echo Testing h5repack test_szip.h5 -f dset_szip:NONE                        -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP14
  
REM deflate copy
REM TOOLTEST test_deflate.h5
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP15
if %HDF5_EXT_ZLIB%==zdll.lib (
   h5repack%2 -i ..\..\testfiles\test_deflate.h5 -o ..\..\temptest\out.test_deflate.h5
   ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_deflate.h5 ..\..\temptest\out.test_deflate.h5 > ..\..\temptest\test_deflate.results 2>..\..\temptest\test_deflate_error.results
   more ..\..\temptest\test_deflate_error.results >> ..\..\temptest\test_deflate.results
   fc ..\..\temptest\test_deflate.results ..\..\temptest\empty.txt >temp.txt
   if %ERRORLEVEL%==0 (
      echo Testing h5repack test_deflate.h5                                       PASSED >> ..\..\repacktest%2_%1.txt
   ) else (
      echo Testing h5repack test_deflate.h5                                       FAILED >> ..\..\repacktest%2_%1.txt
      more temp.txt >> ..\..\repacktest%2_%1.txt
   )
   del temp.txt
   del ..\..\temptest\out.test_deflate.h5
   del ..\..\temptest\test_deflate.results
   del ..\..\temptest\test_deflate_error.results
   GOTO NEXTSTEP16
) else (
    echo Testing h5repack test_deflate.h5                                       -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP16
)

:NEXTSTEP15
echo Testing h5repack test_deflate.h5                                       -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP16

REM deflate remove
REM TOOLTEST test_deflate.h5 -f dset_deflate:NONE
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP17
if %HDF5_EXT_ZLIB%==zdll.lib (
   h5repack%2 -i ..\..\testfiles\test_deflate.h5 -o ..\..\temptest\out.test_deflate.h5 -f dset_deflate:NONE
   ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_deflate.h5 ..\..\temptest\out.test_deflate.h5 > ..\..\temptest\test_deflate.results 2>..\..\temptest\test_deflate_error.results
   more ..\..\temptest\test_deflate_error.results >> ..\..\temptest\test_deflate.results
   fc ..\..\temptest\test_deflate.results ..\..\temptest\empty.txt >temp.txt
   if %ERRORLEVEL%==0 (
      echo Testing h5repack test_deflate.h5 -f dset_deflate:NONE                  PASSED >> ..\..\repacktest%2_%1.txt
   ) else (
      echo Testing h5repack test_deflate.h5 -f dset_deflate:NONE                  FAILED >> ..\..\repacktest%2_%1.txt
      more temp.txt >> ..\..\repacktest%2_%1.txt
   )
   del temp.txt
   del ..\..\temptest\out.test_deflate.h5
   del ..\..\temptest\test_deflate.results
   del ..\..\temptest\test_deflate_error.results
   GOTO NEXTSTEP18
) else (
    echo Testing h5repack test_deflate.h5 -f dset_deflate:NONE                  -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP18
)

:NEXTSTEP17
echo Testing h5repack test_deflate.h5 -f dset_deflate:NONE                  -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP18
   
REM shuffle copy
REM TOOLTEST test_shuffle.h5
h5repack%2 -i ..\..\testfiles\test_shuffle.h5 -o ..\..\temptest\out.test_shuffle.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_shuffle.h5 ..\..\temptest\out.test_shuffle.h5 > ..\..\temptest\test_shuffle.results 2>..\..\temptest\test_shuffle_error.results
more ..\..\temptest\test_shuffle_error.results >> ..\..\temptest\test_shuffle.results
fc ..\..\temptest\test_shuffle.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test_shuffle.h5                                       PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test_shuffle.h5                                       FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test_shuffle.h5
del ..\..\temptest\test_shuffle.results
del ..\..\temptest\test_shuffle_error.results

REM shuffle remove
REM TOOLTEST test_shuffle.h5 -f dset_shuffle:NONE
h5repack%2 -i ..\..\testfiles\test_shuffle.h5 -o ..\..\temptest\out.test_shuffle.h5 -f dset_shuffle:NONE
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_shuffle.h5 ..\..\temptest\out.test_shuffle.h5 > ..\..\temptest\test_shuffle.results 2>..\..\temptest\test_shuffle_error.results
more ..\..\temptest\test_shuffle_error.results >> ..\..\temptest\test_shuffle.results
fc ..\..\temptest\test_shuffle.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test_shuffle.h5 -f dset_shuffle:NONE                  PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test_shuffle.h5 -f dset_shuffle:NONE                  FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test_shuffle.h5
del ..\..\temptest\test_shuffle.results
del ..\..\temptest\test_shuffle_error.results

REM fletcher32 copy
REM TOOLTEST test_fletcher32.h5
h5repack%2 -i ..\..\testfiles\test_fletcher32.h5 -o ..\..\temptest\out.test_fletcher32.h5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_fletcher32.h5 ..\..\temptest\out.test_fletcher32.h5 > ..\..\temptest\test_fletcher32.results 2>..\..\temptest\test_fletcher32_error.results
more ..\..\temptest\test_fletcher32_error.results >> ..\..\temptest\test_fletcher32.results
fc ..\..\temptest\test_fletcher32.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test_fletcher32.h5                                    PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test_fletcher32.h5                                    FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test_fletcher32.h5
del ..\..\temptest\test_fletcher32.results
del ..\..\temptest\test_fletcher32_error.results

REM fletcher32 remove
REM TOOLTEST test_fletcher32.h5 -f dset_fletcher32:NONE
h5repack%2 -i ..\..\testfiles\test_fletcher32.h5 -o ..\..\temptest\out.test_fletcher32.h5 -f dset_fletcher32:NONE
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_fletcher32.h5 ..\..\temptest\out.test_fletcher32.h5 > ..\..\temptest\test_fletcher32.results 2>..\..\temptest\test_fletcher32_error.results
more ..\..\temptest\test_fletcher32_error.results >> ..\..\temptest\test_fletcher32.results
fc ..\..\temptest\test_fletcher32.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test_fletcher32.h5 -f dset_fletcher32:NONE            PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test_fletcher32.h5 -f dset_fletcher32:NONE            FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test_fletcher32.h5
del ..\..\temptest\test_fletcher32.results
del ..\..\temptest\test_fletcher32_error.results

REM remove all  filters
REM TOOLTEST test_all.h5 -f NONE
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP19
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP19
if %HDF5_EXT_ZLIB%==zdll.lib (
   if %HDF5_EXT_SZIP%==szlibdll.lib (
      if %HDF5_SZIP_ENCODE%==1 (
         h5repack%2 -i ..\..\testfiles\test_all.h5 -o ..\..\temptest\out.test_all.h5 -f NONE
         ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_all.h5 ..\..\temptest\out.test_all.h5 > ..\..\temptest\test_all.results 2>..\..\temptest\test_all_error.results
         more ..\..\temptest\test_all_error.results >> ..\..\temptest\test_all.results
         fc ..\..\temptest\test_all.results ..\..\temptest\empty.txt >temp.txt
         if %ERRORLEVEL%==0 (
            echo Testing h5repack test_all.h5 -f NONE                                   PASSED >> ..\..\repacktest%2_%1.txt
         ) else (
            echo Testing h5repack test_all.h5 -f NONE                                   FAILED >> ..\..\repacktest%2_%1.txt
            more temp.txt >> ..\..\repacktest%2_%1.txt
         )
         del temp.txt
         del ..\..\temptest\out.test_all.h5
         del ..\..\temptest\test_all.results
         del ..\..\temptest\test_all_error.results
         GOTO NEXTSTEP20
         ) else (
             echo Testing h5repack test_all.h5 -f NONE                                   -SKIP- >> ..\..\repacktest%2_%1.txt
             GOTO NEXTSTEP20
         )
      ) else (
          echo Testing h5repack test_all.h5 -f NONE                                   -SKIP- >> ..\..\repacktest%2_%1.txt
          GOTO NEXTSTEP20
      )
) else (
    echo Testing h5repack test_all.h5 -f NONE                                   -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP20
)

:NEXTSTEP19
echo Testing h5repack test_all.h5 -f NONE                                   -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP20

REM filter conversions
REM TOOLTEST test_deflate.h5 -f dset_deflate:SZIP=8,NN
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP21
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP21
if %HDF5_EXT_ZLIB%==zdll.lib (
   if %HDF5_EXT_SZIP%==szlibdll.lib (
      if %HDF5_SZIP_ENCODE%==1 (
         h5repack%2 -i ..\..\testfiles\test_deflate.h5 -o ..\..\temptest\out.test_deflate.h5 -f dset_deflate:SZIP=8,NN
         ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_deflate.h5 ..\..\temptest\out.test_deflate.h5 > ..\..\temptest\test_deflate.results 2>..\..\temptest\test_deflate_error.results
         more ..\..\temptest\test_deflate_error.results >> ..\..\temptest\test_deflate.results
         fc ..\..\temptest\test_deflate.results ..\..\temptest\empty.txt >temp.txt
         if %ERRORLEVEL%==0 (
            echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             PASSED >> ..\..\repacktest%2_%1.txt
         ) else (
            echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             FAILED >> ..\..\repacktest%2_%1.txt
            more temp.txt >> ..\..\repacktest%2_%1.txt
         )
         del temp.txt
         del ..\..\temptest\out.test_deflate.h5
         del ..\..\temptest\test_deflate.results
         del ..\..\temptest\test_deflate_error.results
         GOTO NEXTSTEP22
      ) else (
         echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             -SKIP- >> ..\..\repacktest%2_%1.txt
         GOTO NEXTSTEP22
      )
   ) else (
      echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             -SKIP- >> ..\..\repacktest%2_%1.txt
      GOTO NEXTSTEP22
   )
) else (
    echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP22
)

:NEXTSTEP21
echo Testing h5repack test_deflate.h5 -f dset_deflate:SZIP=8,NN             -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP22
  
REM TOOLTEST test_szip.h5 -f dset_szip:GZIP=1
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP23
if "%HDF5_EXT_SZIP%"=="" GOTO NEXTSTEP23
if %HDF5_EXT_ZLIB%==zdll.lib (
   if %HDF5_EXT_SZIP%==szlibdll.lib (
      if %HDF5_SZIP_ENCODE%==1 (
         h5repack%2 -i ..\..\testfiles\test_szip.h5 -o ..\..\temptest\out.test_szip.h5 -f dset_szip:GZIP=1
         ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test_szip.h5 ..\..\temptest\out.test_szip.h5 > ..\..\temptest\test_szip.results 2>..\..\temptest\test_szip_error.results
         more ..\..\temptest\test_szip_error.results >> ..\..\temptest\test_szip.results
         fc ..\..\temptest\test_szip.results ..\..\temptest\empty.txt >temp.txt
         if %ERRORLEVEL%==0 (
            echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      PASSED >> ..\..\repacktest%2_%1.txt
         ) else (
            echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      FAILED >> ..\..\repacktest%2_%1.txt
            more temp.txt >> ..\..\repacktest%2_%1.txt
         )
         del temp.txt
         del ..\..\temptest\out.test_szip.h5
         del ..\..\temptest\test_szip.results
         del ..\..\temptest\test_szip_error.results
         GOTO NEXTSTEP24
      ) else (
         echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      -SKIP- >> ..\..\repacktest%2_%1.txt
         GOTO NEXTSTEP24
      )
   ) else (
      echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      -SKIP- >> ..\..\repacktest%2_%1.txt
      GOTO NEXTSTEP24
   )
) else (
    echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP24
)

:NEXTSTEP23
echo Testing h5repack test_szip.h5 -f dset_szip:GZIP=1                      -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP24
  
REM limit
REM TOOLTEST test4.h5 -f GZIP=1 -m 1024
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP25
if %HDF5_EXT_ZLIB%==zdll.lib (
   h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -f GZIP=1 -m 1024
   ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
   more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
   fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
   if %ERRORLEVEL%==0 (
      echo Testing h5repack test4.h5 -f GZIP=1 -m 1024                            PASSED >> ..\..\repacktest%2_%1.txt
   ) else (
      echo Testing h5repack test4.h5 -f GZIP=1 -m 1024                            FAILED >> ..\..\repacktest%2_%1.txt
      more temp.txt >> ..\..\repacktest%2_%1.txt
   )
   del temp.txt
   del ..\..\temptest\out.test4.h5
   del ..\..\temptest\test4.results
   del ..\..\temptest\test4_error.results
   GOTO NEXTSTEP26
) else (
    echo Testing h5repack test4.h5 -f GZIP=1 -m 1024                            -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP26
)

:NEXTSTEP25
echo Testing h5repack test4.h5 -f GZIP=1 -m 1024                            -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP26
    
REM file
REM TOOLTEST test4.h5 -e ../testfiles/h5repack_info.txt
if "%HDF5_EXT_ZLIB%"=="" GOTO NEXTSTEP27
if %HDF5_EXT_ZLIB%==zdll.lib (
   h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -e ..\..\testfiles\h5repack_info.txt
   ..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
   more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
   fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
   if %ERRORLEVEL%==0 (
      echo Testing h5repack test4.h5 -e ../testfiles/h5repack_info.txt            PASSED >> ..\..\repacktest%2_%1.txt
   ) else (
      echo Testing h5repack test4.h5 -e ../testfiles/h5repack_info.txt            FAILED >> ..\..\repacktest%2_%1.txt
      more temp.txt >> ..\..\repacktest%2_%1.txt
   )
   del temp.txt
   del ..\..\temptest\out.test4.h5
   del ..\..\temptest\test4.results
   del ..\..\temptest\test4_error.results
   GOTO NEXTSTEP28
) else (
    echo Testing h5repack test4.h5 -e ../testfiles/h5repack_info.txt            -SKIP- >> ..\..\repacktest%2_%1.txt
    GOTO NEXTSTEP28
)

:NEXTSTEP27
echo Testing h5repack test4.h5 -e ../testfiles/h5repack_info.txt            -SKIP- >> ..\..\repacktest%2_%1.txt

:NEXTSTEP28
   
REM layout chunk
REM TOOLTEST test4.h5 -l dset2:CHUNK=20x10
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset2:CHUNK=20x10
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset2:CHUNK=20x10                         PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset2:CHUNK=20x10                         FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l CHUNK=20x10
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l CHUNK=20x10
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l CHUNK=20x10                               PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l CHUNK=20x10                               FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM layout contiguous
REM TOOLTEST test4.h5 -l dset2:CONTI
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset2:CONTI
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset2:CONTI                               PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset2:CONTI                               FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l CONTI
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l CONTI
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l CONTI                                     PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l CONTI                                     FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM layout compact
REM TOOLTEST test4.h5 -l dset2:COMPA
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset2:COMPA
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset2:COMPA                               PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset2:COMPA                               FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l COMPA
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l COMPA
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l COMPA                                     PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l COMPA                                     FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM conversions
REM TOOLTEST test4.h5 -l dset_compact:CONTI
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_compact:CONTI
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_compact:CONTI                        PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_compact:CONTI                        FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_compact:CHUNK=2x5
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_compact:CHUNK=2x5
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_compact:CHUNK=2x5                    PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_compact:CHUNK=2x5                    FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_compact:COMPA
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_compact:COMPA
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_compact:COMPA                        PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_compact:COMPA                        FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_contiguous:COMPA
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_contiguous:COMPA
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_contiguous:COMPA                     PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_contiguous:COMPA                     FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_contiguous:CHUNK=3x6
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_contiguous:CHUNK=3x6
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_contiguous:CHUNK=3x6                 PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_contiguous:CHUNK=3x6                 FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_contiguous:CONTI
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_contiguous:CONTI
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_contiguous:CONTI                     PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_contiguous:CONTI                     FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_chunk:COMPA
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_chunk:COMPA
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_chunk:COMPA                          PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_chunk:COMPA                          FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_chunk:CONTI
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_chunk:CONTI
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_chunk:CONTI                          PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_chunk:CONTI                          FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

REM TOOLTEST test4.h5 -l dset_chunk:CHUNK=18x13
h5repack%2 -i ..\..\testfiles\test4.h5 -o ..\..\temptest\out.test4.h5 -l dset_chunk:CHUNK=18x13
..\..\h5diff%2\%1\h5diff%2 ..\..\testfiles\test4.h5 ..\..\temptest\out.test4.h5 > ..\..\temptest\test4.results 2>..\..\temptest\test4_error.results
more ..\..\temptest\test4_error.results >> ..\..\temptest\test4.results
fc ..\..\temptest\test4.results ..\..\temptest\empty.txt >temp.txt
if %ERRORLEVEL%==0 (
   echo Testing h5repack test4.h5 -l dset_chunk:CHUNK=18x13                    PASSED >> ..\..\repacktest%2_%1.txt
) else (
   echo Testing h5repack test4.h5 -l dset_chunk:CHUNK=18x13                    FAILED >> ..\..\repacktest%2_%1.txt
   more temp.txt >> ..\..\repacktest%2_%1.txt
)
del temp.txt
del ..\..\temptest\out.test4.h5
del ..\..\temptest\test4.results
del ..\..\temptest\test4_error.results

cd ..
cd ..

rmdir /s/q temptest