/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.array.MultiArrayCopier;
import nom.tam.util.array.MultiArrayIterator;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;

public final class ArrayFuncs {
    private static final Logger LOG = Logger.getLogger(ArrayFuncs.class.getName());

    private ArrayFuncs() {
    }

    public static String arrayDescription(Object o) {
        Class<?> base = ArrayFuncs.getBaseClass(o);
        if (base == Void.TYPE) {
            return "NULL";
        }
        return new StringBuffer(base.getSimpleName()).append(Arrays.toString(ArrayFuncs.getDimensions(o))).toString();
    }

    public static long computeLSize(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o.getClass().isArray()) {
            Object array;
            long size = 0L;
            MultiArrayIterator iter = new MultiArrayIterator(o);
            while ((array = iter.next()) != null) {
                long length = Array.getLength(array);
                if (length <= 0L) continue;
                Class<?> componentType = array.getClass().getComponentType();
                PrimitiveType primType = PrimitiveTypeHandler.valueOf(componentType);
                if (componentType.isPrimitive()) {
                    size += length * (long)primType.size();
                    continue;
                }
                int index = 0;
                while ((long)index < length) {
                    size += (long)primType.size(Array.get(array, index));
                    ++index;
                }
            }
            return size;
        }
        PrimitiveType primType = PrimitiveTypeHandler.valueOf(o.getClass());
        if (primType.individualSize()) {
            return primType.size(o);
        }
        return primType.size();
    }

    @Deprecated
    public static int computeSize(Object o) {
        return (int)ArrayFuncs.computeLSize(o);
    }

    public static Object convertArray(Object array, Class<?> newType) {
        Object mimic = ArrayFuncs.mimicArray(array, newType);
        ArrayFuncs.copyInto(array, mimic);
        return mimic;
    }

    public static Object convertArray(Object array, Class<?> newType, boolean reuse) {
        if (ArrayFuncs.getBaseClass(array) == newType && reuse) {
            return array;
        }
        return ArrayFuncs.convertArray(array, newType);
    }

    public static void copyArray(Object original, Object copy) {
        Class<?> originalClass = original.getClass();
        if (!originalClass.isArray()) {
            return;
        }
        int length = Array.getLength(original);
        if (originalClass.getComponentType().isArray()) {
            if (length != Array.getLength(copy)) {
                return;
            }
            for (int index = 0; index < length; ++index) {
                ArrayFuncs.copyArray(Array.get(original, index), Array.get(copy, index));
            }
        }
        System.arraycopy(original, 0, copy, 0, length);
    }

    public static void copyInto(Object array, Object mimic) {
        MultiArrayCopier.copyInto(array, mimic);
    }

    public static Object curl(Object input, int[] dimens) {
        if (input == null) {
            return null;
        }
        if (!input.getClass().isArray() || input.getClass().getComponentType().isArray()) {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int size = Array.getLength(input);
        int test = 1;
        for (int dimen : dimens) {
            test *= dimen;
        }
        if (test != size) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Object newArray = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), dimens);
        MultiArrayCopier.copyInto(input, newArray);
        return newArray;
    }

    public static Object deepClone(Object o) {
        if (o == null) {
            return null;
        }
        if (!o.getClass().isArray()) {
            return ArrayFuncs.genericClone(o);
        }
        if (o.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(o);
            Object result = Array.newInstance(o.getClass().getComponentType(), length);
            System.arraycopy(o, 0, result, 0, length);
            return result;
        }
        Class<?> baseClass = ArrayFuncs.getBaseClass(o);
        int[] dims = ArrayFuncs.getDimensions(o);
        Arrays.fill(dims, 1, dims.length, 0);
        Object copy = ArrayFuncs.newInstance(baseClass, dims);
        for (int i = 0; i < dims[0]; ++i) {
            Array.set(copy, i, ArrayFuncs.deepClone(Array.get(o, i)));
        }
        return copy;
    }

    public static Object flatten(Object input) {
        int[] dimens = ArrayFuncs.getDimensions(input);
        if (dimens.length <= 1) {
            return input;
        }
        int size = 1;
        for (int dimen : dimens) {
            size *= dimen;
        }
        Object flat = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), size);
        MultiArrayCopier.copyInto(input, flat);
        return flat;
    }

    public static Object genericClone(Object o) {
        if (o.getClass().isArray()) {
            return ArrayFuncs.deepClone(o);
        }
        if (!(o instanceof Cloneable)) {
            LOG.log(Level.SEVERE, "generic clone called on a non clonable type");
            return null;
        }
        try {
            return o.getClass().getMethod("clone", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Implements cloneable, but does not apparently make clone public.", e);
            return null;
        }
    }

    public static Object getBaseArray(Object o) {
        if (o.getClass().getComponentType().isArray()) {
            return ArrayFuncs.getBaseArray(Array.get(o, 0));
        }
        return o;
    }

    public static Class<?> getBaseClass(Object o) {
        if (o == null) {
            return Void.TYPE;
        }
        Class<?> clazz = o.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static int getBaseLength(Object o) {
        if (o == null) {
            return 0;
        }
        PrimitiveType type = PrimitiveTypeHandler.valueOf(ArrayFuncs.getBaseClass(o));
        if (type != null && type.size() != 0) {
            return type.size();
        }
        return -1;
    }

    public static int[] getDimensions(Object o) {
        if (o == null) {
            return null;
        }
        Object object = o;
        Class<?> clazz = o.getClass();
        int ndim = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++ndim;
        }
        clazz = o.getClass();
        int[] dimens = new int[ndim];
        ndim = 0;
        while (clazz.isArray()) {
            dimens[ndim] = -1;
            if (object != null) {
                int length = Array.getLength(object);
                if (length > 0) {
                    dimens[ndim] = length;
                    object = Array.get(object, 0);
                } else {
                    dimens[ndim] = 0;
                    object = null;
                }
            }
            clazz = clazz.getComponentType();
            ++ndim;
        }
        return dimens;
    }

    public static Object mimicArray(Object array, Class<?> newType) {
        Object mimic;
        int dims = 0;
        Class<?> arrayClass = array.getClass();
        while (arrayClass != null && arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
            ++dims;
        }
        if (dims > 1) {
            Object[] xarray = (Object[])array;
            int[] dimens = new int[dims];
            dimens[0] = xarray.length;
            mimic = ArrayFuncs.newInstance(newType, dimens);
            for (int i = 0; i < xarray.length; ++i) {
                Object temp;
                ((Object[])mimic)[i] = temp = ArrayFuncs.mimicArray(xarray[i], newType);
            }
        } else {
            mimic = ArrayFuncs.newInstance(newType, Array.getLength(array));
        }
        return mimic;
    }

    @Deprecated
    public static int nElements(Object o) {
        return (int)ArrayFuncs.nLElements(o);
    }

    public static Object newInstance(Class<?> cl, int dim) {
        Object o = Array.newInstance(cl, dim);
        if (o == null) {
            throw new OutOfMemoryError("Unable to allocate array: " + cl + "[" + dim + "]");
        }
        return o;
    }

    public static Object newInstance(Class<?> cl, int[] dims) {
        Object o;
        if (dims.length == 0) {
            dims = new int[]{1};
        }
        if ((o = Array.newInstance(cl, dims)) == null) {
            throw new OutOfMemoryError("Unable to allocate array: " + cl + Arrays.toString(dims));
        }
        return o;
    }

    @Deprecated
    public static long nLElements(Object o) {
        if (o == null) {
            return 0L;
        }
        String classname = o.getClass().getName();
        if (classname.charAt(1) == '[') {
            int count = 0;
            for (int i = 0; i < ((Object[])o).length; ++i) {
                count = (int)((long)count + ArrayFuncs.nLElements(((Object[])o)[i]));
            }
            return count;
        }
        if (classname.charAt(0) == '[') {
            return Array.getLength(o);
        }
        return 1L;
    }

    public static int[] reverseIndices(int[] indices) {
        int[] result = new int[indices.length];
        int len = indices.length;
        for (int i = 0; i < indices.length; ++i) {
            result[len - i - 1] = indices[i];
        }
        return result;
    }
}

