#!/usr/local/bin/perl

use strict;

my $graphtitle = "Uniprocessor runtimes, normalized to Hoard";

my %names;

$names{"hoard"} = "Hoard";
$names{"ptmalloc"} = "ptmalloc";
$names{"ptmalloc2"} = "ptmalloc2";
$names{"mtmalloc"} = "mtmalloc";
$names{"Solaris"} = "Solaris";
$names{"dlmalloc"} = "DLmalloc";
$names{"kingsley"} = "Kingsley";

my @namelist = ("hoard","ptmalloc","ptmalloc2","mtmalloc","Solaris","dlmalloc","kingsley");
my $name;
my $n;

my $item = 0;

if (1) {

    open D, ">data.plt";

    my %datapoint;
    
    my %normalize;
    
    foreach $name (@namelist) {
	foreach $n ("197.parser","cfrac","espresso","perl","roboop") {
#	    open G, "> $n/Results/$name/data";
#	    open H, "> $n/Results/$name/datal";
	    for (my $i = 1; $i <= 1; $i++) {
		open F, "$n/Results/$name/$n";
		my $total = 0;
		my $count = 0;
		my $min = 1e30;
		my $max = -1e30;
		while (<F>) {
		    chop;
		    if (/([0-9]+\.[0-9]+) seconds/) {
			# print G "$i\t$1\n";
			my $current = $1;
			$total += $1;
			$count++;
			if ($current < $min) {
			    $min = $current;
			}
			if ($current > $max) {
			    $max = $current;
			}
		    }
		}
		my $avg = $total / $count;
		$normalize{$n} = $avg if $name eq "hoard";
		my $normalizedAvg = $avg / $normalize{$n} * 100.0;
		my $nfoo = $normalizedAvg * 1.1;
		$item++;
		printf D "$item\t$n\t%.3f\t%.3f\t%.3f\n", $normalizedAvg, $normalizedAvg, $normalizedAvg;
#	printf "$item\t$n\t%.3f\t%.3f\t%.3f\n", $nfoo, $normalizedAvg, $normalizedAvg;
		#printf G "$item\t$n\t%.3f\t%.3f\t%.3f\n", $normalizedAvg, $normalizedAvg, $normalizedAvg;
		#printf H "$item\t$n\t%.3f\t%.3f\t%.3f\n", $nfoo, $normalizedAvg, $normalizedAvg;
		close F;
	    }
#	    close G;
#	    close H;
	}
	printf D "\n\n";
	$item++;
    }
    close D;
}



#open PLOT, ">fooq";
open PLOT, "|gnuplot";
print PLOT "set term postscript color\n";
print PLOT "set output \"foo.ps\"\n";
print PLOT "set title \"$graphtitle\"\n";
print PLOT "set ylabel \"Normalized Runtime\"\n";
print PLOT "set xlabel \"Allocator\"\n";
print PLOT "set yrange [0:*]\n";
print PLOT "set xrange [0:42]\n";
print PLOT "set xtics rotate\n";
print PLOT "set style fill solid border 1\n";
# print PLOT "set style fill empty border 1\n";
print PLOT "set boxwidth 0.75\n";
print PLOT "set key top left\n";

print PLOT "set format y \"%.0f%%\"\n";
print PLOT "set format x \"%.0f%%\"\n";
print PLOT "f(x) = 100\n";
print PLOT "plot 'data.plt' using 1:3:xticlabels(2) index 0 with boxes title \"Hoard\", 'data.plt' using 1:3:xticlabels(2) index 1 with boxes title \"ptmalloc\", 'data.plt' using 1:3:xticlabels(2) index 2 with boxes title \"ptmalloc2\", 'data.plt' using 1:3:xticlabels(2) index 3 with boxes title \"mtmalloc\", 'data.plt' using 1:3:xticlabels(2) index 4 with boxes title \"Solaris\", 'data.plt' using 1:3:xticlabels(2) index 5 with boxes title \"DLmalloc\",  'data.plt' using 1:3:xticlabels(2) index 6 with boxes title \"KingsleyHeap\", f(x) notitle\n";

if (0) {
my $name;
my $n;

my $index = 0;

print PLOT "plot ";

if (1) {

    foreach $name (@namelist) {
	foreach $n ("cfrac","espresso","roboop") {
	    # next if ($name eq $namelist[-1]);
	    print "name = $name\n";
	    my $titlename = $names{$name};
	    print PLOT "\"$n/Results/$name/data\" using 1:3:xticlabels(2) with boxes fill title \"$n-$titlename\", ";
	}
    }
}

# plot .datafile. using 1:(0.5 * $2):4 with labels font "arial,11" tc lt 2

if (1) {
    #print PLOT "plot ";
    foreach $name (@namelist) {
	foreach $n ("cfrac","espresso","roboop") {
	    print "name = $name\n";
	    my $titlename = $names{$name};
	    print PLOT "\"$n/Results/$name/datal\" using 1:3:4 with labels font \"arial,14\" tc lt 0 notitle , ";
	    if (($n eq "roboop") && ($name eq $namelist[-1])) {
		$name = $namelist[-1];
		my $titlename = $names{$name};
		print PLOT "\"$n/Results/$name/datal\" using 1:3:4 with labels font \"arial,14\" tc lt 0 notitle\n";
	    }
	}
    }
}
}

close PLOT;



