/* $Log: calloc-heap.c,v $
/* Revision 1.1  2003/10/15 15:58:50  emery
/* Initial check-in.
/*
/* Revision 1.1  2001/08/23 17:19:35  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:20  dgay
/* Initial import of RC tests
/*
 * Revision 1.5  1997/08/04 22:16:44  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.4  1996/02/09 14:58:10  arda
 * Security holes
 *
 * Revision 1.3  1993/05/02  07:37:37  un_mec
 * Owl: New output (mudlle ports).
 *
 * Revision 1.2  1993/03/29  09:23:37  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:13:53  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:40:55  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

static char rcsid[] = "$Id: calloc-heap.c,v 1.1 2003/10/15 15:58:50 emery Exp $";

#include <stdlib.h>
#include <stdio.h>
#ifdef MUME
#include <malloc.h>
#endif
#include "mudlle.h"
#include "calloc.h"
#include "utils.h"

/* Module: calloc
   Date: 14 Feb 92
   Purpose: Fast & easy memory allocator for the mudlle compiler
     Based on the concept of blocks: you allocate memory from a block,
       and can free the whole block at one go.
       Individual deallocations are not possible.
*/

#define ALIGN(x, n) ((x) + ((n) - 1) & ~((n) - 1))

#define BLOCK_SIZE 10000	/* Should probably be chosen w/ respect to
				   malloc implementation */

struct memblock
{
    char *pos;			/* Where next to allocate from */
    char *end;			/* End of block */
    struct memblock *previous;
    char data[BLOCK_SIZE];
};

static struct memblock *make_block(void)
{
    struct memblock *newp = malloc(sizeof(struct memblock));

    if (!newp)
    {
	fprintf(stderr, "No memory left\n");
	exit(1);
    }
    newp->pos = newp->data;
    newp->end = newp->data + BLOCK_SIZE;
    newp->previous = 0;

    return newp;
}

block_t new_block(void)
/* Return: A new block from which to allocate some memory.
*/
{
    block_t newp = xmalloc(sizeof *newp);

    *newp = make_block();
    return newp;
}

void free_block(block_t b)
/* Effect: Free all memory allocated in block b.
*/
{
#if 1
    struct memblock *blk = *b;

    while (blk)
    {
	struct memblock *prev = blk->previous;

	free(blk);
	blk = prev;
    }
#endif
}

void *allocate(block_t b, unsigned long size)
/* Effects: Allocates size bytes from block b. The result is aligned
     correctly for all types.
   Returns: A pointer to the start of the block.
   Note: In this implementation, 12 + average(size)/2 bytes will be wasted
     for every BLOCK_SIZE bytes allocated.
*/
{
    struct memblock *blk = *b;
    void *result;

    /* This could depend on the machine */
    size = ALIGN(size, sizeof(long));

    result = blk->pos;
    if ((blk->pos += size) >= blk->end)
    {
	/* Block full, get new one */
	struct memblock *newp = make_block();

	assert(size < BLOCK_SIZE);
	newp->previous = blk;
	*b = newp;
	result = newp->pos;
	newp->pos += size;
    }
    return result;
}
