/* $Log: mcompile.h,v $
/* Revision 1.1  2003/10/15 15:58:56  emery
/* Initial check-in.
/*
/* Revision 1.1  2001/08/23 17:19:59  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:18  dgay
/* Initial import of RC tests
/*
 * Revision 1.3  1997/08/04 22:17:01  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.2  1996/02/09 14:58:33  arda
 * Security holes
 *
 * Revision 1.1  1994/10/09  06:42:30  arda
 * Libraries
 * Type inference
 * Many minor improvements
 * */
#ifndef MCOMPILE_H
#define MCOMPILE_H

#include "tree.h"
#include "ins.h"

/* Compile module references */

int mstart(block_t heap, mfile f);
/* Effects: Start processing module f:
     - unload f
     - load required modules
     - change status of variables of f (defines, writes)
     - setup information for mrecall/massign/mexecute

     Sends error/warning messages.
   Returns: TRUE if compilation can proceed
*/

void mrecall(ulong n, const char *name, fncode fn);
/* Effects: Generate code to recall variable n
*/

void mexecute(ulong offset, const char *name, int count, fncode fn);
/* Effects: Generates code to call function in variable n, with count
     arguments. If name is NULL, assume that it is part of a protected
     imported module (used for builtins)
*/

void massign(ulong n, const char *name, fncode fn);
/* Effects: Generate code to assign to variable n
*/

void mcompile_init(void);

#endif
