#!/usr/bin/perl

 # Copyright (C) 2004 Andrew Beekhof <andrew@beekhof.net>
 # 
 # This program is free software; you can redistribute it and/or
 # modify it under the terms of the GNU General Public
 # License as published by the Free Software Foundation; either
 # version 2.1 of the License, or (at your option) any later version.
 # 
 # This software is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 # General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public
 # License along with this library; if not, write to the Free Software
 # Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 #

$in_exp=0;
$in_err_exp=0;
$match_all=0;
$max_lines=0;
$log_file="/var/log/messages";
$start_pos=-1;
$end_pos=-1;
$verbose=0;
$timeout=90;
@search_for = ();
@errors     = ();

while ( $_ = @ARGV[0], /^-/ ) {
    shift;
    if ( /^--search/ ) {
	$do_search = 1;
	
    } elsif ( /^--dump/ ) {
	$do_dump = 1;

    } elsif ( /^-t/ ) {
	$timeout = $ARGV[0];
	shift;

    } elsif ( /^-pf/ ) {
	$start_pos = `cat $ARGV[0]`;
#	chop $start_pos;
	shift;
	
    } elsif ( /^-p/ ) {
	$start_pos = $ARGV[0];
	shift;
	
    } elsif ( /^-epf/ ) {
	$end_pos = `cat $ARGV[0]`;
#	chop $end_pos;
	shift;

    } elsif ( /^-ep/ ) {
	$end_pos = $ARGV[0];
	shift;

    } elsif ( /^-v/ ) {
	$verbose = 1;

    } elsif ( /^-m/ ) {
	$max_lines = $ARGV[0];
	shift;

    } elsif ( /^-l/ ) {
	$log_file = $ARGV[0];
	shift;

    } elsif (  /^-a/ ) {
	$match_all = 1;

    } elsif ( /^-s/ ) {
	$this_exp="";
	while( @ARGV ) {
	    last if $ARGV[0] =~ /^-/;
	    $this_exp=$this_exp." ".$ARGV[0];
	    shift;
	}
	$this_exp=substr($this_exp, 1);
#	print STDOUT "Found search expression: _${this_exp}_\n";
	push @search_for, $this_exp;

    } elsif ( /^-e/ ) {
	$this_exp="";
	while( @ARGV ) {
	    last if $ARGV[0] =~ /^-/;
	    $this_exp=$this_exp." ".$ARGV[0];
	    shift;
	}
	$this_exp=substr($this_exp, 1);
#	print STDOUT "Found error expression: _${this_exp}_\n";
	push @errors, $this_exp;
    } else {
	print STDOUT "huh? $_\n";
    }
}

push @errors, "__crmtest_manual_abort__";
#

if( $do_search eq 1 ) {
    $rc=string_search();
    if( $verbose > 0) {
	print STDOUT "Search returned: $rc\n";
    }
    exit $rc;

} elsif( $do_dump eq 1 ) {
    file_dup();

}

sub remote_command() {
    my ($user, $host, @command) = @_;

    my $args = "";

    foreach $arg ( @command ) {
	$args = $args." ".$arg;
    }

    print STDOUT "Running \'".$args."\' as ".$user."@".$host."\n";
    $rc = system "/usr/bin/ssh", "-l", $user, $host, $args;
    return $rc;
}

sub file_dup() {
    open(LOG, $log_file);

    print STDOUT "Duping $log_file from position $start_pos to $end_pos...\n";
    if( $start_pos > 0 ) {
	if( $verbose > 0) {
	    print STDOUT "Starting search in $log_file from position $start_pos...\n";
	}
	seek LOG, $start_pos, 0
    } else {
	if( $verbose > 0) {
	    print STDOUT "Starting search in $log_file from EOF...\n";
	}
	seek LOG, 0, 2;
    }

    for(;;)
    {
#	print STDOUT "Checking $log_file for more data...\n";
	for($curpos = tell LOG; $_ = <LOG>; $curpos = tell LOG) 
	{
	    my $lpc = 0;
	    $line = $_;
	    $num_lines = $num_lines + 1;
	    
	    print STDOUT "[".$num_lines."]: ".$line;

	    if($end_pos > 0 && $curpos > $end_pos) {
		last;
	    }
	 }

	return;
    }
}

sub string_search() {

    my %results    = {};
    my $num_lines  = 0;

    open(LOG, $log_file);
    $max_lines = -1; # turn off line "timeouts" for now

    if( $start_pos > 0 ) {
	if( $verbose > 0) {
	    print STDOUT "Starting search in $log_file from position $start_pos...\n";
	}
	seek LOG, $start_pos, 0
    } else {
	if( $verbose > 0) {
	    print STDOUT "Starting search in $log_file from EOF...\n";
	}
	seek LOG, 0, 2;
    }
    $start_time = time;
    $end_time = $start_time + ${timeout};

    for(;;)
    {
	if($end_time < time) {
	    print "Ran out of time... ${timeout} seconds\n";
	    return -3000;
	}
	    
#	print STDOUT "Checking $log_file for more data...\n";
	for($curpos = tell LOG; $_ = <LOG>; $curpos = tell LOG) 
	{
	    my $lpc = 0;
	    $line = $_;
	    $num_lines = $num_lines + 1;
	    
#	    print STDOUT "Checking line[".$num_lines."]: ".$line;
	    if($max_lines > 0 && $num_lines > $max_lines) {
		foreach $key (sort keys %results) {
		    print STDOUT "Found key \'".$key."\' ".$results{$key}." times.\n" if $results{$key} ne "";
		}
		return -1000;
	    }
	    
	    foreach $regex (@search_for) {
		$lpc = $lpc +1;
		if ( $line =~ /$regex/ ) {
		    if($match_all eq "0") {
			print STDOUT "Found match for (".$regex."): \n\t".$line;
			return $lpc; 
		    } else {
			if( $results{$regex} ne "" ) {
			    $results{$regex} = $results{$regex} + 1;
			} else {
			    $results{$regex} = 1;
			}
			$found = scalar(keys %results)-1;
			if( $verbose > 0) {
			    print STDOUT "[line $num_lines]: Found match ".$found." of ".scalar(@search_for)." for (".$regex."): \n\t".$line;
			}
			if(scalar(@search_for) < scalar(keys %results)) {
			    
			    if( $verbose > 0) {
				foreach $key (sort keys %results) {
				    print STDOUT "Found key \'".$key."\' ".$results{$key}." times.\n" if $results{$key} ne "";
				}
			    }
			    return 0;
			}
		    }
		}
	    }
	    
	    $lpc = 0;
	    foreach $regex ( @errors ) {
		$lpc = $lpc +1;
		if ( $line =~ /$regex/ ) {
		    print STDOUT "Found ERROR match for (".$regex."): ".$line;
		    return 0-$lpc;
		}
	    }
	}
	sleep 3;
	seek LOG, $curpos, 0;
    }
#    print STDOUT "No more lines\n";
    return -2000;
}

