/*
 * Hedgewars, a free turn based strategy game
 * Copyright (c) 2006 Andrey Korotaev <unC0Rr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef PREDEFTEAMS_H
#define PREDEFTEAMS_H

#include <QtGlobal>

#define PREDEFTEAMS_COUNT 3

struct PredefinedTeam
{
	const char * TeamName;
	const char * hh0name;
	const char * hh1name;
	const char * hh2name;
	const char * hh3name;
	const char * hh4name;
	const char * hh5name;
	const char * hh6name;
	const char * hh7name;
	const char * hh0hat;
	const char * hh1hat;
	const char * hh2hat;
	const char * hh3hat;
	const char * hh4hat;
	const char * hh5hat;
	const char * hh6hat;
	const char * hh7hat;
	QString Grave;
	QString Fort;
};


const PredefinedTeam pteams[PREDEFTEAMS_COUNT] =
{
	{
		QT_TRANSLATE_NOOP("teams", "Hedgehogs"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 1"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 2"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 3"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 4"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 5"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 6"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 7"),
		QT_TRANSLATE_NOOP("teams", "hedgehog 8"),
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"Simple", "Island"
	},
	{
		QT_TRANSLATE_NOOP("teams", "Goddess"),
		QT_TRANSLATE_NOOP("teams", "Isis"),
		QT_TRANSLATE_NOOP("teams", "Astarte"),
		QT_TRANSLATE_NOOP("teams", "Diana"),
		QT_TRANSLATE_NOOP("teams", "Aphrodite"),
		QT_TRANSLATE_NOOP("teams", "Hecate"),
		QT_TRANSLATE_NOOP("teams", "Demeter"),
		QT_TRANSLATE_NOOP("teams", "Kali"),
		QT_TRANSLATE_NOOP("teams", "Inanna"),
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"Bone", "Island"
	},
	{
		QT_TRANSLATE_NOOP("teams", "Fruits"),
		QT_TRANSLATE_NOOP("teams", "Banana"),
		QT_TRANSLATE_NOOP("teams", "Apple"),
		QT_TRANSLATE_NOOP("teams", "Orange"),
		QT_TRANSLATE_NOOP("teams", "Lemon"),
		QT_TRANSLATE_NOOP("teams", "Pineapple"),
		QT_TRANSLATE_NOOP("teams", "Mango"),
		QT_TRANSLATE_NOOP("teams", "Peach"),
		QT_TRANSLATE_NOOP("teams", "Plum"),
		"banana",
		"apple",
		"orange",
		"lemon",
		"NoHat",
		"NoHat",
		"NoHat",
		"NoHat",
		"coffin", "Barrelhouse"
	}
};

#endif // PREDEFTEAMS_H
