/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: theoravideo.cpp,v 1.4 2004/07/14 17:42:46 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "theoravideo.h"
#include "theoravidfmt.h"

#include "fmtputil.h"

#include "theorarend.ver"

#include "debug.h" // DPRINTF()
#define D_THEORA_VIDEO 0 //0x4000000


const char* const CTheoraRenderer::zm_pDescription = "Theora Video Renderer";
const char* const CTheoraRenderer::zm_pStreamMimeTypes[] = {
    "video/x-rn-theora",
    NULL
};

HX_RESULT STDAPICALLTYPE 
CTheoraRenderer::HXCreateInstance(IUnknown** ppIUnknown)
{
#ifdef _DEBUG
    debug_level() |= D_THEORA_VIDEO;
#endif

    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::HXCreateInstance()\n"));

    HX_RESULT retVal = HXR_OUTOFMEMORY;

    *ppIUnknown = (IUnknown*)(IHXPlugin*) new CTheoraRenderer();
    if (*ppIUnknown)
    {
        (*ppIUnknown)->AddRef();
        retVal = HXR_OK;
    }

    return retVal;
}

HX_RESULT STDAPICALLTYPE CTheoraRenderer::CanUnload(void)
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::CanUnload()\n"));

    return ((CHXBaseCountingObject::ObjectsActive() > 0) ? HXR_FAIL : HXR_OK);
}

HX_RESULT STDAPICALLTYPE 
CTheoraRenderer::CanUnload2(void)
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::CanUnload2()\n"));
    return ((CHXBaseCountingObject::ObjectsActive() > 0) ? HXR_FAIL : HXR_OK);
}

CTheoraRenderer::CTheoraRenderer(void) :
    CVideoRenderer(),
    CHXBaseCountingObject()
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::CTheoraRenderer()\n"));
}

CTheoraRenderer::~CTheoraRenderer()
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::~CTheoraRenderer()\n"));
}

STDMETHODIMP 
CTheoraRenderer::GetPluginInfo(THIS_
			       REF(BOOL)	 /*OUT*/ bLoadMultiple,
			       REF(const char*) /*OUT*/ pDescription,
			       REF(const char*) /*OUT*/ pCopyright,
			       REF(const char*) /*OUT*/ pMoreInfoURL,
			       REF(ULONG32)	 /*OUT*/ ulVersionNumber
			       )
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::GetPluginInfo()\n"));

    HX_RESULT retVal = CVideoRenderer::GetPluginInfo(bLoadMultiple,
						     pDescription,
						     pCopyright,
						     pMoreInfoURL,
						     ulVersionNumber);

    if (SUCCEEDED(retVal))
    {
	pDescription    = (const char*) zm_pDescription;
	ulVersionNumber = TARVER_ULONG32_VERSION;
    }

    return retVal;
}

STDMETHODIMP
CTheoraRenderer::GetRendererInfo(THIS_
				 REF(const char**) /*OUT*/ pStreamMimeTypes,
				 REF(UINT32)       /*OUT*/ unInitialGranularity
				 )
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::GetRendererInfo()\n"));

    HX_RESULT retVal = CVideoRenderer::GetRendererInfo(pStreamMimeTypes,
						       unInitialGranularity);

    if (SUCCEEDED(retVal))
    {
	pStreamMimeTypes = (const char**) zm_pStreamMimeTypes;
    }
    
    return retVal;
}

CVideoFormat* CTheoraRenderer::CreateFormatObject(IHXValues* pHeader)
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::CreateFormatObject()\n"));

    return new CTheoraVideoFormat(m_pCommonClassFactory, this);
}

const char* CTheoraRenderer::GetRendererName(void)
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::GetRendererName()\n"));

    return "Theora Video";
}

const char* CTheoraRenderer::GetCodecFourCC(void)
{
    DPRINTF(D_THEORA_VIDEO, ("CTheoraRenderer::GetCodecFourCC()\n"));
    return "theo";
}

void CTheoraRenderer::SetupBitmapDefaults(IHXValues* pHeader,
					  HXBitmapInfoHeader &bitmapInfoHeader)
{
    UINT32 ulWidth = 0;
    UINT32 ulHeight = 0;

    IHXBuffer* pConfig = NULL;

    if (HXR_OK == CHXFMTPUtil::GetFMTPConfig(pHeader, 
                                             m_pCommonClassFactory, 
                                             pConfig))
    {
	const UINT8* pHdr = pConfig->GetBuffer();

	if ((pHdr[0] == 0x80) && !memcmp((char*)(pHdr + 1), "theora", 6) &&
	    (pConfig->GetSize() == 42))
	{
	    ulWidth = ((((UINT32)pHdr[10]) << 8) + pHdr[11]) * 16;
	    ulHeight = ((((UINT32)pHdr[12]) << 8) + pHdr[13]) * 16;
	}
	
	
	HX_RELEASE(pConfig);
    }

    // size calculation is taken from crvvideo
    bitmapInfoHeader.biSize = sizeof (HXBitmapInfoHeader);
    bitmapInfoHeader.biWidth = ulWidth;	// 352;		// unknown
    bitmapInfoHeader.biHeight = ulHeight;	// 288;		// unknown
    bitmapInfoHeader.biPlanes = 1;
    bitmapInfoHeader.biBitCount = 12;
    bitmapInfoHeader.biCompression = HX_I420;
    bitmapInfoHeader.biSizeImage = bitmapInfoHeader.biWidth * 
				     bitmapInfoHeader.biHeight * 
				     bitmapInfoHeader.biBitCount / 
				     8;
    bitmapInfoHeader.biXPelsPerMeter = 0; 
    bitmapInfoHeader.biYPelsPerMeter = 0;
    bitmapInfoHeader.biClrUsed = 0;
    bitmapInfoHeader.biClrImportant = 0;
    bitmapInfoHeader.rcolor	= 0;
    bitmapInfoHeader.gcolor	= 0;
    bitmapInfoHeader.bcolor	= 0;    
}
