/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: open.cpp,v 1.2.2.3.2.2 2004/09/08 19:40:13 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "open.h"

#include "hxplayer-i18n.h"

#include "commonapp.h"
#include "mainapp.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>

extern "C"
{
int houd_uri_entry_key_press_event (GtkWidget   *window,
                                    GdkEventKey *event,
                                    gpointer    unused);
}

typedef struct
{
    GladeXML* xml;
    HXMainWindow* window;

    GtkWidget *fs; /* a GtkFileChooser or GtkFileSelection depending
                      on the version of gtk */    
} HXOpenDialog;

G_CONST_RETURN gchar*
hxplay_open_dialog_get_location (GtkDialog* dialog)
{
    HXOpenDialog* info = (HXOpenDialog*)g_object_get_data(G_OBJECT(dialog), "dialog_info");
    if(info)
    {
        gchar* location = NULL;
        
        if(info->fs)
        {
            const gchar* str;

#if GTK_CHECK_VERSION(2, 4, 0)
            str = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
#else  		
            str = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
#endif	

            if(str && *str)
            {
                if(g_file_test(str, G_FILE_TEST_EXISTS) &&
                   !g_file_test(str, G_FILE_TEST_IS_DIR))
                {
                    location = g_strdup_printf("file://%s", str);
                }
            }
        }
        else if(info->xml)
        {
            GtkWidget* entry;
                
            entry = glade_xml_get_widget(info->xml, "houd_uri_entry");
                
            if(entry)
            {
                const gchar* str;
                str = gtk_entry_get_text (GTK_ENTRY (entry));
                if(str && *str)
                {
                    location = g_strdup(str);
                }
            }
        }

        return location;
    }

    return NULL;    
}

static void
hxplay_open_dialog_destroy(GtkWidget* /* widget */,
                           HXOpenDialog* info)
{
    if(info->xml)
    {
        glade_xml_destroy (info->xml);
    }

    g_free(info);
}

static void
hxplay_open_file_dialog_response(GtkWidget* dialog,
                                 gint response_id,
                                 HXOpenDialog* info)
{
    g_return_if_fail(info != NULL);
    g_return_if_fail(info->window != NULL);
    
    if(response_id == GTK_RESPONSE_OK)
    {
        const gchar* str;

#if GTK_CHECK_VERSION(2, 4, 0)
        str = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
#else
        str = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
#endif
        
        if(str && *str)
        {
            GValue value;
            
            memset(&value, 0, sizeof(value));
            g_value_init(&value, G_TYPE_STRING);
            g_value_set_string(&value, g_path_get_dirname(str));
            hxwindow_set_property(info->window, "LastBrowsedDirectory", &value);
            g_value_unset(&value);            
        }
    }
}

GtkDialog*
hxplay_open_file_dialog_new(HXMainWindow* window)
{
    GtkWidget* fs;
    const gchar* str = NULL;
    gchar* path = NULL;
    GValue value;
    HXOpenDialog* info = NULL;
    memset(&value, 0, sizeof(value));
    
    /* Get the default path to open */
    if(hxwindow_get_property(window, "MediaFilesPath", &value))
    {
        str = g_value_get_string(&value);
        if(str && *str)
        {
            path = g_strdup_printf("%s/", str);
        }            
        g_value_unset(&value);
    }

    if(!path || !(*path))
    {
        /* See what the last directory we had opened was */
        if(hxwindow_get_property(window, "LastBrowsedDirectory", &value))
        {
            str = g_value_get_string(&value);
            if(str && *str)
            {
                path = g_strdup_printf("%s/", str);
            }
            g_value_unset(&value);
        }
    }

    const gchar* select_files = _("Select files");
    
#if GTK_CHECK_VERSION(2, 4, 0)
    fs = gtk_file_chooser_dialog_new(select_files,
                                     NULL,
                                     GTK_FILE_CHOOSER_ACTION_OPEN,
                                     GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                     GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                     NULL);

    gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(fs), TRUE);
    
    if(path)
    {
        gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(fs), path);
    }
    
#else
    
    fs = gtk_file_selection_new (select_files);
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(fs));

    if(path)
    {
        gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs), path);
    }
#endif
        
    g_free(path);
    
    info = g_new0(HXOpenDialog, 1);
    info->window = window;

    info->fs = fs;
    
    g_object_set_data(G_OBJECT(fs), "dialog_info", info);

    g_signal_connect (G_OBJECT (fs), "destroy",
                      G_CALLBACK (hxplay_open_dialog_destroy),
                      info);

    g_signal_connect (G_OBJECT (fs), "response",
                      G_CALLBACK (hxplay_open_file_dialog_response),
                      info);

    return GTK_DIALOG (fs);

}

/* This is a callback for the URI dialog box. It prevents
   the combo box from handling the enter key, so the dialog
   can default, even when the combo has focus. */
int
houd_uri_entry_key_press_event (GtkWidget   *widget,
                                GdkEventKey *event,
                                gpointer)
{
    GtkWidget* dialog;
    
    dialog = gtk_widget_get_toplevel(widget);
        
    if (event->keyval == GDK_Return || event->keyval == GDK_KP_Enter)
    {
        gtk_dialog_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);
        return TRUE;
    }

    return FALSE; // propagate
}

GtkDialog*
hxplay_open_location_dialog_new(GList* recent_urls_list)
{
    GladeXML* xml;
    GtkWidget* dialog;
    GtkWidget* combo;
    gchar* filename;
    HXOpenDialog* info = NULL;
    
    filename = hxcommon_locate_file("uri.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    dialog = glade_xml_get_widget (xml, "hxplayer_open_uri_dialog");
    combo = glade_xml_get_widget (xml, "houd_uri_combo");

    /* Populate the recently-played combo box */
    if (recent_urls_list)
    {
	gtk_combo_set_popdown_strings(GTK_COMBO(combo), recent_urls_list);
    }

    info = g_new0(HXOpenDialog, 1);
    info->xml = xml;
    g_object_set_data(G_OBJECT(dialog), "dialog_info", info);

    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hxplay_open_dialog_destroy),
                      info);

    return GTK_DIALOG(dialog);
}
