/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientRequest.cpp,v 1.4.8.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "CHXClientRequest.h"
#include "CHXMimeTypeHeader.h"

#include "enter_hx_headers.h"
#include "ihxpckts.h" // IHXValues
#include "exit_hx_headers.h"

#include "hlxclib/string.h"
#include "hlxclib/stdlib.h"

CHXClientRequest::CHXClientRequest( const char* pURL, const char* pMimeType )
	: m_pRequestHeaders( NULL )
	, m_pResponseHeaders( NULL )
	, m_pUserContext( NULL )
	, m_pRequester( NULL )
	, m_pURL( NULL )
{
	( void ) SetURL( pURL );
	if ( pMimeType && *pMimeType )
	{
		IHXValues* pIHeader = new CHXMimeTypeHeader( pMimeType );
		if ( pIHeader )
		{
			pIHeader->AddRef();
			( void ) SetResponseHeaders( pIHeader );
			pIHeader->Release();
		}
	}
}

CHXClientRequest::~CHXClientRequest( void )
{
	if ( m_pURL )
	{
		free( m_pURL );
	}
	if ( m_pRequester )
	{
		m_pRequester->Release();
	}
	if ( m_pUserContext )
	{
		m_pUserContext->Release();
	}
	if ( m_pResponseHeaders )
	{
		m_pResponseHeaders->Release();
	}
	if ( m_pRequestHeaders )
	{
		m_pRequestHeaders->Release();
	}
}

BEGIN_INTERFACE_LIST_NOCREATE( CHXClientRequest )
    INTERFACE_LIST_ENTRY_SIMPLE( IHXRequest )
    INTERFACE_LIST_ENTRY_SIMPLE( IHXRequestContext )
END_INTERFACE_LIST

STDMETHODIMP
CHXClientRequest::SetRequestHeaders( IHXValues* pRequestHeaders )
{
	if ( !pRequestHeaders ) return HXR_INVALID_PARAMETER;
	if ( m_pRequestHeaders == pRequestHeaders ) return HXR_OK;
	
	if ( m_pRequestHeaders )
	{
		m_pRequestHeaders->Release();
	}
	m_pRequestHeaders = pRequestHeaders;
	m_pRequestHeaders->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::GetRequestHeaders( REF( IHXValues* ) pRequestHeaders )
{
	if ( !m_pRequestHeaders ) return HXR_FAIL;
	
	pRequestHeaders = m_pRequestHeaders;
	pRequestHeaders->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::SetResponseHeaders( IHXValues* pResponseHeaders )
{
	if ( !pResponseHeaders ) return HXR_INVALID_PARAMETER;
	if ( m_pResponseHeaders == pResponseHeaders ) return HXR_OK;
	
	if ( m_pResponseHeaders )
	{
		m_pResponseHeaders->Release();
	}
	m_pResponseHeaders = pResponseHeaders;
	m_pResponseHeaders->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::GetResponseHeaders( REF( IHXValues* ) pResponseHeaders )
{
	if ( !m_pResponseHeaders ) return HXR_FAIL;
	
	pResponseHeaders = m_pResponseHeaders;
	pResponseHeaders->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::SetURL( const char* pURL )
{
	if ( !pURL || !*pURL ) return HXR_INVALID_PARAMETER;
	if ( m_pURL )
	{
		free( m_pURL );
		m_pURL = NULL;
	}
	m_pURL = ( char* ) malloc( strlen( pURL ) + 1 );
	if ( !m_pURL ) return HXR_OUTOFMEMORY;
	
	strcpy( m_pURL, pURL );
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::GetURL( REF( const char* ) pURL )
{
	if ( !m_pURL ) return HXR_FAIL;
	
	pURL = m_pURL;
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::SetUserContext( IUnknown* pIUnknownNewContext )
{
	if ( !pIUnknownNewContext ) return HXR_INVALID_PARAMETER;
	if ( m_pUserContext == pIUnknownNewContext ) return HXR_OK;
	
	if ( m_pUserContext )
	{
		m_pUserContext->Release();
	}
	m_pUserContext = pIUnknownNewContext;
	m_pUserContext->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::GetUserContext( REF( IUnknown* ) pIUnknownCurrentContext )
{
	if ( !m_pUserContext ) return HXR_FAIL;
	
	pIUnknownCurrentContext = m_pUserContext;
	pIUnknownCurrentContext->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::SetRequester( IUnknown* pIUnknownNewRequester )
{
	if ( !pIUnknownNewRequester ) return HXR_INVALID_PARAMETER;
	if ( m_pRequester == pIUnknownNewRequester ) return HXR_OK;
	
	if ( m_pRequester )
	{
		m_pRequester->Release();
	}
	m_pRequester = pIUnknownNewRequester;
	m_pRequester->AddRef();
	return HXR_OK;
}

STDMETHODIMP
CHXClientRequest::GetRequester( REF( IUnknown* ) pIUnknownCurrentRequester )
{
	if ( !m_pRequester ) return HXR_FAIL;
	
	pIUnknownCurrentRequester = m_pRequester;
	pIUnknownCurrentRequester->AddRef();
	return HXR_OK;
}

