/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxdefpackethookhlp.cpp,v 1.2.36.3 2004/07/09 01:48:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/****************************************************************************
 *
 *
 *  Default IHXPacketHookHelper implementation:
 *  passing timestamp corrected packets to the
 *  response interface.
 *
 *
 */

#include "hxdefpackethookhlp.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE
static const char HX_THIS_FILE[] = __FILE__;
#endif


// IUnknown interface listing
BEGIN_INTERFACE_LIST(CHXDefaultPacketHookHelper)
    INTERFACE_LIST_ENTRY_SIMPLE(IHXPacketHookHelper)
    INTERFACE_LIST_ENTRY_SIMPLE(IHXDefaultPacketHookHelper)
END_INTERFACE_LIST


CHXDefaultPacketHookHelper::CHXDefaultPacketHookHelper() :
    m_pCommonClassFactory(NULL),
    m_pPacketHookHelperResponse(NULL),
    m_pRecordTimeline(0),
    m_bStartPosSet(FALSE)
{
}

CHXDefaultPacketHookHelper::~CHXDefaultPacketHookHelper()
{
}

STDMETHODIMP
CHXDefaultPacketHookHelper::Initialize(IUnknown* pContext)
{
    HX_RESULT retVal = HXR_OK;

    if(pContext)
    {
	HX_RELEASE(m_pCommonClassFactory);
        retVal = pContext->QueryInterface(IID_IHXCommonClassFactory, (void**)&m_pCommonClassFactory);
    }

    return HXR_OK;
}

STDMETHODIMP
CHXDefaultPacketHookHelper::Terminate()
{
    HX_RELEASE(m_pCommonClassFactory);
    HX_RELEASE(m_pPacketHookHelperResponse);
    HX_RELEASE(m_pRecordTimeline);

    return HXR_OK;
}


STDMETHODIMP
CHXDefaultPacketHookHelper::OnPacket(IHXPacket* pPacket)
{
    HX_RESULT nResult = HXR_OK;

    if(m_pPacketHookHelperResponse && pPacket)
    {
	if(!m_bStartPosSet && m_pRecordTimeline)
	{
	    m_bStartPosSet = TRUE;
	    m_pRecordTimeline->SetRecordStartPos(pPacket->GetTime());
	}

	IHXPacket*  pPacketRecorded = NULL;
	if(m_pCommonClassFactory)
	    m_pCommonClassFactory->CreateInstance(IID_IHXPacket, (void**)&pPacketRecorded);
	if(pPacketRecorded)
	{
	    IHXBuffer* pBuffer = pPacket->GetBuffer();

	    pPacketRecorded->Set(pBuffer,
			     m_pRecordTimeline ? m_pRecordTimeline->GetRecordPos(pPacket->GetTime()) : pPacket->GetTime(),
			     pPacket->GetStreamNumber(),
			     pPacket->GetASMFlags(),
			     pPacket->GetASMRuleNumber());

	    nResult = m_pPacketHookHelperResponse->OnPacket(pPacketRecorded);

	    HX_RELEASE(pBuffer); 
	}

	HX_RELEASE(pPacketRecorded);
    }

    return nResult;
}

STDMETHODIMP
CHXDefaultPacketHookHelper::OnEndOfPackets()
{
    HX_RESULT nResult = HXR_FAILED;

    if(m_pPacketHookHelperResponse)
	nResult = m_pPacketHookHelperResponse->OnEndOfPackets();

    return nResult;
}

STDMETHODIMP
CHXDefaultPacketHookHelper::StartHook(ULONG32 ulStreamNumber, ULONG32 ulTimeOffset,
				     IHXPacketHookHelperResponse* pPacketHookHelperResponse)
{
    m_pPacketHookHelperResponse = pPacketHookHelperResponse;
    if(m_pPacketHookHelperResponse)
    {
	m_pPacketHookHelperResponse->AddRef();
	m_pPacketHookHelperResponse->QueryInterface(IID_IHXRecordTimeline, (void**)&m_pRecordTimeline);
    }

    return HXR_OK;
}

STDMETHODIMP
CHXDefaultPacketHookHelper::StopHook()
{
    HX_RELEASE(m_pPacketHookHelperResponse);
    HX_RELEASE(m_pRecordTimeline);
    m_bStartPosSet = FALSE;

    return HXR_OK;
}

