/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlelem.cpp,v 1.1.22.1 2004/07/09 01:57:38 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "hxtypes.h"
#include "hxresult.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "ihxpckts.h"
#include "hxfiles.h"
#include "hxformt.h"
#include "hxengin.h"
#include "hxplugn.h"
#include "hxpends.h"
#include "hxasm.h"
#include "hxassert.h"
#include "chxpckts.h"
#include "nptime.h"
#include "smpte.h"
#include "debug.h"
#include "hxstrutl.h"
#include "hxstring.h"
#include "cbqueue.h"
#include "hxslist.h"
#include "hxmap.h"
#include "hxstack.h"
#include "hxwintyp.h"
#include "chxxtype.h"

#include "hxxml.h"
#include "hxxmlprs.h"
#include "xmlreslt.h"

#include "looseprs.h"

#include "sm1parse.h"
#include "sm1time.h"
#include "sm1elem.h"

#include "debugout.h"
 
/*
 * CSmil1Element methods
 */

CSmil1Element::CSmil1Element(SMIL1Node* pNode):
    m_pNode(pNode),
    m_ulDelay((UINT32)-1),
    m_ulBeginOffset((UINT32)-1),
    m_ulClipBegin((UINT32)-1),
    m_ulClipEnd((UINT32)-1),
    m_ulDuration((UINT32)-1),
    m_ulMaxDuration((UINT32)-1),
    m_ulEndOffset((UINT32)-1),
    m_ulEndSync((UINT32)-1),
    m_ulRepeatValue(1),
    m_ulTimestamp(0),
    m_bInsertedIntoTimeline(FALSE),
    m_bIndefiniteDuration(FALSE),
    m_nBeginEventSourceTag(SMILEventSourceNone),
    m_nEndEventSourceTag(SMILEventSourceNone),
    m_nEndsyncEventSourceTag(SMILEventSourceNone),
    m_pHandler(0),
    m_pTimelineElement(NULL)
{
    m_pHyperlinks = new CHXSimpleList;
}

CSmil1Element::~CSmil1Element()
{
    HX_DELETE(m_pHyperlinks);
    HX_DELETE(m_pTimelineElement);
}

void
CSmil1Element::addDuration(UINT32 ulDuration)
{
    // default add duration just attempts to add it to it's parent
    m_ulDuration = ulDuration;
    if(m_pNode->m_pParent && m_pNode->m_pParent->m_pElement)
    {
	m_pNode->m_pParent->m_pElement->addDuration(m_ulDuration);
    }
}

void
CSmil1Element::addElement(CSmil1Element* pElement,
    UINT32& ulBeginOffset, UINT32& ulDuration)
{
}


/*
 * CSmil1RootLayout methods
 */
CSmil1RootLayout::CSmil1RootLayout(SMIL1Node* pNode):
    CSmil1Element(pNode),
    m_ulHeight(0),
    m_ulWidth(0),
    m_bWidthUnspecified(TRUE),
    m_bHeightUnspecified(TRUE),
    m_ulBgColor(0)
{
    m_overflow = "hidden";
}

CSmil1RootLayout::~CSmil1RootLayout()
{
}

HX_RESULT
CSmil1RootLayout::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleRootLayout(this);
    }
    return rc;
}


/*
 * CSmil1Region methods
 */

CSmil1Region::CSmil1Region(SMIL1Node* pNode):
    CSmil1Element(pNode),
    m_zIndex(0),
    m_ulBgColor(0),
    m_bBgColorSet(FALSE)
{
    m_fit = "hidden";
}

CSmil1Region::~CSmil1Region()
{
}

HX_RESULT
CSmil1Region::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleRegion(this);
    }
    return rc;
}

/*
 * CSmil1Meta methods
 */
CSmil1Meta::CSmil1Meta(SMIL1Node* pNode):
    CSmil1Element(pNode)
{
}

CSmil1Meta::~CSmil1Meta()
{
}

HX_RESULT
CSmil1Meta::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleMeta(this);
    }
    return rc;
}

/*
 * CSmil1RendererPreFetch methods
 */
CSmil1RendererPreFetch::CSmil1RendererPreFetch(SMIL1Node* pNode):
    CSmil1Element(pNode)
{
}

CSmil1RendererPreFetch::~CSmil1RendererPreFetch()
{
}

HX_RESULT
CSmil1RendererPreFetch::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleRendererPreFetch(this);
    }
    return rc;
}

/*
 * CSmil1EndLayout methods
 */
CSmil1EndLayout::CSmil1EndLayout():
    CSmil1Element(NULL)
{
}

CSmil1EndLayout::~CSmil1EndLayout()
{
}


HX_RESULT
CSmil1EndLayout::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleEndLayout(this);
    }
    return rc;
}

/*
 * CSmil1MetaValues methods
 */
CSmil1MetaValues::CSmil1MetaValues():
    CSmil1Element(NULL),
    m_pValues(0)
{
}

CSmil1MetaValues::~CSmil1MetaValues()
{
    HX_RELEASE(m_pValues);
}

/*
 * CSmil1Source methods
 */

CSmil1Source::CSmil1Source(SMIL1Node* pNode):
    CSmil1Element(pNode)
{
}

CSmil1Source::~CSmil1Source()
{
}

HX_RESULT
CSmil1Source::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleSource(this);
    }
    return rc;
}

void
CSmil1Source::setRange(const char* pRange)
{
    // parse smpte/npt ranges:
    //    smpte:12:03:14.21-12:15:26.03
    //	  npt:3:02.5-4:38.6
    //

    char* pPtr = (char *)strstr(pRange, "npt:");
    if(pPtr)
    {
	pPtr += 4;	// point to beginning of range
	char* pHyphen = (char *)strchr(pRange, '-');	// find '-'
	if(pHyphen > pPtr)
	{
	    NPTime beginTime((const char*)CHXString(pPtr, pHyphen-pPtr));
	    m_ulClipBegin = (UINT32)beginTime;
	    if(strlen(pHyphen+1) > 0)
	    {
		NPTime endTime((const char*)CHXString(pHyphen+1));
		m_ulClipEnd = (UINT32)endTime;
	    }
	}
	else if(pHyphen)
	{
	    NPTime endTime((const char*)CHXString(pHyphen+1));
	    m_ulClipEnd = (UINT32)endTime;
	}
    }
    else
    {
	pPtr = (char *)strstr(pRange, "smpte:");
	if(pPtr)
	{
	    pPtr += 6;	// point to beginning of range
	    char* pHyphen = (char *)strchr(pRange, '-');	// find '-'
	    if(pHyphen > pPtr)
	    {
		SMPTETimeCode beginTime = 
		    ((const char*)CHXString(pPtr, pHyphen-pPtr));
		m_ulClipBegin = (UINT32)beginTime;
		if(strlen(pHyphen+1) > 0)
		{
		    SMPTETimeCode endTime =
			((const char*)CHXString(pPtr, pHyphen-pPtr));
		    m_ulClipEnd = (UINT32)endTime;
		}
	    }
	    else if(pHyphen)
	    {
		SMPTETimeCode endTime((const char*)CHXString(pHyphen+1));
		m_ulClipEnd = (UINT32)endTime;
	    }
	}
    }
}

/*
 * CSmil1SourceUpdate methods
 */

CSmil1SourceUpdate::CSmil1SourceUpdate():
    CSmil1Element(NULL)
{
}

CSmil1SourceUpdate::~CSmil1SourceUpdate()
{
}

HX_RESULT
CSmil1SourceUpdate::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleSourceUpdate(this);
    }
    return rc;
}


/*
 * CSmil1ParElement methods
 */

CSmil1ParElement::CSmil1ParElement(SMIL1Node* pNode):
    CSmil1Element(pNode)
{
}

CSmil1ParElement::~CSmil1ParElement()
{
}

/*
 * CSmil1SeqElement methods
 */
CSmil1SeqElement::CSmil1SeqElement(SMIL1Node*  pNode):
    CSmil1Element(pNode)
{
}

CSmil1SeqElement::~CSmil1SeqElement()
{
}


/*
 * CSmil1AAnchor methods
 */

CSmil1AAnchorElement::CSmil1AAnchorElement(SMIL1Node* pNode):
    CSmil1Element(pNode),
    m_show("replace")
{
}

CSmil1AAnchorElement::~CSmil1AAnchorElement()
{
}

BOOL
CSmil1AAnchorElement::isCurrentLink(UINT32 ulTimeOffset, 
				   UINT32 ulXOffset, UINT32 ulYOffset,
				   HXxRect regionRect)
{
    BOOL rc = TRUE;

    // coords only - check for out of bounds region
    UINT32 ulRegionWidth = regionRect.right - regionRect.left;
    UINT32 ulRegionHeight = regionRect.bottom - regionRect.top;

    if(ulXOffset > ulRegionWidth ||
	ulYOffset > ulRegionHeight)
    {
	rc = FALSE;
    }

    if(m_href.GetLength() == 0)
    {
	rc = FALSE;
    }

    return rc;
}

void
CSmil1AAnchorElement::rescale(double dXScale, double dYScale,
			     BOOL bResetOriginalCoords)
{
    // nothing to do
}

void CSmil1AAnchorElement::rescaleAbsolute(double dXScale, double dYScale)
{
    // nothing to do
}

/*
 * CSmil1Anchor methods
 */

CSmil1AnchorElement::CSmil1AnchorElement(SMIL1Node* pNode):
    CSmil1AAnchorElement(pNode),
    m_zIndex(0),
    m_bTimeValueSet(FALSE),
    m_bCoordsSet(FALSE),
    m_ulLeftX(0),
    m_ulOriginalLeftX(0),
    m_bLeftXIsPercent(FALSE),
    m_ulTopY(0),
    m_ulOriginalTopY(0),
    m_bTopYIsPercent(FALSE),
    m_ulRightX((UINT32)-1),
    m_ulOriginalRightX((UINT32)-1),
    m_bRightXIsPercent(FALSE),
    m_ulBottomY((UINT32)-1),
    m_ulOriginalBottomY((UINT32)-1),
    m_bBottomYIsPercent(FALSE)
{
}

CSmil1AnchorElement::~CSmil1AnchorElement()
{
}

void
CSmil1AnchorElement::rescale(double dXScale, double dYScale,
			     BOOL bResetOriginalCoords)
{
    if(bResetOriginalCoords)
    {
	m_ulLeftX = m_ulOriginalLeftX;
	m_ulRightX = m_ulOriginalRightX;
	m_ulTopY = m_ulOriginalTopY;
	m_ulBottomY = m_ulOriginalBottomY;
    }
    else
    {
	if(!m_bLeftXIsPercent)
	{
	    m_ulLeftX = (UINT32)(dXScale * (double)m_ulLeftX);
	}
	if(!m_bRightXIsPercent)
	{
	    m_ulRightX = (UINT32)(dXScale * (double)m_ulRightX);
	}
	if(!m_bTopYIsPercent)
	{
	    m_ulTopY = (UINT32)(dYScale * (double)m_ulTopY);
	}
	if(!m_bBottomYIsPercent)
	{
	    m_ulBottomY = (UINT32)(dYScale * (double)m_ulBottomY);
	}
    }
}

void CSmil1AnchorElement::rescaleAbsolute(double dXScale, double dYScale)
{
    if(!m_bLeftXIsPercent)
    {
        m_ulLeftX   = (UINT32) (dXScale * ((double) m_ulOriginalLeftX) + 0.5);
    }
    if(!m_bRightXIsPercent)
    {
        m_ulRightX  = (UINT32) (dXScale * ((double) m_ulOriginalRightX) + 0.5);
    }
    if(!m_bTopYIsPercent)
    {
        m_ulTopY    = (UINT32) (dYScale * ((double) m_ulOriginalTopY) + 0.5);
    }
    if(!m_bBottomYIsPercent)
    {
        m_ulBottomY = (UINT32) (dYScale * ((double) m_ulOriginalBottomY) + 0.5);
    }
}

BOOL
CSmil1AnchorElement::isCurrentLink(UINT32 ulTimeOffset, 
				   UINT32 ulXOffset, UINT32 ulYOffset,
				   HXxRect regionRect)
{
    UINT32 ulRegionWidth = regionRect.right - regionRect.left;
    UINT32 ulRegionHeight = regionRect.bottom - regionRect.top;

    if(m_href.GetLength() == 0)
    {
	return FALSE;
    }

    // first check time offset
    if(m_bTimeValueSet)
    {
	BOOL bTimeOffsetValid = FALSE;
	BOOL bValidBegin = m_ulBeginOffset != (UINT32)-1;
	BOOL bValidEnd = m_ulEndOffset != (UINT32)-1;
	//[SMIL 1.0 compliance] the following variable and its use, below,
	// helps fix PR 26471.  We may have had only our delay set:
	BOOL bValidDelay = m_ulDelay != (UINT32)-1;

	if(bValidBegin  ||  bValidDelay)
	{
	    if(ulTimeOffset >= (bValidBegin?m_ulBeginOffset:m_ulDelay) )
	    {
		if(bValidEnd)
		{
		    if(ulTimeOffset <= m_ulEndOffset)
		    {
			bTimeOffsetValid = TRUE;
		    }
		}
		else
		{
		    bTimeOffsetValid = TRUE;
		}
	    }
	}
	else if(bValidEnd)
	{
	    if(ulTimeOffset <= m_ulEndOffset)
	    {
		bTimeOffsetValid = TRUE;
	    }
	}

	if(!bTimeOffsetValid)
	{
	    return FALSE;
	}
    }

    if(m_bCoordsSet)
    {
	UINT32 ulLeftX = m_ulLeftX;
	UINT32 ulRightX = m_ulRightX;
	UINT32 ulTopY = m_ulTopY;
	UINT32 ulBottomY = m_ulBottomY;


	// normalize to pixel coords
	if(m_bLeftXIsPercent)
	{
	    ulLeftX = (UINT32)(((double)m_ulLeftX/100.0) * ulRegionWidth);
	}
	if(m_bRightXIsPercent)
	{
	    ulRightX = (UINT32)(((double)m_ulRightX/100.0) * ulRegionWidth);
	}
	if(m_bTopYIsPercent)
	{
	    ulTopY = (UINT32)(((double)m_ulTopY/100.0) * ulRegionHeight);
	}
	if(m_bBottomYIsPercent)
	{
	    ulBottomY = (UINT32)(((double)m_ulBottomY/100.0) * ulRegionHeight);
	}

	if(ulXOffset >= ulLeftX &&
	   ulXOffset <= ulRightX &&
	   ulYOffset >= ulTopY &&
	   ulYOffset <= ulBottomY)
	{
	    return TRUE;
	}
	else
	{
	    return FALSE;
	}
    }
    else if(ulXOffset > ulRegionWidth ||
	    ulYOffset > ulRegionHeight)	    
    // assume time OK, coords OK if within bounds of region
    {
	return FALSE;
    }

    return TRUE;
}

/*
 * CSmil1AddGroup methods
 */

CSmil1AddGroup::CSmil1AddGroup():
    CSmil1Element(NULL),
    m_nGroup(0),
    m_pValues(NULL),
    m_nTotalTracks(0),
    m_nInitTracks(0),
    m_ulDuration((UINT32)-1)
{
}

CSmil1AddGroup::~CSmil1AddGroup()
{
    HX_RELEASE(m_pValues);
}

HX_RESULT
CSmil1AddGroup::handleElement()
{
    HX_RESULT rc = HXR_OK;
    if(m_pHandler)
    {
	rc = m_pHandler->handleAddGroup(this);
    }
    return rc;
}
