/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: commonapp.h,v 1.15.2.8 2004/11/24 23:00:23 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _COMMON_APP_H_
#define _COMMON_APP_H_

/* This file contains private data structures common to the player, plugin,
   and callbacks */

#include <gtk/gtk.h>

#include "hxplayer.h"
#include "libgladeemu.h"

G_BEGIN_DECLS

/* This is the config file used by the helix player */
#ifdef HELIX_FEATURE_REAL_BRANDING
#  define HXPLAYER_RC ".realplayerrc"
#else
#  define HXPLAYER_RC ".hxplayerrc"
#endif

typedef struct
{
    /* Application paths */
    gchar* package_data_dir;
    gchar* package;

    gboolean is_embedded;
    gchar* web_browser_command;

    gboolean restart_on_quit;
    gboolean save_preferences;
} HXCommonApp;

typedef struct
{
    // Used to control an active hxwindow window from
    // the command line
    gboolean is_remote_command;
    gboolean run_embedded;
    int command_fd;
    int callbacks_fd;
    const gchar* location;
    gboolean fullscreen;
    gboolean quit_on_done;
    gboolean open_in_new_player;
} HXCommandLineOptions;

typedef struct _HXMainWindow HXMainWindow;

extern HXCommonApp g_hxcommon_app;

gboolean   hxcommon_url_show                    (const gchar* url);
gchar*     hxcommon_locate_file                 (const gchar* file_name);
gchar*     hxcommon_get_rel_app_path            (const gchar* path);
GtkWidget* hxcommon_get_toplevel_widget_no_menus(GtkWidget*   widget);
void       hxcommon_set_context_menu_ui         (GladeXML*    xml,
                                                 HXPlayer*    player);
gchar*     hxcommon_strtrim                     (gchar*       str);
gchar*     hxcommon_strdup_trim                 (const gchar* str);
gchar*     hxcommon_get_title_from_url          (const gchar* url);
gchar*     hxcommon_escape_underscores          (const gchar* group_title);
guint      hxcommon_get_update_interval         (GtkRange*    range,
                                                 HXPlayer*    player);
void       hxcommon_close_dialog                (GtkWidget* dialog,
                                                 gint response,
                                                 gpointer* data_ptr);

void       hxcommon_show_status_in_player_widget(HXPlayer* player);

void       hxcommon_embedded_transient_parent_realized (GtkWidget *dialog,
                                                        GdkWindow *parent);

GdkPixmap* hxcommon_get_logo_pixmap             (GtkWidget*   player,
                                                 GdkWindow*   win);

/* Modal dialogs. When both win_parent and embedded_parent are present,
   only one will be non-NULL, depending on whether the dialog is being
   launched from the embedded or main player. */
void       hxcommon_run_authentication_dialog   (GtkWindow*   win_parent,
                                                 GdkWindow*   embedded_parent,
                                                 HXPlayer*    player,
                                                 const gchar* server_proxy,
                                                 const gchar* realm,
                                                 gboolean     is_proxy_server);

void       hxcommon_run_error_dialog            (GtkWindow*   win_parent,
                                                 GdkWindow*   embedded_parent,
                                                 guint        hxcode,
                                                 guint        user_code,
                                                 const gchar* error_string,
                                                 const gchar* user_string,
                                                 const gchar* more_info_url);

void       hxcommon_run_request_upgrade_dialog  (GtkWindow*   win_parent,
                                                 GdkWindow*   embedded_parent,
                                                 const gchar* url,
                                                 GList*       components_list,
                                                 gboolean     blocking);

#ifdef HELIX_FEATURE_RP_SIGN_IN
void       hxcommon_run_sign_in_dialog          (GtkWindow*   parent,
                                                 HXPlayer*    player);
#endif

gboolean   hxcommon_player_has_feature (GtkWidget*   player,
                                        const gchar* feature);


/* XXXRGG: Our config file stuff needs some work... */
gboolean   hxcommon_channel_write               (GIOChannel*   chan,
                                                 const gchar*  data);
void       hxcommon_save_preferences            (HXMainWindow* window);
void       hxcommon_load_preferences            (HXMainWindow* window);
void       hxcommon_launch_context_help         (const gchar*  context);
void       hxcommon_launch_error_help_with_widget_name  (GtkWidget*    widget);
void       hxcommon_launch_context_help_with_widget_name(GtkWidget* widget);
void       hxcommon_launch_upgrade_with_widget_name     (GtkWidget* widget);
void       hxcommon_reset_player                (void);

/* Also see gnome_vfs_escape_string && gnome_vfs_unescape_string */
gchar*     hxcommon_strdup_and_escape_url        (const gchar* src_str);
gchar*     hxcommon_strdup_and_unescape_url      (const gchar* src_str);

G_CONST_RETURN gchar* hxcommon_get_gettext_language (void);
G_CONST_RETURN gchar* hxcommon_get_distcode_language (void);

/* This is a handler for realize. Normally, we'd set the transient's parent
   with gtk_window_set_transient_for, which requires
   a GtkWindow. We don't necessarily have a GtkWindow to work with in
   the embedded player (mozilla plugin), so we use the gdk variant
   instead for the common dialogs. We call gdk_window_set_transient_for in
   this handler. */
void hxcommon_transient_parent_realized (GtkWidget *dialog,
                                         GdkWindow *parent);
G_END_DECLS

#endif // USE_LIBGLADE

