# 
# ***** BEGIN LICENSE BLOCK *****
# Source last modified: $Id: testdriver.py,v 1.2 2006/03/22 01:08:31 jfinnecy Exp $
# 
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s):
# 
# ***** END LICENSE BLOCK *****
# 
"""Command-line tool to run a unit test module."""
# This could be expanded to run everything in the build system, since path
# setup, etc. is all pretty common. There is something similar already for
# running the cgi scripts behind the build farm interface.
import os
import sys

try:
    module = sys.argv[1]
except IndexError:
    print 'Usage: testdriver.py <test module>'
    sys.exit(1)

try:
    buildRoot = os.environ['BUILD_ROOT']
except:
    print 'Please set BUILD_ROOT.'
    sys.exit(1)

# Set up import paths.    
sys.path.insert( 0, os.path.join( os.environ.get('BUILD_ROOT') , 'test', 'lib' ) )
sys.path.insert( 0, os.path.join( os.environ.get('BUILD_ROOT') , 'lib' ) )

import testlib

# Set up logging and squelch the screen prints so that we can see the unittest 
# output more easily.
import log
log.initLogging( os.path.join( testlib.testRoot, 'logs' ) , module )
def squelch(msg):
    pass    
log.setCallback( squelch )

testlib.runTest( module )
