/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxffcmgr.cpp,v 1.1.26.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxplugn.h"
#include "ihxpckts.h"

// hxcont
#include "hxslist.h"
#include "hxmap.h"

// hxmisc
#include "unkimp.h"
#include "baseobj.h"

// pxcomlib
#include "pxcmpmgr.h"
#include "pxffmcod.h"
#include "pxffcmgr.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

BEGIN_INTERFACE_LIST(PXFileFormatCodecManager)
END_INTERFACE_LIST

PXFileFormatCodecManager::PXFileFormatCodecManager()
{
}

PXFileFormatCodecManager::~PXFileFormatCodecManager()
{
}

BOOL PXFileFormatCodecManager::IsCodecPresent(const char* pszFileMime,
                                              const char* pszFileName,
                                              IHXBuffer* pBuffer)
{
    BOOL bRet = FALSE;

    IHXRealPixFileFormatCodec* pCodec = NULL;
    HX_RESULT                   retVal = GetCodec(pszFileMime, pszFileName,
                                                  pBuffer, pCodec);
    if (SUCCEEDED(retVal))
    {
        bRet = TRUE;
    }
    HX_RELEASE(pCodec);

    return bRet;
}

HX_RESULT PXFileFormatCodecManager::GetCodec(const char*                      pszFileMime,
                                             const char*                      pszFileName,
                                             IHXBuffer*                      pBuffer,
                                             REF(IHXRealPixFileFormatCodec*) rpCodec)
{
    HX_RESULT retVal = HXR_FAIL;

    // Try and get the codec from the file mime type (i.e. - "image/gif")
    if (pszFileMime)
    {
        retVal = GetCodecFromFileMimeType(pszFileMime, rpCodec);
    }
    // Try and get the codec from the file name (i.e. - "foo.gif")
    if (FAILED(retVal) && pszFileName)
    {
        retVal = GetCodecFromFileExtension(pszFileName, rpCodec);
    }
    // Try and get the codec from the actual file content
    if (FAILED(retVal) && pBuffer)
    {
        retVal = GetCodecFromContent(pBuffer, rpCodec);
    }

    return retVal;
}

HX_RESULT PXFileFormatCodecManager::GetID(IUnknown* pComponent, REF(const char*) rpszID)
{
    HX_RESULT retVal = HXR_FAIL;

    if (pComponent)
    {
        IHXRealPixFileFormatCodec* pCodec = NULL;
        retVal = pComponent->QueryInterface(IID_IHXRealPixFileFormatCodec,
                                            (void**) &pCodec);
        if (SUCCEEDED(retVal))
        {
            const char** ppFileExt   = NULL;
            const char** ppFileMime  = NULL;
            UINT32       ulStreamVer = 0;
            UINT32       ulMaxPerImg = 0;
            UINT32       ulMaxPerPck = 0;
            retVal                   = pCodec->GetFileFormatCodecInfo(ppFileExt,
                                                                      ppFileMime,
                                                                      rpszID,
                                                                      ulStreamVer,
                                                                      ulMaxPerImg,
                                                                      ulMaxPerPck);
        }
        HX_RELEASE(pCodec);
    }

    return retVal;
}

HX_RESULT PXFileFormatCodecManager::GetCodecFromFileMimeType(const char*                      pszFileMime,
                                                             REF(IHXRealPixFileFormatCodec*) rpCodec)
{
    BOOL bFound = FALSE;

    if (pszFileMime)
    {
        if (m_pComponentList)
        {
            LISTPOSITION pos = m_pComponentList->GetHeadPosition();
            while (pos)
            {
                IUnknown* pComponent = (IUnknown*) m_pComponentList->GetNext(pos);
                if (pComponent)
                {
                    IHXRealPixFileFormatCodec* pCodec = NULL;
                    pComponent->QueryInterface(IID_IHXRealPixFileFormatCodec,
                                               (void**) &pCodec);
                    if (pCodec)
                    {
                        const char** ppszFileExt   = NULL;
                        const char** ppszFileMime  = NULL;
                        const char*  pszStreamMime = NULL;
                        UINT32       ulStreamVer   = 0;
                        UINT32       ulMaxPerImg   = 0;
                        UINT32       ulMaxPerPckt  = 0;
                        pCodec->GetFileFormatCodecInfo(ppszFileExt, ppszFileMime,
                                                       pszStreamMime, ulStreamVer,
                                                       ulMaxPerImg, ulMaxPerPckt);
                        if (ppszFileMime)
                        {
                            if (IsStringInArray(pszFileMime, ppszFileMime))
                            {
                                HX_RELEASE(rpCodec);
                                rpCodec = pCodec;
                                rpCodec->AddRef();
                                bFound = TRUE;
                            }
                        }
                    }
                    HX_RELEASE(pCodec);
                }

                if (bFound)
                {
                    break;
                }
            }
        }
    }
    
    return (bFound ? HXR_OK : HXR_FAIL);
}

HX_RESULT PXFileFormatCodecManager::GetCodecFromFileExtension(const char*                      pszFileName,
                                                              REF(IHXRealPixFileFormatCodec*) rpCodec)
{
    BOOL bFound = FALSE;

    if (pszFileName)
    {
        // Get the file extension from the file name
        CHXString cExt(pszFileName);
        INT32 lQMark = cExt.Find('?');
        if (lQMark >= 0)
        {
            cExt = cExt.Left(lQMark);
        }
        INT32 lPeriod = cExt.ReverseFind('.');
        if (lPeriod >= 0)
        {
            cExt = cExt.Right(cExt.GetLength() - lPeriod - 1);
            cExt.MakeLower();
        }

        if (cExt.GetLength() > 0)
        {
            if (m_pComponentList)
            {
                LISTPOSITION pos = m_pComponentList->GetHeadPosition();
                while (pos)
                {
                    IUnknown* pComponent = (IUnknown*) m_pComponentList->GetNext(pos);
                    if (pComponent)
                    {
                        IHXRealPixFileFormatCodec* pCodec = NULL;
                        pComponent->QueryInterface(IID_IHXRealPixFileFormatCodec,
                                                   (void**) &pCodec);
                        if (pCodec)
                        {
                            const char** ppszFileExt   = NULL;
                            const char** ppszFileMime  = NULL;
                            const char*  pszStreamMime = NULL;
                            UINT32       ulStreamVer   = 0;
                            UINT32       ulMaxPerImg   = 0;
                            UINT32       ulMaxPerPckt  = 0;
                            pCodec->GetFileFormatCodecInfo(ppszFileExt, ppszFileMime,
                                                           pszStreamMime, ulStreamVer,
                                                           ulMaxPerImg, ulMaxPerPckt);
                            if (ppszFileExt)
                            {
                                if (IsStringInArray((const char*) cExt, ppszFileExt))
                                {
                                    HX_RELEASE(rpCodec);
                                    rpCodec = pCodec;
                                    rpCodec->AddRef();
                                    bFound  = TRUE;
                                }
                            }
                        }
                        HX_RELEASE(pCodec);
                    }

                    if (bFound)
                    {
                        break;
                    }
                }
            }
        }
    }
    
    return (bFound ? HXR_OK : HXR_FAIL);
}

HX_RESULT PXFileFormatCodecManager::GetCodecFromContent(IHXBuffer*                      pBuffer,
                                                        REF(IHXRealPixFileFormatCodec*) rpCodec)
{
    BOOL bFound = FALSE;

    if (pBuffer)
    {
        if (m_pComponentList)
        {
            LISTPOSITION pos = m_pComponentList->GetHeadPosition();
            while (pos)
            {
                IUnknown* pComponent = (IUnknown*) m_pComponentList->GetNext(pos);
                if (pComponent)
                {
                    IHXRealPixFileFormatCodec* pCodec = NULL;
                    pComponent->QueryInterface(IID_IHXRealPixFileFormatCodec,
                                               (void**) &pCodec);
                    if (pCodec)
                    {
                        if (pCodec->ValidInputData(pBuffer))
                        {
                            HX_RELEASE(rpCodec);
                            rpCodec = pCodec;
                            rpCodec->AddRef();
                            bFound  = TRUE;
                        }
                    }
                    HX_RELEASE(pCodec);
                }

                if (bFound)
                {
                    break;
                }
            }
        }
    }
    
    return (bFound ? HXR_OK : HXR_FAIL);
}

BOOL PXFileFormatCodecManager::IsStringInArray(const char*  pszStr,
                                               const char** ppszStrArr)
{
    BOOL bMatch = FALSE;

    if (pszStr && ppszStrArr)
    {
        while (*ppszStrArr)
        {
            if (!strcmp(pszStr, *ppszStrArr))
            {
                bMatch = TRUE;
                break;
            }
            ppszStrArr++;
        }
    }

    return bMatch;
}

