/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxgvalue.h,v 1.1.10.3 2004/07/09 01:48:31 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __HXVALUE_H__
#define __HXVALUE_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Why hxprefvalue.h instead of hxvalue.h or ghxvalue.h? hxvalue.h is used
   by the core, and ghxvalue.h wasn't popular as it infringed on the glib
   namespace */

/* These structs and enums are identical to their counterparts
   in GConf, and are thus interchangeable */
typedef enum {
    HX_VALUE_INVALID,
    HX_VALUE_STRING,
    HX_VALUE_INT,
    HX_VALUE_FLOAT,
    HX_VALUE_BOOL,

    /* The following are not supported */
    HX_VALUE_SCHEMA,
    HX_VALUE_LIST,
    HX_VALUE_PAIR
} HXValueType; /* Similar to GConfValueType */
    
typedef struct 
{
    HXValueType type;
    union {
        gchar* string_data;
        gint int_data;
        gboolean bool_data;
        gdouble float_data;
    } d;

} HXValue; /* Similar to GConfValue */
    
typedef struct 
{
    const char* key;
    HXValue* value;
} HXEntry; /* Similar to GConfEntry */

/* Again, these functions are interchangable with their gconf counterparts */
HXValue* hx_value_new   (HXValueType type);
HXValue* hx_value_copy  (const HXValue *value);
void     hx_value_free  (HXValue *value);

G_CONST_RETURN gchar* hx_value_get_string(const HXValue* value);
gint                  hx_value_get_int   (const HXValue* value);
gdouble               hx_value_get_float (const HXValue* value);
gboolean              hx_value_get_bool  (const HXValue* value);

void hx_value_set_string           (HXValue* value,
                                    const gchar* s);
void hx_value_set_string_nocopy    (HXValue* value,
                                    gchar* s);
void hx_value_set_int              (HXValue* value,
                                    gint i);
void hx_value_set_float            (HXValue* value,
                                    gdouble f);
void hx_value_set_bool             (HXValue* value,
                                    gboolean b);

G_CONST_RETURN gchar* hx_entry_get_key  (const HXEntry* entry); 
HXValue*              hx_entry_get_value(const HXEntry* entry);
                                                                                
HXEntry* hx_entry_new                (const gchar* key,
                                      HXValue*    val);
HXEntry* hx_entry_new_from_string_nocopy(const gchar* key,
                                      const gchar* val);
HXEntry* hx_entry_new_nocopy         (const gchar* key,
                                      HXValue*    val);
HXEntry* hx_entry_copy               (const HXEntry* entry);
void     hx_entry_free               (HXEntry* entry);
void     hx_entry_set_value          (HXEntry* entry,
                                      HXValue* val);
void     hx_entry_set_value_nocopy   (HXEntry* entry,
                                      HXValue* val);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
