/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatustacctrl.cpp,v 1.15.2.5 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxstatustacctrl.h"

#include "hxplayer.h"
#include "clipdetails.h"

#include <string.h>

#include "hxplayer-i18n.h"

#define TAC_CLIP_INFO_ROTATE_INTERVAL 5 /* in seconds */

static void hxstatus_display_tac_ctrl_class_init (HXStatusDisplayTACCtrlClass* klass);
static void hxstatus_display_tac_ctrl_init       (HXStatusDisplayTACCtrl* status,
                                                  HXStatusDisplayTACCtrlClass* klass);

static void hxstatus_display_tac_ctrl_set_player (HXStatusDisplay* status,
                                                  HXPlayer* player);

static void hxstatus_display_tac_ctrl_rotate     (HXStatusDisplayTACCtrl* tac_ctrl);

static HXStatusDisplayClass* g_parent_class = NULL;

GType
hxstatus_display_tac_ctrl_get_type (void)
{
    static GType hxstatus_display_tac_ctrl_type = 0;

    if (!hxstatus_display_tac_ctrl_type)
    {
	static const GTypeInfo hxstatus_display_tac_ctrl_info =
	    {
		sizeof (HXStatusDisplayTACCtrlClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) hxstatus_display_tac_ctrl_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (HXStatusDisplayTACCtrl),
		0,		/* n_preallocs */
		(GInstanceInitFunc) hxstatus_display_tac_ctrl_init,
		NULL,           /* value_table */
	    };

	hxstatus_display_tac_ctrl_type = g_type_register_static (HX_TYPE_STATUS_DISPLAY, "HXStatusDisplayTACCtrl",
                                                                 &hxstatus_display_tac_ctrl_info, (GTypeFlags)0);
    }

    return hxstatus_display_tac_ctrl_type;
}


static void
hxstatus_display_tac_ctrl_class_init (HXStatusDisplayTACCtrlClass* klass)
{        
    HXStatusDisplayClass* status_class = HX_STATUS_DISPLAY_CLASS(klass);
    g_parent_class = (HXStatusDisplayClass*)g_type_class_peek_parent (klass);

    status_class->set_player = hxstatus_display_tac_ctrl_set_player;
}

static void
hxstatus_display_tac_ctrl_init(HXStatusDisplayTACCtrl* status, HXStatusDisplayTACCtrlClass* /* klass */)
{
    status->tac_entry = NULL;
    status->tac_scroll_button = NULL;
    status->tac_info_button = NULL;
    status->clip_details_dialog = NULL;
    status->play_signal_handler = -1;
}

static void
hxstatus_display_tac_ctrl_show_clip_details_dialog(HXStatusDisplayTACCtrl* status_tac)
{
    HXStatusDisplay* status = HX_STATUS_DISPLAY(status_tac);
    GtkWidget* widget = GTK_WIDGET(status_tac);

    if(!status_tac->clip_details_dialog)
    {
        status_tac->clip_details_dialog = hxplay_clip_details_dialog_new (status->player);
        if(status_tac->clip_details_dialog)
        {
            g_signal_connect (G_OBJECT (status_tac->clip_details_dialog),
                              "realize",
                              G_CALLBACK (hxcommon_embedded_transient_parent_realized),
                              widget->window);

            g_signal_connect_after(G_OBJECT(status_tac->clip_details_dialog),
                                   "response",
                                   G_CALLBACK(hxcommon_close_dialog),
                                   &status_tac->clip_details_dialog);
        }
    }

    if(status_tac->clip_details_dialog)
    {
        gtk_widget_show_all(GTK_WIDGET(status_tac->clip_details_dialog));
    }
}

static void
hxstatus_display_tac_ctrl_set_button_size(HXStatusDisplayTACCtrl* status,
                                          GtkAllocation *allocation)
{
    /* Apply the size of the scroll button to the info button */
    gtk_widget_set_size_request(status->tac_info_button, allocation->width, allocation->height);
}

/* A callback to gtk_timeout_add() */
static gboolean
hxstatus_display_tac_ctrl_rotate_timer_callback(gpointer user_data)
{
    HXStatusDisplayTACCtrl* tac_ctrl = HX_STATUS_DISPLAY_TAC_CTRL(user_data);

    hxstatus_display_tac_ctrl_rotate(tac_ctrl);
        
    return FALSE; // timer is re-added in hxstatus_display_tac_ctrl_rotate
}

GtkWidget*
hxstatus_display_tac_ctrl_new(void)
{
    GtkWidget* hbox;
    GtkWidget* scroll_hbox; /* entry + scroll button */
    GtkWidget* scroll_alignment;
    GtkWidget* info_button_alignment;    
    GtkWidget* image;
    GtkWidget* label;    
    gchar* filename;
    GValue value;

    HXStatusDisplayTACCtrl* status = (HXStatusDisplayTACCtrl*)g_object_new(HX_TYPE_STATUS_DISPLAY_TAC_CTRL, NULL);

    label = gtk_label_new(_("Clip Info: "));    

    status->tac_entry = gtk_entry_new();
    gtk_editable_set_editable(GTK_EDITABLE(status->tac_entry), FALSE);

    memset(&value, 0, sizeof(value));
    g_value_init(&value, G_TYPE_BOOLEAN);
    g_value_set_boolean(&value, FALSE);
    g_object_set_property(G_OBJECT(status->tac_entry), "can_focus", &value);
    g_value_unset(&value);
    
    status->tac_scroll_button = gtk_button_new();    
    filename = hxcommon_locate_file("tactoggle.png");
    image = gtk_image_new_from_file(filename);
    g_free(filename);
    gtk_container_add(GTK_CONTAINER(status->tac_scroll_button), image);

    g_signal_connect_swapped(G_OBJECT(status->tac_scroll_button),
                             "clicked",
                             GTK_SIGNAL_FUNC(hxstatus_display_tac_ctrl_rotate),
                             (gpointer)status);
    
    status->tac_info_button = gtk_button_new();    
    filename = hxcommon_locate_file("clipinfo.png");
    image = gtk_image_new_from_file(filename);
    g_free(filename);
    gtk_container_add(GTK_CONTAINER(status->tac_info_button), image);

    g_signal_connect_swapped(G_OBJECT(status->tac_info_button),
                             "clicked",
                             GTK_SIGNAL_FUNC(hxstatus_display_tac_ctrl_show_clip_details_dialog),
                             (gpointer)status);

    
    info_button_alignment = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(info_button_alignment), status->tac_info_button);
    
    g_signal_connect_swapped(G_OBJECT(status->tac_scroll_button),
                     "size-allocate",
                     G_CALLBACK(hxstatus_display_tac_ctrl_set_button_size),
                     status);
    
    scroll_hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(scroll_hbox), status->tac_entry, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(scroll_hbox), status->tac_scroll_button, FALSE, FALSE, 0);
    gtk_widget_show(scroll_hbox);

    scroll_alignment = gtk_alignment_new(0.5, 0.5, 1, 0);
    gtk_container_add(GTK_CONTAINER(scroll_alignment), scroll_hbox);
    
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_set_spacing(GTK_BOX(hbox), 5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), scroll_alignment, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), info_button_alignment, FALSE, FALSE, 0);
    
    gtk_container_add(GTK_CONTAINER(status), hbox);

    gtk_widget_set_size_request(image, 16, 16);

    gtk_widget_show_all(hbox);
    
    return GTK_WIDGET(status);
}

static void
hxstatus_display_tac_ctrl_rotate(HXStatusDisplayTACCtrl* tac_ctrl)
{
    gchar* tac_text = NULL;
    const gchar* prop;
    guint prop_count;
    guint i;
    gboolean result;
    HXStatusDisplay* status = HX_STATUS_DISPLAY(tac_ctrl);
    const gchar* tac_list[] =
    {
        "Title",
        "Author",
        "Copyright"
    };

    /* Restart rotate timer */
    hxstatus_display_stop_timer(HX_STATUS_DISPLAY(tac_ctrl));
    hxstatus_display_start_timer(HX_STATUS_DISPLAY(tac_ctrl));

    prop_count = sizeof(tac_list) / sizeof(*tac_list);
    
    for(i = 0; i < prop_count; i++)
    {
        GValue value;
        memset(&value, 0, sizeof(value));
        result = hx_player_get_statistic(status->player,
                                            tac_list[tac_ctrl->tac_next_property],
                                            &value);
        if(result)
        {
            prop = g_value_get_string(&value);
            tac_text = g_strdup_printf("%s: %s", tac_list[tac_ctrl->tac_next_property], prop);
            g_value_unset(&value);
            break;
        }

        tac_ctrl->tac_next_property = (tac_ctrl->tac_next_property + 1) % prop_count;
    }

   
    /* Change the displayed text */
    if(tac_text)
    {
        gtk_entry_set_text(GTK_ENTRY(tac_ctrl->tac_entry), tac_text);
        g_free(tac_text);
    }
    else
    {
        gtk_entry_set_text(GTK_ENTRY(tac_ctrl->tac_entry), "");
    }

    tac_ctrl->tac_next_property = (tac_ctrl->tac_next_property + 1) % prop_count;

}

void
hxstatus_display_clip_info_changed(HXStatusDisplayTACCtrl* status_tac)
{
    status_tac->tac_next_property = 0;
    hxstatus_display_tac_ctrl_rotate(status_tac);
}

static void
hxstatus_display_tac_ctrl_set_player(HXStatusDisplay* status, HXPlayer* player)
{ 
    HXStatusDisplayTACCtrl* status_tac = HX_STATUS_DISPLAY_TAC_CTRL(status);
    g_return_if_fail(status_tac != NULL);

    status_tac->tac_next_property = 0;

    if(status->player && status_tac->play_signal_handler >= 0)
    {
        g_signal_handler_disconnect(G_OBJECT(status->player),
                                    status_tac->play_signal_handler);
        status_tac->play_signal_handler = -1;
    }

    
    if(player)
    {
        status_tac->play_signal_handler =
            g_signal_connect_swapped(G_OBJECT(player),
                                     "play",
                                     GTK_SIGNAL_FUNC(hxstatus_display_clip_info_changed),
                                     (gpointer)status_tac);
    }


    HX_STATUS_DISPLAY_CLASS(g_parent_class)->set_player(status, player);

    if(player)
    {
        hxstatus_display_set_timer(status,
                                   TAC_CLIP_INFO_ROTATE_INTERVAL * 1000,
                                   hxstatus_display_tac_ctrl_rotate_timer_callback,
                                   status,
                                   FALSE,
                                   FALSE);
    }
}
