#
# hepmc_set_compiler_flags() 
#    sets the default compiler flags
#    calls hepmc_autoconf_variables
#
# hepmc_autoconf_variables() defines global variables
#

# some of the examples use fortran,
# so we need this for the example makefile
macro( _hepmc_fortran_compiler )

  EXEC_PROGRAM(${CMAKE_CXX_COMPILER}
    ARGS ${CMAKE_CXX_COMPILER_ARG1} -dumpversion
    OUTPUT_VARIABLE _my_COMPILER_VERSION
  )
  STRING(REGEX REPLACE "([0-9])\\.([0-9])(\\.[0-9])?" "\\1"
    _my_COMPILER_BASE_VERSION ${_my_COMPILER_VERSION})

  message(STATUS "compiler version: ${_my_COMPILER_VERSION}")
  #message(STATUS "compiler base version: ${_my_COMPILER_BASE_VERSION}")
  set(F77 "f77")
  if(CMAKE_COMPILER_IS_GNUCXX)
    if( ${_my_COMPILER_BASE_VERSION} MATCHES "3" )
       set(F77 "g77")
    else()
       set(F77 "gfortran")
    endif()
  endif(CMAKE_COMPILER_IS_GNUCXX)
  #message(STATUS "F77: ${F77}")

endmacro( _hepmc_fortran_compiler )

macro( hepmc_autoconf_variables )

  # these variables are used by <package>-config.in
  # typical values from autoconf:
  #   AM_CXXFLAGS = -O -ansi -pedantic -Wall -D_GNU_SOURCE
  #   CXXFLAGS = -g -O2
  #   CXX = g++
  #   CXXCPP = g++ -E
  #   CPPFLAGS = 
  #   CXXLD = $(CXX)
  #   AM_LDFLAGS = 
  #   LDFLAGS = 
  #   LIBS = 

  # automake/autoconf variables
  set( prefix      ${CMAKE_INSTALL_PREFIX} )
  set( exec_prefix "\${prefix}" )
  set( includedir  "\${prefix}/include" )
  set( configure_input "Generated by cmake" )

  set( CXX ${CMAKE_BASE_NAME} )
  set( CXXCPP       "${CXX} -E" )
  if( ${CMAKE_BUILD_TYPE} MATCHES "Debug" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_DEBUG} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "Release" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_RELEASE} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "RelWithDebInfo" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_RELWITHDEBINFO} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "MinSizeRel" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_MINSIZEREL} )
  endif()
  ##message( STATUS "build type ${CMAKE_BUILD_TYPE} has ${CXXFLAGS}")
  set( AM_CXXFLAGS  ${CMAKE_CXX_FLAGS} )
  set( LDFLAGS      ${CMAKE_MODULE_LINKER_FLAGS} )
  set( LIBS         "" )
  set( DIFF_Q       "diff -q -b" )
  if( ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
     message(STATUS "don't try to figure out fortran compiler for Windows")
  else()
  _hepmc_fortran_compiler()
  endif()

endmacro( hepmc_autoconf_variables )

macro( hepmc_set_compiler_flags )
  ##message(STATUS "incoming cmake build type is ${CMAKE_BUILD_TYPE}")
  if(NOT CMAKE_BUILD_TYPE)
    set(CMAKE_BUILD_TYPE RelWithDebInfo CACHE STRING "" FORCE)
  endif()
  message(STATUS "cmake build type is ${CMAKE_BUILD_TYPE}")
  if( CMAKE_COMPILER_IS_GNUCC )
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -O -ansi -pedantic -Wall -D_GNU_SOURCE")
  endif(CMAKE_COMPILER_IS_GNUCC)
  if(CMAKE_COMPILER_IS_GNUCXX)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -O -ansi -pedantic -Wall -D_GNU_SOURCE")
  endif(CMAKE_COMPILER_IS_GNUCXX)
  if( ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
    if( ${CMAKE_BASE_NAME} MATCHES "cl" )
      set(CMAKE_C_FLAGS "/EHsc /nologo /GR /MD")
      set(CMAKE_CXX_FLAGS "/EHsc /nologo /GR /MD")
    endif()
  endif()
  hepmc_autoconf_variables()
  message( STATUS "compiling with ${CMAKE_BASE_NAME} ${CMAKE_CXX_FLAGS} ${CXXFLAGS}")
endmacro( hepmc_set_compiler_flags )
