/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook;

import java.util.ArrayList;

import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.xiphias.dom.AbstractNodeVisitor;
import org.w3c.dom.Node;

public class PreprocessStage1 extends AbstractNodeVisitor {

	private ArrayList<Node> removeList;

	public PreprocessStage1(ArrayList<ProgressListener> listeners) {
		super(listeners);
		removeList = new ArrayList<Node>();
	}

	public void accept(Node node) {

		fireProgressEvent(node.toString(), ProgressEvent.STAGE_ACTION);
		
		if (node instanceof HtmlElement) {
			
			HtmlElement htmlElement = (HtmlElement) node;
			htmlElement.init();			
		}
	}

	public void finish() {
		removeNodes(removeList);
	}

	public void openTag(Node node) throws Exception {
		//
	}

	public void closeTag(Node node) throws Exception {
		//
	}
}
